/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer;

import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.ui.Workspace;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class HierarchyViewer {
    private static final CharSequence OS_WINDOWS = "Windows";
    private static final CharSequence OS_MACOSX = "Mac OS X";

    private static void initUserInterface() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.brushMetalLook", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "HierarchyViewer");
        String os = System.getProperty("os.name");
        try {
            if (os.contains(OS_WINDOWS) || os.contains(OS_MACOSX)) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HierarchyViewer.initUserInterface();
        DeviceBridge.initDebugBridge();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Workspace workspace = new Workspace();
                workspace.setDefaultCloseOperation(3);
                workspace.setLocationRelativeTo(null);
                workspace.setVisible(true);
            }
        });
    }
}

