/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.logging.Logger;
import com.vladium.util.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public interface IPathEnumerator {
    public void enumerate() throws IOException;

    public static abstract class Factory {
        public static IPathEnumerator create(File[] path, boolean canonical, IPathHandler handler) {
            return new PathEnumerator(path, canonical, handler);
        }

        private static final class PathEnumerator
        implements IPathEnumerator {
            private final ArrayList m_path;
            private final boolean m_canonical;
            private final Set m_pathSet;
            private final IPathHandler m_handler;
            private final boolean m_processManifest;
            private final Logger m_log;
            private boolean m_verbose;
            private boolean m_trace1;
            private int m_pathIndex;
            private File m_currentPathDir;
            private static final boolean IGNORE_INVALID_ENTRIES = true;

            public void enumerate() throws IOException {
                IPathHandler handler = this.m_handler;
                this.m_pathIndex = 0;
                while (this.m_pathIndex < this.m_path.size()) {
                    File f = (File)this.m_path.get(this.m_pathIndex);
                    if (f.exists()) {
                        if (f.isDirectory()) {
                            if (this.m_verbose) {
                                this.m_log.verbose("processing dir path entry [" + f.getAbsolutePath() + "] ...");
                            }
                            this.m_currentPathDir = f;
                            this.enumeratePathDir(null);
                        } else {
                            String name = f.getName();
                            String lcName = name.toLowerCase();
                            if (lcName.endsWith(".zip") || lcName.endsWith(".jar")) {
                                if (this.m_verbose) {
                                    this.m_log.verbose("processing archive path entry [" + f.getAbsolutePath() + "] ...");
                                }
                                File parent = f.getParentFile();
                                File archive = new File(name);
                                this.m_currentPathDir = parent;
                                this.enumeratePathArchive(name);
                                handler.handleArchiveEnd(parent, archive);
                            }
                        }
                    }
                    ++this.m_pathIndex;
                }
            }

            PathEnumerator(File[] path, boolean canonical, IPathHandler handler) {
                int p;
                this.m_path = new ArrayList(path.length);
                for (p = 0; p < path.length; ++p) {
                    this.m_path.add(path[p]);
                }
                this.m_canonical = canonical;
                if (handler == null) {
                    throw new IllegalArgumentException("null input: handler");
                }
                this.m_handler = handler;
                this.m_processManifest = true;
                if (this.m_processManifest) {
                    this.m_pathSet = new HashSet(path.length);
                    for (p = 0; p < path.length; ++p) {
                        this.m_pathSet.add(path[p].getPath());
                    }
                } else {
                    this.m_pathSet = null;
                }
                this.m_log = Logger.getLogger();
                this.m_verbose = this.m_log.atVERBOSE();
                this.m_trace1 = this.m_log.atTRACE1();
            }

            private void enumeratePathDir(String dir) throws IOException {
                boolean trace1 = this.m_trace1;
                File currentPathDir = this.m_currentPathDir;
                File fullDir = dir != null ? new File(currentPathDir, dir) : currentPathDir;
                String[] children = fullDir.list();
                IPathHandler handler = this.m_handler;
                for (String childName : children) {
                    File child = dir != null ? new File(dir, childName) : new File(childName);
                    File fullChild = new File(fullDir, childName);
                    if (fullChild.isDirectory()) {
                        handler.handleDirStart(currentPathDir, child);
                        if (trace1) {
                            this.m_log.trace1("enumeratePathDir", "recursing into [" + child.getName() + "] ...");
                        }
                        this.enumeratePathDir(child.getPath());
                        handler.handleDirEnd(currentPathDir, child);
                        continue;
                    }
                    if (trace1) {
                        this.m_log.trace1("enumeratePathDir", "processing file [" + child.getName() + "] ...");
                    }
                    handler.handleFile(currentPathDir, child);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void enumeratePathArchive(String archive) throws IOException {
                boolean trace1 = this.m_trace1;
                File fullArchive = new File(this.m_currentPathDir, archive);
                ZipInputStream in = null;
                try {
                    ZipEntry entry;
                    in = new JarInputStream(new BufferedInputStream(new FileInputStream(fullArchive), 32768));
                    IPathHandler handler = this.m_handler;
                    Manifest manifest = ((JarInputStream)in).getManifest();
                    if (manifest == null) {
                        manifest = PathEnumerator.readManifestViaJarFile(fullArchive);
                    }
                    handler.handleArchiveStart(this.m_currentPathDir, new File(archive), manifest);
                    while ((entry = ((JarInputStream)in).getNextEntry()) != null) {
                        if (trace1) {
                            this.m_log.trace1("enumeratePathArchive", "processing archive entry [" + entry.getName() + "] ...");
                        }
                        handler.handleArchiveEntry((JarInputStream)in, entry);
                        in.closeEntry();
                    }
                    if (this.m_processManifest) {
                        String jarClassPath;
                        Attributes attributes;
                        if (manifest == null) {
                            manifest = ((JarInputStream)in).getManifest();
                        }
                        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (jarClassPath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(jarClassPath);
                            int p = 1;
                            while (tokenizer.hasMoreTokens()) {
                                String relPath = tokenizer.nextToken();
                                File archiveParent = fullArchive.getParentFile();
                                File path = archiveParent != null ? new File(archiveParent, relPath) : new File(relPath);
                                String fullPath = this.m_canonical ? Files.canonicalizePathname(path.getPath()) : path.getPath();
                                if (!this.m_pathSet.add(fullPath)) continue;
                                if (this.m_verbose) {
                                    this.m_log.verbose("  added manifest Class-Path entry [" + path + "]");
                                }
                                this.m_path.add(this.m_pathIndex + p++, path);
                            }
                        }
                    }
                }
                catch (FileNotFoundException fnfe) {
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ignore) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static Manifest readManifestViaJarFile(File archive) {
                Manifest result = null;
                JarFile jarfile = null;
                try {
                    jarfile = new JarFile(archive, false);
                    result = jarfile.getManifest();
                }
                catch (IOException ignore) {
                }
                finally {
                    if (jarfile != null) {
                        try {
                            jarfile.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                return result;
            }
        }
    }

    public static interface IPathHandler {
        public void handleDirStart(File var1, File var2);

        public void handleFile(File var1, File var2);

        public void handleDirEnd(File var1, File var2);

        public void handleArchiveStart(File var1, File var2, Manifest var3);

        public void handleArchiveEntry(JarInputStream var1, ZipEntry var2);

        public void handleArchiveEnd(File var1, File var2);
    }
}

