/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.IAppConstants;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RTCoverageDataPersister;
import com.vladium.emma.rt.RTExitHook;
import com.vladium.emma.rt.RTSettings;
import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exit.ExitHookManager;
import java.io.File;

public abstract class RT
implements IAppConstants {
    private static ICoverageData s_cdata;
    private static Runnable s_exitHook;
    private static IProperties s_appProperties;
    private static final ExitHookManager EXIT_HOOK_MANAGER;
    private static final boolean DEBUG = false;

    public static synchronized ICoverageData reset(boolean createCoverageData, boolean createExitHook) {
        ClassLoader loader = RT.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        IProperties appProperties = null;
        try {
            appProperties = EMMAProperties.getAppProperties(loader);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        s_appProperties = appProperties;
        if (EXIT_HOOK_MANAGER != null && s_exitHook != null) {
            EXIT_HOOK_MANAGER.removeExitHook(s_exitHook);
            s_exitHook = null;
        }
        ICoverageData cdata = s_cdata;
        s_cdata = createCoverageData ? (cdata = DataFactory.newCoverageData()) : null;
        if (EXIT_HOOK_MANAGER != null && createExitHook && cdata != null) {
            RTExitHook exitHook = new RTExitHook(RT.class, cdata, RT.getCoverageOutFile(), RT.getCoverageOutMerge());
            RTExitHook.createClassLoaderClosure();
            if (EXIT_HOOK_MANAGER.addExitHook(exitHook)) {
                s_exitHook = exitHook;
            }
        }
        return cdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void r(boolean[][] coverage, String classVMName, long stamp) {
        ICoverageData cdata = RT.getCoverageData();
        if (cdata != null) {
            Object object = cdata.lock();
            synchronized (object) {
                cdata.addClass(coverage, classVMName, stamp);
            }
        }
    }

    public static synchronized ICoverageData getCoverageData() {
        return s_cdata;
    }

    public static synchronized IProperties getAppProperties() {
        return s_appProperties;
    }

    public static synchronized void dumpCoverageData(File outFile, boolean merge, boolean stopDataCollection) {
        outFile = outFile != null ? outFile : RT.getCoverageOutFile();
        ICoverageData cdata = s_cdata;
        if (stopDataCollection) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(cdata, !stopDataCollection, outFile, merge);
    }

    public static synchronized void dumpCoverageData(File outFile, boolean stopDataCollection) {
        outFile = outFile != null ? outFile : RT.getCoverageOutFile();
        ICoverageData cdata = s_cdata;
        if (stopDataCollection) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(cdata, !stopDataCollection, outFile, RT.getCoverageOutMerge());
    }

    private RT() {
    }

    private static File getCoverageOutFile() {
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty("coverage.out.file", "coverage.ec");
            return new File(property);
        }
        return new File("coverage.ec");
    }

    private static boolean getCoverageOutMerge() {
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty("coverage.out.merge", EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE.toString());
            return Property.toBoolean(property);
        }
        return EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE;
    }

    static {
        ExitHookManager temp = null;
        try {
            temp = ExitHookManager.getSingleton();
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        EXIT_HOOK_MANAGER = temp;
        if (RTSettings.isStandaloneMode()) {
            RT.reset(true, true);
            Logger log = Logger.getLogger();
            if (log.atINFO()) {
                log.info("collecting runtime coverage data ...");
            }
        } else {
            RT.reset(false, false);
        }
    }
}

