/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.emma.report.MethodItem;
import com.vladium.util.IntObjectMap;
import java.util.Iterator;

public final class ClassItem
extends Item {
    final ClassDescriptor m_cls;
    final boolean[][] m_coverage;
    private int m_firstLine;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(3, "class", 31L);

    public ClassItem(IItem parent, ClassDescriptor cls, boolean[][] coverage) {
        super(parent);
        this.m_cls = cls;
        this.m_coverage = coverage;
    }

    public String getName() {
        return this.m_cls.getName();
    }

    public String getSrcFileName() {
        return this.m_cls.getSrcFileName();
    }

    public int getFirstLine() {
        if (this.m_firstLine == 0) {
            MethodDescriptor[] methods = this.m_cls.getMethods();
            int firstLine = Integer.MAX_VALUE;
            int mLimit = methods.length;
            for (int m = 0; m < mLimit; ++m) {
                int mFirstLine = methods[m].getFirstLine();
                if (mFirstLine <= 0 || mFirstLine >= firstLine) continue;
                firstLine = mFirstLine;
            }
            this.m_firstLine = firstLine;
            return firstLine;
        }
        return this.m_firstLine;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cls;
    }

    public boolean[][] getCoverage() {
        return this.m_coverage;
    }

    public boolean loaded() {
        return this.m_coverage != null;
    }

    public int getAggregate(int type) {
        int[] aggregates = this.m_aggregates;
        int value = aggregates[type];
        if (value < 0) {
            switch (type) {
                case 5: 
                case 11: {
                    aggregates[11] = 1;
                    aggregates[5] = this.m_coverage != null ? 1 : 0;
                    return aggregates[type];
                }
                case 1: 
                case 3: 
                case 7: {
                    boolean[][] ccoverage = this.m_coverage;
                    IntObjectMap cldata = new IntObjectMap();
                    MethodDescriptor[] methoddescs = this.m_cls.getMethods();
                    Iterator methods = this.getChildren();
                    while (methods.hasNext()) {
                        MethodItem method = (MethodItem)methods.next();
                        int methodID = method.getID();
                        boolean[] mcoverage = ccoverage == null ? null : ccoverage[methodID];
                        MethodDescriptor methoddesc = methoddescs[methodID];
                        int[] mbsizes = methoddesc.getBlockSizes();
                        IntObjectMap mlineMap = methoddesc.getLineMap();
                        for (int mline : mlineMap.keys()) {
                            int[] data = (int[])cldata.get(mline);
                            if (data == null) {
                                data = new int[4];
                                cldata.put(mline, data);
                            }
                            int[] lblocks = (int[])mlineMap.get(mline);
                            int bCount = lblocks.length;
                            data[0] = data[0] + bCount;
                            for (int bID = 0; bID < bCount; ++bID) {
                                int block = lblocks[bID];
                                boolean bcovered = mcoverage != null && mcoverage[block];
                                int instr = mbsizes[block];
                                data[1] = data[1] + instr;
                                if (!bcovered) continue;
                                data[2] = data[2] + 1;
                                data[3] = data[3] + instr;
                            }
                        }
                    }
                    aggregates[7] = cldata.size();
                    int coverageLineCount = 0;
                    int coverageLineInstr = 0;
                    for (int cline : cldata.keys()) {
                        int[] data = (int[])cldata.get(cline);
                        int ltotalCount = data[0];
                        int ltotalInstr = data[1];
                        int lcoverageCount = data[2];
                        int lcoverageInstr = data[3];
                        if (lcoverageInstr <= 0) continue;
                        coverageLineCount += 100 * lcoverageCount / ltotalCount;
                        coverageLineInstr += 100 * lcoverageInstr / ltotalInstr;
                    }
                    aggregates[1] = coverageLineCount;
                    aggregates[3] = coverageLineInstr;
                    return aggregates[type];
                }
            }
            return super.getAggregate(type);
        }
        return value;
    }

    public void accept(IItemVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }
}

