/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.CoverageData;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.MetaData;
import com.vladium.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;

public abstract class DataFactory {
    public static final byte TYPE_METADATA = 0;
    public static final byte TYPE_COVERAGEDATA = 1;
    private static final int NULL_ARRAY_LENGTH = -1;
    private static final int MAGIC = 1162693953;
    private static final long UNKNOWN = 0L;
    private static final int FILE_HEADER_LENGTH = 24;
    private static final int ENTRY_HEADER_LENGTH = 9;
    private static final boolean DO_FSYNC = true;
    private static final int IO_BUF_SIZE = 32768;

    public static IMergeable[] load(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        return DataFactory.mergeload(file);
    }

    public static void persist(IMetaData data, File file, boolean merge) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!merge && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)data, (byte)0, file);
    }

    public static void persist(ICoverageData data, File file, boolean merge) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!merge && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)data, (byte)1, file);
    }

    public static void persist(ISessionData data, File file, boolean merge) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!merge && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)data.getMetaData(), (byte)0, file);
        DataFactory.persist((IMergeable)data.getCoverageData(), (byte)1, file);
    }

    public static IMetaData newMetaData(CoverageOptions options) {
        return new MetaData(options);
    }

    public static ICoverageData newCoverageData() {
        return new CoverageData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMetaData readMetaData(URL url) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = null;
        try {
            oin = new ObjectInputStream(new BufferedInputStream(url.openStream(), 32768));
            IMetaData iMetaData = (IMetaData)oin.readObject();
            return iMetaData;
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeMetaData(IMetaData data, OutputStream out) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetaData(IMetaData data, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            DataFactory.writeMetaData(data, out);
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICoverageData readCoverageData(URL url) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = null;
        try {
            oin = new ObjectInputStream(new BufferedInputStream(url.openStream(), 32768));
            ICoverageData iCoverageData = (ICoverageData)oin.readObject();
            return iCoverageData;
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeCoverageData(ICoverageData data, OutputStream out) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(data);
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        int[] result = new int[length];
        int i = length;
        while (--i >= 0) {
            result[i] = in.readInt();
        }
        return result;
    }

    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        boolean[] result = new boolean[length];
        int i = length;
        while (--i >= 0) {
            result[i] = in.readBoolean();
        }
        return result;
    }

    public static void writeIntArray(int[] array, DataOutput out) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            int i = length;
            while (--i >= 0) {
                out.writeInt(array[i]);
            }
        }
    }

    public static void writeBooleanArray(boolean[] array, DataOutput out) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            int i = length;
            while (--i >= 0) {
                out.writeBoolean(array[i]);
            }
        }
    }

    private DataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IMergeable[] mergeload(File file) throws IOException {
        IMergeable[] result;
        long start;
        boolean trace1;
        Logger log;
        block21: {
            log = Logger.getLogger();
            trace1 = log.atTRACE1();
            boolean trace2 = log.atTRACE2();
            String method = "mergeload";
            start = 0L;
            if (trace1) {
                start = System.currentTimeMillis();
            }
            result = new IMergeable[2];
            if (!file.exists()) {
                throw new IOException("input file does not exist: [" + file.getAbsolutePath() + "]");
            }
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(file, "r");
                long length = raf.length();
                if (trace1) {
                    log.trace1("mergeload", "[" + file + "]: file length = " + length);
                }
                if (length < 24L) {
                    throw new IOException("file [" + file.getAbsolutePath() + "] is corrupt or was not created by " + "EMMA");
                }
                if (length <= 24L) break block21;
                raf.seek(24L);
                long position = 24L;
                long entrystart = 0L;
                while (true) {
                    IMergeable current;
                    if (trace2) {
                        log.trace2("mergeload", "[" + file + "]: position " + raf.getFilePointer());
                    }
                    if (position >= length) {
                        break;
                    }
                    long entryLength = raf.readLong();
                    if (entryLength <= 0L) break;
                    if (position + entryLength + 9L > length) {
                        break;
                    }
                    byte type = raf.readByte();
                    if (type < 0) break;
                    if (type >= result.length) {
                        break;
                    }
                    if (trace2) {
                        log.trace2("mergeload", "[" + file + "]: found valid entry of size " + entryLength + " and type " + type);
                    }
                    if (trace2) {
                        entrystart = System.currentTimeMillis();
                    }
                    IMergeable data = DataFactory.readEntry(raf, type, entryLength);
                    if (trace2) {
                        log.trace2("mergeload", "entry read in " + (System.currentTimeMillis() - entrystart) + " ms");
                    }
                    result[type] = (current = result[type]) == null ? data : current.merge(data);
                    raf.seek(position += entryLength + 9L);
                }
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable ignore) {}
                }
                raf = null;
            }
        }
        if (trace1) {
            long end = System.currentTimeMillis();
            log.trace1("mergeload", "[" + file + "]: file processed in " + (end - start) + " ms");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persist(IMergeable data, byte type, File file) throws IOException {
        Logger log = Logger.getLogger();
        boolean trace1 = log.atTRACE1();
        boolean trace2 = log.atTRACE2();
        String method = "persist";
        long start = 0L;
        if (trace1) {
            start = System.currentTimeMillis();
        }
        RandomAccessFile raf = null;
        try {
            boolean overwrite = false;
            boolean truncate = false;
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new IOException("can persist in normal files only: " + file.getAbsolutePath());
                }
                raf = new RandomAccessFile(file, "rw");
                long length = raf.length();
                if (trace1) {
                    log.trace1("persist", "[" + file + "]: existing file length = " + length);
                }
                if (length < 4L) {
                    overwrite = true;
                    truncate = length > 0L;
                } else {
                    int magic = raf.readInt();
                    if (magic != 1162693953) {
                        throw new IOException("cannot overwrite [" + file.getAbsolutePath() + "]: not created by " + "EMMA");
                    }
                    if (length < 24L) {
                        overwrite = true;
                        truncate = true;
                    } else {
                        long dataVersion = raf.readLong();
                        if (dataVersion != 32L) {
                            int major = 0;
                            int minor = 0;
                            int build = 0;
                            boolean gotAppVersion = false;
                            try {
                                major = raf.readInt();
                                minor = raf.readInt();
                                build = raf.readInt();
                                gotAppVersion = true;
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            if (gotAppVersion) {
                                throw new IOException("cannot merge new data into [" + file.getAbsolutePath() + "]: created by another " + "EMMA" + " version [" + DataFactory.makeAppVersion(major, minor, build) + "]");
                            }
                            throw new IOException("cannot merge new data into [" + file.getAbsolutePath() + "]: created by another " + "EMMA" + " version");
                        }
                        raf.seek(24L);
                        if (length == 24L) {
                            DataFactory.writeEntry(log, raf, 24L, data, type);
                        } else {
                            long position = 24L;
                            while (true) {
                                long entryLength;
                                if (trace2) {
                                    log.trace2("persist", "[" + file + "]: position " + raf.getFilePointer());
                                }
                                if (position >= length || (entryLength = raf.readLong()) <= 0L || position + entryLength + 9L > length) break;
                                if (trace2) {
                                    log.trace2("persist", "[" + file + "]: found valid entry of size " + entryLength);
                                }
                                raf.seek(position += entryLength + 9L);
                            }
                            if (trace2) {
                                log.trace2("persist", "[" + file + "]: adding entry at position " + position);
                            }
                            DataFactory.writeEntry(log, raf, position, data, type);
                        }
                    }
                }
            } else {
                File parent;
                if (trace1) {
                    log.trace1("persist", "[" + file + "]: creating a new file");
                }
                if ((parent = file.getParentFile()) != null) {
                    parent.mkdirs();
                }
                raf = new RandomAccessFile(file, "rw");
                overwrite = true;
            }
            if (overwrite) {
                if (truncate) {
                    raf.seek(0L);
                }
                DataFactory.writeFileHeader(raf);
                DataFactory.writeEntry(log, raf, 24L, data, type);
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Throwable ignore) {}
            }
            raf = null;
        }
        if (trace1) {
            long end = System.currentTimeMillis();
            log.trace1("persist", "[" + file + "]: file processed in " + (end - start) + " ms");
        }
    }

    private static void writeFileHeader(DataOutput out) throws IOException {
        out.writeInt(1162693953);
        out.writeLong(32L);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
    }

    private static void writeEntryHeader(DataOutput out, byte type) throws IOException {
        out.writeLong(0L);
        out.writeByte(type);
    }

    private static void writeEntry(Logger log, RandomAccessFile raf, long marker, IMergeable data, byte type) throws IOException {
        DataFactory.writeEntryHeader(raf, type);
        RandomAccessFileOutputStream rafout = new RandomAccessFileOutputStream(raf, 32768);
        DataOutputStream dout = new DataOutputStream(rafout);
        switch (type) {
            case 0: {
                MetaData.writeExternal((MetaData)data, dout);
                break;
            }
            default: {
                CoverageData.writeExternal((CoverageData)data, dout);
            }
        }
        dout.flush();
        dout = null;
        raf.setLength(raf.getFilePointer());
        raf.seek(marker);
        raf.writeLong(rafout.getCount());
        raf.getFD().sync();
        if (log.atTRACE2()) {
            log.trace2("writeEntry", "entry [" + data.getClass().getName() + "] length: " + rafout.getCount());
        }
    }

    private static IMergeable readEntry(RandomAccessFile raf, byte type, long entryLength) throws IOException {
        IMergeable data;
        RandomAccessFileInputStream rafin = new RandomAccessFileInputStream(raf, 32768);
        DataInputStream din = new DataInputStream(rafin);
        switch (type) {
            case 0: {
                data = MetaData.readExternal(din);
                break;
            }
            default: {
                data = CoverageData.readExternal(din);
            }
        }
        return data;
    }

    private static String makeAppVersion(int major, int minor, int build) {
        StringBuffer buf = new StringBuffer();
        buf.append(major);
        buf.append('.');
        buf.append(minor);
        buf.append('.');
        buf.append(build);
        return buf.toString();
    }

    private static final class RandomAccessFileOutputStream
    extends BufferedOutputStream {
        private long m_count;

        public final void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.m_count += (long)len;
        }

        public final void write(byte[] b) throws IOException {
            super.write(b);
            this.m_count += (long)b.length;
        }

        public final void write(int b) throws IOException {
            super.write(b);
            ++this.m_count;
        }

        public void close() {
        }

        RandomAccessFileOutputStream(RandomAccessFile raf, int bufSize) throws IOException {
            super(new UCFileOutputStream(raf.getFD()), bufSize);
        }

        final long getCount() {
            return this.m_count;
        }
    }

    private static final class RandomAccessFileInputStream
    extends BufferedInputStream {
        private long m_count;

        public final int read() throws IOException {
            int rc = super.read();
            if (rc >= 0) {
                ++this.m_count;
            }
            return rc;
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            int rc = super.read(b, off, len);
            if (rc >= 0) {
                this.m_count += (long)rc;
            }
            return rc;
        }

        public final int read(byte[] b) throws IOException {
            int rc = super.read(b);
            if (rc >= 0) {
                this.m_count += (long)rc;
            }
            return rc;
        }

        public void close() {
        }

        RandomAccessFileInputStream(RandomAccessFile raf, int bufSize) throws IOException {
            super(new UCFileInputStream(raf.getFD()), bufSize);
        }

        final long getCount() {
            return this.m_count;
        }
    }

    private static final class UCFileOutputStream
    extends FileOutputStream {
        public void close() {
        }

        UCFileOutputStream(FileDescriptor fd) {
            super(fd);
        }
    }

    private static final class UCFileInputStream
    extends FileInputStream {
        public void close() {
        }

        UCFileInputStream(FileDescriptor fd) {
            super(fd);
        }
    }
}

