/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.DxConsole;
import com.android.dx.command.UsageException;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.cf.CodeStatistics;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstUtf8;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String DEX_IN_JAR_NAME = "classes.dex";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sound", "sql", "swing", "transaction", "xml"};
    private static int warnings = 0;
    private static int errors = 0;
    private static Arguments args;
    private static DexFile outputDex;
    private static TreeMap<String, byte[]> outputResources;

    private Main() {
    }

    public static void main(String[] argArray) {
        Arguments arguments = new Arguments();
        arguments.parse(argArray);
        int result = Main.run(arguments);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static int run(Arguments arguments) {
        warnings = 0;
        errors = 0;
        args = arguments;
        Main.args.makeCfOptions();
        if (!Main.processAllFiles()) {
            return 1;
        }
        byte[] outArray = Main.writeDex();
        if (outArray == null) {
            return 2;
        }
        if (Main.args.jarOutput) {
            outputDex = null;
            if (!Main.createJar(Main.args.outName, outArray)) {
                return 3;
            }
        }
        return 0;
    }

    private static boolean processAllFiles() {
        outputDex = new DexFile();
        if (Main.args.jarOutput) {
            outputResources = new TreeMap();
        }
        if (Main.args.dumpWidth != 0) {
            outputDex.setDumpWidth(Main.args.dumpWidth);
        }
        boolean any = false;
        String[] fileNames = Main.args.fileNames;
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                any |= Main.processOne(fileNames[i]);
            }
        }
        catch (StopProcessing stopProcessing) {
            // empty catch block
        }
        if (warnings != 0) {
            DxConsole.err.println(warnings + " warning" + (warnings == 1 ? "" : "s"));
        }
        if (errors != 0) {
            DxConsole.err.println(errors + " error" + (errors == 1 ? "" : "s") + "; aborting");
            return false;
        }
        if (!any && !Main.args.emptyOk) {
            DxConsole.err.println("no classfiles specified");
            return false;
        }
        if (Main.args.optimize && Main.args.statistics) {
            CodeStatistics.dumpStatistics(DxConsole.out);
        }
        return true;
    }

    private static boolean processOne(String pathname) {
        ClassPathOpener opener = new ClassPathOpener(pathname, false, new ClassPathOpener.Consumer(){

            public boolean processFileBytes(String name, byte[] bytes) {
                return Main.processFileBytes(name, bytes);
            }

            public void onException(Exception ex) {
                if (ex instanceof StopProcessing) {
                    throw (StopProcessing)ex;
                }
                DxConsole.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                ex.printStackTrace(DxConsole.err);
                errors++;
            }

            public void onProcessArchiveStart(File file) {
                if (args.verbose) {
                    DxConsole.out.println("processing archive " + file + "...");
                }
            }
        });
        return opener.process();
    }

    private static boolean processFileBytes(String name, byte[] bytes) {
        boolean keepResources;
        boolean isClass = name.endsWith(".class");
        boolean bl = keepResources = outputResources != null;
        if (!isClass && !keepResources) {
            if (Main.args.verbose) {
                DxConsole.out.println("ignored resource " + name);
            }
            return false;
        }
        if (Main.args.verbose) {
            DxConsole.out.println("processing " + name + "...");
        }
        String fixedName = Main.fixPath(name);
        if (isClass) {
            if (keepResources && Main.args.keepClassesInJar) {
                outputResources.put(fixedName, bytes);
            }
            return Main.processClass(fixedName, bytes);
        }
        outputResources.put(fixedName, bytes);
        return true;
    }

    private static boolean processClass(String name, byte[] bytes) {
        if (!Main.args.coreLibrary) {
            Main.checkClassName(name);
        }
        try {
            ClassDefItem clazz = CfTranslator.translate(name, bytes, Main.args.cfOptions);
            outputDex.add(clazz);
            return true;
        }
        catch (ParseException ex) {
            DxConsole.err.println("\ntrouble processing:");
            if (Main.args.debug) {
                ex.printStackTrace(DxConsole.err);
            } else {
                ex.printContext(DxConsole.err);
            }
            ++warnings;
            return false;
        }
    }

    private static void checkClassName(String name) {
        boolean bogus = false;
        if (name.startsWith("java/")) {
            bogus = true;
        } else if (name.startsWith("javax/")) {
            int slashAt = name.indexOf(47, 6);
            if (slashAt == -1) {
                bogus = true;
            } else {
                String pkg = name.substring(6, slashAt);
                boolean bl = bogus = Arrays.binarySearch(JAVAX_CORE, pkg) >= 0;
            }
        }
        if (!bogus) {
            return;
        }
        DxConsole.err.println("\ntrouble processing \"" + name + "\":\n\n" + IN_RE_CORE_CLASSES);
        ++errors;
        throw new StopProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] writeDex() {
        byte[] outArray = null;
        try {
            OutputStream humanOutRaw;
            OutputStream out;
            block12: {
                out = null;
                humanOutRaw = null;
                OutputStreamWriter humanOut = null;
                try {
                    if (Main.args.humanOutName != null) {
                        humanOutRaw = Main.openOutput(Main.args.humanOutName);
                        humanOut = new OutputStreamWriter(humanOutRaw);
                    }
                    if (Main.args.methodToDump != null) {
                        outputDex.toDex(null, false);
                        Main.dumpMethod(outputDex, Main.args.methodToDump, humanOut);
                    } else {
                        outArray = outputDex.toDex(humanOut, Main.args.verboseDump);
                        if (Main.args.outName != null && !Main.args.jarOutput) {
                            out = Main.openOutput(Main.args.outName);
                            out.write(outArray);
                        }
                    }
                    if (Main.args.statistics) {
                        DxConsole.out.println(outputDex.getStatistics().toHuman());
                    }
                    if (humanOut == null) break block12;
                }
                catch (Throwable throwable) {
                    if (humanOut != null) {
                        humanOut.flush();
                    }
                    Main.closeOutput(out);
                    Main.closeOutput(humanOutRaw);
                    throw throwable;
                }
                humanOut.flush();
            }
            Main.closeOutput(out);
            Main.closeOutput(humanOutRaw);
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return null;
        }
        return outArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJar(String fileName, byte[] dexArray) {
        try {
            Manifest manifest = Main.makeManifest();
            OutputStream out = Main.openOutput(fileName);
            JarOutputStream jarOut = new JarOutputStream(out, manifest);
            outputResources.put(DEX_IN_JAR_NAME, dexArray);
            try {
                for (Map.Entry<String, byte[]> e : outputResources.entrySet()) {
                    String name = e.getKey();
                    byte[] contents = e.getValue();
                    JarEntry entry = new JarEntry(name);
                    if (Main.args.verbose) {
                        DxConsole.out.println("writing " + name + "; size " + contents.length + "...");
                    }
                    entry.setSize(contents.length);
                    jarOut.putNextEntry(entry);
                    jarOut.write(contents);
                    jarOut.closeEntry();
                }
            }
            finally {
                jarOut.finish();
                jarOut.flush();
                Main.closeOutput(out);
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private static Manifest makeManifest() throws IOException {
        Attributes attribs;
        Manifest manifest;
        byte[] manifestBytes = outputResources.get(MANIFEST_NAME);
        if (manifestBytes == null) {
            manifest = new Manifest();
            attribs = manifest.getMainAttributes();
            attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
            attribs = manifest.getMainAttributes();
            outputResources.remove(MANIFEST_NAME);
        }
        String createdBy = attribs.getValue(CREATED_BY);
        createdBy = createdBy == null ? "" : createdBy + " + ";
        createdBy = createdBy + "dx 1.5";
        attribs.put(CREATED_BY, createdBy);
        attribs.putValue("Dex-Location", DEX_IN_JAR_NAME);
        return manifest;
    }

    private static OutputStream openOutput(String name) throws IOException {
        if (name.equals("-") || name.startsWith("-.")) {
            return System.out;
        }
        return new FileOutputStream(name);
    }

    private static void closeOutput(OutputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        stream.flush();
        if (stream != System.out) {
            stream.close();
        }
    }

    private static String fixPath(String path) {
        int index;
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if ((index = path.lastIndexOf("/./")) != -1) {
            return path.substring(index + 3);
        }
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    private static void dumpMethod(DexFile dex, String fqName, OutputStreamWriter out) {
        boolean wildcard = fqName.endsWith("*");
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == fqName.length() - 1) {
            DxConsole.err.println("bogus fully-qualified method name: " + fqName);
            return;
        }
        String className = fqName.substring(0, lastDot).replace('.', '/');
        String methodName = fqName.substring(lastDot + 1);
        ClassDefItem clazz = dex.getClassOrNull(className);
        if (clazz == null) {
            DxConsole.err.println("no such class: " + className);
            return;
        }
        if (wildcard) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        ArrayList<EncodedMethod> allMeths = clazz.getMethods();
        TreeMap<CstNat, EncodedMethod> meths = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod meth : allMeths) {
            String methName = meth.getName().getString();
            if ((!wildcard || !methName.startsWith(methodName)) && (wildcard || !methName.equals(methodName))) continue;
            meths.put(meth.getRef().getNat(), meth);
        }
        if (meths.size() == 0) {
            DxConsole.err.println("no such method: " + fqName);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        for (EncodedMethod meth : meths.values()) {
            meth.debugPrint(pw, Main.args.verboseDump);
            CstUtf8 sourceFile = clazz.getSourceFile();
            if (sourceFile != null) {
                pw.println("  source file: " + sourceFile.toQuoted());
            }
            Annotations methodAnnotations = clazz.getMethodAnnotations(meth.getRef());
            AnnotationsList parameterAnnotations = clazz.getParameterAnnotations(meth.getRef());
            if (methodAnnotations != null) {
                pw.println("  method annotations:");
                for (Annotation a : methodAnnotations.getAnnotations()) {
                    pw.println("    " + a);
                }
            }
            if (parameterAnnotations == null) continue;
            pw.println("  parameter annotations:");
            int sz = parameterAnnotations.size();
            for (int i = 0; i < sz; ++i) {
                pw.println("    parameter " + i);
                Annotations annotations = parameterAnnotations.get(i);
                for (Annotation a : annotations.getAnnotations()) {
                    pw.println("      " + a);
                }
            }
        }
        pw.flush();
    }

    public static class Arguments {
        public boolean debug = false;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;

        public void parse(String[] args) {
            String arg;
            int at;
            for (at = 0; at < args.length && !(arg = args[at]).equals("--") && arg.startsWith("--"); ++at) {
                if (arg.equals("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (arg.equals("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (arg.equals("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (arg.equals("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (arg.equals("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (arg.equals("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (arg.equals("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (arg.equals("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (arg.startsWith("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (arg.startsWith("--output=")) {
                    this.outName = arg.substring(arg.indexOf(61) + 1);
                    if (this.outName.endsWith(".zip") || this.outName.endsWith(".jar") || this.outName.endsWith(".apk")) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(".dex") || this.outName.equals("-")) {
                        this.jarOutput = false;
                        continue;
                    }
                    System.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (arg.startsWith("--dump-to=")) {
                    this.humanOutName = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--dump-width=")) {
                    arg = arg.substring(arg.indexOf(61) + 1);
                    this.dumpWidth = Integer.parseInt(arg);
                    continue;
                }
                if (arg.startsWith("--dump-method=")) {
                    this.methodToDump = arg.substring(arg.indexOf(61) + 1);
                    this.jarOutput = false;
                    continue;
                }
                if (arg.startsWith("--positions=")) {
                    String pstr = arg.substring(arg.indexOf(61) + 1).intern();
                    if (pstr == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (pstr == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (pstr == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    System.err.println("unknown positions option: " + pstr);
                    throw new UsageException();
                }
                if (arg.equals("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                System.err.println("unknown option: " + arg);
                throw new UsageException();
            }
            int fileCount = args.length - at;
            if (fileCount == 0) {
                if (!this.emptyOk) {
                    System.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                System.out.println("ignoring input files");
                at = 0;
                fileCount = 0;
            }
            this.fileNames = new String[fileCount];
            System.arraycopy(args, at, this.fileNames, 0, fileCount);
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            this.makeCfOptions();
        }

        private void makeCfOptions() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = DxConsole.err;
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }
}

