/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.TreeSet;
import org.clearsilver.HDF;

public class SampleCode {
    String mSource;
    String mDest;
    String mTitle;
    public static String[] IMAGES = new String[]{".png", ".jpg", ".gif"};
    public static String[] TEMPLATED = new String[]{".java", ".xml"};

    public SampleCode(String source, String dest, String title) {
        this.mSource = source;
        this.mTitle = title;
        int len = dest.length();
        this.mDest = len > 1 && dest.charAt(len - 1) != '/' ? dest + '/' : dest;
    }

    public void write(boolean offlineMode) {
        File f = new File(this.mSource);
        if (!f.isDirectory()) {
            System.out.println("-samplecode not a directory: " + this.mSource);
            return;
        }
        if (offlineMode) {
            this.writeIndexOnly(f, this.mDest, offlineMode);
        } else {
            this.writeDirectory(f, this.mDest);
        }
    }

    public static String convertExtension(String s, String ext) {
        return s.substring(0, s.lastIndexOf(46)) + ext;
    }

    public static boolean inList(String s, String[] list) {
        for (String t : list) {
            if (!s.endsWith(t)) continue;
            return true;
        }
        return false;
    }

    public void writeDirectory(File dir, String relative) {
        TreeSet<String> dirs = new TreeSet<String>();
        TreeSet<String> files = new TreeSet<String>();
        String subdir = relative;
        for (File file : dir.listFiles()) {
            String name = file.getName();
            if (name.startsWith(".") || name.startsWith("_")) continue;
            if (file.isFile()) {
                String out = relative + name;
                if (SampleCode.inList(out, IMAGES)) {
                    ClearPage.copyFile(file, out);
                    this.writeImagePage(file, SampleCode.convertExtension(out, DroidDoc.htmlExtension), subdir);
                    files.add(name);
                }
                if (!SampleCode.inList(out, TEMPLATED)) continue;
                ClearPage.copyFile(file, out);
                this.writePage(file, SampleCode.convertExtension(out, DroidDoc.htmlExtension), subdir);
                files.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.writeDirectory(file, relative + name + "/");
            dirs.add(name);
        }
        HDF hdf = this.writeIndex(dir);
        hdf.setValue("subdir", subdir);
        int i = 0;
        for (String string : dirs) {
            hdf.setValue("subdirs." + i + ".name", string);
            ++i;
        }
        i = 0;
        for (String string : files) {
            hdf.setValue("files." + i + ".name", string);
            hdf.setValue("files." + i + ".href", SampleCode.convertExtension(string, ".html"));
            ++i;
        }
        ClearPage.write(hdf, "sampleindex.cs", relative + "/index" + DroidDoc.htmlExtension);
    }

    public void writeIndexOnly(File dir, String relative, Boolean offline) {
        HDF hdf = this.writeIndex(dir);
        if (!offline.booleanValue()) {
            relative = "/" + relative;
        }
        ClearPage.write(hdf, "sampleindex.cs", relative + "index" + DroidDoc.htmlExtension);
    }

    public HDF writeIndex(File dir) {
        HDF hdf = DroidDoc.makeHDF();
        hdf.setValue("page.title", dir.getName() + " - " + this.mTitle);
        hdf.setValue("projectTitle", this.mTitle);
        String filename = dir.getPath() + "/_index.html";
        String summary = SampleTagInfo.readFile(new SourcePositionInfo(filename, -1, -1), filename, "sample code", true, false, true);
        if (summary == null) {
            summary = "";
        }
        hdf.setValue("summary", summary);
        return hdf;
    }

    public void writePage(File f, String out, String subdir) {
        String name = f.getName();
        String filename = f.getPath();
        String data = SampleTagInfo.readFile(new SourcePositionInfo(filename, -1, -1), filename, "sample code", true, true, true);
        data = DroidDoc.escape(data);
        HDF hdf = DroidDoc.makeHDF();
        hdf.setValue("page.title", name);
        hdf.setValue("subdir", subdir);
        hdf.setValue("realFile", name);
        hdf.setValue("fileContents", data);
        ClearPage.write(hdf, "sample.cs", out);
    }

    public void writeImagePage(File f, String out, String subdir) {
        String name = f.getName();
        String data = "<img src=\"" + name + "\" title=\"" + name + "\" />";
        HDF hdf = DroidDoc.makeHDF();
        hdf.setValue("page.title", name);
        hdf.setValue("subdir", subdir);
        hdf.setValue("realFile", name);
        hdf.setValue("fileContents", data);
        ClearPage.write(hdf, "sample.cs", out);
    }
}

