/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import org.clearsilver.HDF;

public class AttributeInfo {
    public static final Comparator<AttributeInfo> comparator = new Comparator<AttributeInfo>(){

        @Override
        public int compare(AttributeInfo a, AttributeInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    public FieldInfo attrField;
    public ArrayList<MethodInfo> methods = new ArrayList();
    private ClassInfo mClass;
    private String mName;
    private Comment mComment;

    public AttributeInfo(ClassInfo cl, FieldInfo f) {
        this.mClass = cl;
        this.attrField = f;
    }

    public String name() {
        if (this.mName == null) {
            for (AttrTagInfo comment : this.attrField.comment().attrTags()) {
                String n = comment.name();
                if (n == null) continue;
                this.mName = n;
                return n;
            }
        }
        return this.mName;
    }

    public Comment comment() {
        if (this.mComment == null) {
            for (AttrTagInfo attr : this.attrField.comment().attrTags()) {
                Comment c = attr.description();
                if (c == null) continue;
                this.mComment = c;
                return c;
            }
        }
        if (this.mComment == null) {
            return new Comment("", this.mClass, new SourcePositionInfo());
        }
        return this.mComment;
    }

    public String anchor() {
        return "attr_" + this.name();
    }

    public String htmlPage() {
        return this.mClass.htmlPage() + "#" + this.anchor();
    }

    public void makeHDF(HDF data, String base) {
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".anchor", this.anchor());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".R.name", this.attrField.name());
        data.setValue(base + ".R.href", this.attrField.htmlPage());
        TagInfo.makeHDF(data, base + ".deprecated", this.attrField.comment().deprecatedTags());
        TagInfo.makeHDF(data, base + ".shortDescr", this.comment().briefTags());
        TagInfo.makeHDF(data, base + ".descr", this.comment().tags());
        int i = 0;
        for (MethodInfo m : this.methods) {
            String s = base + ".methods." + i;
            data.setValue(s + ".href", m.htmlPage());
            data.setValue(s + ".name", m.name() + m.prettySignature());
        }
    }

    public boolean checkLevel() {
        return this.attrField.checkLevel();
    }
}

