/*
 * Decompiled with CFR 0.152.
 */
package vogar.util;

public class TimeUtilities {
    public static String msToIsoString(long duration) {
        long milliseconds = duration % 1000L;
        long seconds = (duration /= 1000L) % 60L;
        long minutes = (duration /= 60L) % 60L;
        long hours = duration /= 60L;
        StringBuilder result = new StringBuilder("P");
        if (hours != 0L) {
            result.append(hours);
            result.append('H');
        }
        if (result.length() > 1 || minutes != 0L) {
            result.append(minutes);
            result.append('M');
        }
        result.append(seconds);
        if (milliseconds != 0L) {
            result.append('.');
            result.append(milliseconds);
        }
        result.append('S');
        return result.toString();
    }

    public static String msToString(long ms) {
        return TimeUtilities.nsToString(ms * 1000000L);
    }

    public static String nsToString(long ns) {
        if (ns < 1000L) {
            return Long.toString(ns) + "ns";
        }
        if (ns < 1000000L) {
            return Long.toString(ns / 1000L) + "us";
        }
        if (ns < 1000000000L) {
            return Long.toString(ns / 1000000L) + "ms";
        }
        if (ns < 60000000000L) {
            return String.format("%.2fs", TimeUtilities.nsToS(ns));
        }
        long duration = ns;
        long nanoseconds = duration % 1000L;
        long microseconds = (duration /= 1000L) % 1000L;
        long milliseconds = (duration /= 1000L) % 1000L;
        long seconds = (duration /= 1000L) % 60L;
        long minutes = (duration /= 60L) % 60L;
        long hours = (duration /= 60L) % 24L;
        long days = duration /= 24L;
        StringBuilder result = new StringBuilder();
        if (days != 0L) {
            result.append(days);
            result.append('d');
        }
        if (result.length() > 1 || hours != 0L) {
            result.append(hours);
            result.append('h');
        }
        if (result.length() > 1 || minutes != 0L) {
            result.append(minutes);
            result.append('m');
        }
        result.append(seconds);
        result.append('s');
        return result.toString();
    }

    public static double nsToS(long ns) {
        return (double)ns / 1.0E9;
    }

    private TimeUtilities() {
    }
}

