/*
 * Decompiled with CFR 0.152.
 */
package vogar.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import vogar.commands.CommandFailedException;
import vogar.util.Log;
import vogar.util.Strings;
import vogar.util.Threads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Command {
    private final List<String> args;
    private final Map<String, String> env;
    private final File workingDirectory;
    private final boolean permitNonZeroExitStatus;
    private final PrintStream tee;
    private final boolean nativeOutput;
    private volatile Process process;

    public Command(String ... args) {
        this(Arrays.asList(args));
    }

    public Command(List<String> args) {
        this.args = new ArrayList<String>(args);
        this.env = Collections.emptyMap();
        this.workingDirectory = null;
        this.permitNonZeroExitStatus = false;
        this.tee = null;
        this.nativeOutput = false;
    }

    private Command(Builder builder) {
        String string;
        this.args = new ArrayList<String>(builder.args);
        this.env = builder.env;
        this.workingDirectory = builder.workingDirectory;
        this.permitNonZeroExitStatus = builder.permitNonZeroExitStatus;
        this.tee = builder.tee;
        if (builder.maxLength != -1 && (string = this.toString()).length() > builder.maxLength) {
            throw new IllegalStateException("Maximum command length " + builder.maxLength + " exceeded by: " + string);
        }
        this.nativeOutput = builder.nativeOutput;
    }

    public void start() throws IOException {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started!");
        }
        Log.verbose("executing " + this);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.args).redirectErrorStream(true);
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
        }
        processBuilder.environment().putAll(this.env);
        this.process = processBuilder.start();
    }

    public boolean isStarted() {
        return this.process != null;
    }

    public InputStream getInputStream() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started!");
        }
        return this.process.getInputStream();
    }

    public List<String> gatherOutput() throws IOException, InterruptedException {
        String outputLine;
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started!");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));
        ArrayList<String> outputLines = new ArrayList<String>();
        while ((outputLine = in.readLine()) != null) {
            if (this.tee != null) {
                this.tee.println(outputLine);
            }
            if (this.nativeOutput) {
                Log.nativeOutput(outputLine);
            }
            outputLines.add(outputLine);
        }
        if (this.process.waitFor() != 0 && !this.permitNonZeroExitStatus) {
            StringBuilder message = new StringBuilder();
            for (String line : outputLines) {
                message.append("\n").append(line);
            }
            throw new CommandFailedException(this.args, outputLines);
        }
        return outputLines;
    }

    public List<String> execute() {
        try {
            this.start();
            return this.gatherOutput();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to execute process: " + this.args, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while executing process: " + this.args, e);
        }
    }

    public List<String> executeWithTimeout(int timeoutSeconds) throws TimeoutException {
        if (timeoutSeconds == 0) {
            return this.execute();
        }
        try {
            List<String> list = this.executeLater().get(timeoutSeconds, TimeUnit.SECONDS);
            return list;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while executing process: " + this.args, e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.destroy();
        }
    }

    public Future<List<String>> executeLater() {
        ExecutorService executor = Threads.fixedThreadsExecutor("command", 1);
        Future<List<String>> result = executor.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                Command.this.start();
                return Command.this.gatherOutput();
            }
        });
        executor.shutdown();
        return result;
    }

    public void destroy() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
        try {
            this.process.waitFor();
            int exitValue = this.process.exitValue();
            Log.verbose("received exit value " + exitValue + " from destroyed command " + this);
        }
        catch (IllegalThreadStateException destroyUnsuccessful) {
            Log.warn("couldn't destroy " + this);
        }
        catch (InterruptedException e) {
            Log.warn("couldn't destroy " + this);
        }
    }

    public String toString() {
        String envString = !this.env.isEmpty() ? Strings.join(this.env.entrySet(), " ") + " " : "";
        return envString + Strings.join(this.args, " ");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<String> args = new ArrayList<String>();
        private final Map<String, String> env = new LinkedHashMap<String, String>();
        private File workingDirectory;
        private boolean permitNonZeroExitStatus = false;
        private PrintStream tee = null;
        private boolean nativeOutput;
        private int maxLength = -1;

        public Builder args(Object ... objects) {
            for (Object object : objects) {
                this.args(object.toString());
            }
            return this;
        }

        public Builder setNativeOutput(boolean nativeOutput) {
            this.nativeOutput = nativeOutput;
            return this;
        }

        public Builder args(String ... args) {
            return this.args(Arrays.asList(args));
        }

        public Builder args(Collection<String> args) {
            this.args.addAll(args);
            return this;
        }

        public Builder env(String key, String value) {
            this.env.put(key, value);
            return this;
        }

        public Builder workingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder tee(PrintStream printStream) {
            this.tee = printStream;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Command build() {
            return new Command(this);
        }

        public List<String> execute() {
            return this.build().execute();
        }
    }
}

