/*
 * Decompiled with CFR 0.152.
 */
package vogar;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import vogar.Outcome;
import vogar.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Expectation {
    public static final Pattern MATCH_ALL_PATTERN = Pattern.compile(".*", 40);
    public static final Expectation SUCCESS = new Expectation(Result.SUCCESS, MATCH_ALL_PATTERN, Collections.<String>emptySet(), "", -1L);
    private final String description;
    private final Result result;
    private final Pattern pattern;
    private final Set<String> tags;
    private final long bug;
    private boolean bugIsOpen = false;

    public Expectation(Result result, Pattern pattern, Set<String> tags, String description, long bug) {
        if (result == null || description == null || pattern == null) {
            throw new IllegalArgumentException("result=" + (Object)((Object)result) + " description=" + description + " pattern=" + pattern);
        }
        this.description = description;
        this.result = result;
        this.pattern = pattern;
        this.tags = new LinkedHashSet<String>(tags);
        this.bug = bug;
    }

    public String getDescription() {
        return this.description;
    }

    public long getBug() {
        return this.bug;
    }

    public Result getResult() {
        return this.result;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setBugIsOpen(boolean bugIsOpen) {
        this.bugIsOpen = bugIsOpen;
    }

    public boolean matches(Outcome outcome) {
        return this.patternMatches(outcome) && (this.bugIsOpen || this.result == outcome.getResult());
    }

    private boolean patternMatches(Outcome outcome) {
        return this.pattern.matcher(outcome.getOutput()).matches();
    }

    public String toString() {
        return "Expectation[description=" + this.description + " pattern=" + this.pattern.pattern() + "]";
    }
}

