/*
 * Decompiled with CFR 0.152.
 */
package vogar;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import vogar.Expectation;
import vogar.Outcome;
import vogar.ResultValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedOutcome {
    public static Ordering<AnnotatedOutcome> ORDER_BY_NAME = new Ordering<AnnotatedOutcome>(){

        @Override
        public int compare(AnnotatedOutcome a, AnnotatedOutcome b) {
            return a.getName().compareTo(b.getName());
        }
    };
    private final Expectation expectation;
    private final Outcome outcome;
    private final SortedMap<Long, Outcome> previousOutcomes;
    private final String tagName;
    private final Outcome tagOutcome;
    private final boolean hasMetadata;

    AnnotatedOutcome(Outcome outcome, Expectation expectation, SortedMap<Long, Outcome> previousOutcomes, String tagName, Outcome tagOutcome, boolean hasMetadata) {
        if (previousOutcomes == null) {
            throw new NullPointerException();
        }
        this.expectation = expectation;
        this.outcome = outcome;
        this.previousOutcomes = previousOutcomes;
        this.tagName = tagName;
        this.tagOutcome = tagOutcome;
        this.hasMetadata = hasMetadata;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public String getName() {
        return this.outcome.getName();
    }

    public ResultValue getResultValue() {
        return this.outcome.getResultValue(this.expectation);
    }

    public List<ResultValue> getPreviousResultValues() {
        ArrayList<ResultValue> previousResultValues = new ArrayList<ResultValue>();
        for (Outcome previousOutcome : this.previousOutcomes.values()) {
            previousResultValues.add(previousOutcome.getResultValue(this.expectation));
        }
        return previousResultValues;
    }

    public ResultValue getMostRecentResultValue(ResultValue defaultValue) {
        List<ResultValue> previousResultValues = this.getPreviousResultValues();
        return previousResultValues.isEmpty() ? defaultValue : previousResultValues.get(previousResultValues.size() - 1);
    }

    public boolean hasTag() {
        return this.tagOutcome != null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public ResultValue getTagResultValue() {
        return this.tagOutcome == null ? null : this.tagOutcome.getResultValue(this.expectation);
    }

    public boolean isNoteworthy() {
        return this.getResultValue() != ResultValue.OK || this.recentlyChanged() || this.changedSinceTag();
    }

    public boolean outcomeChanged() {
        ArrayList<Outcome> previousOutcomesList = this.getOutcomeList();
        return previousOutcomesList.isEmpty() || !this.outcome.equals(previousOutcomesList.get(previousOutcomesList.size() - 1));
    }

    private ArrayList<Outcome> getOutcomeList() {
        return new ArrayList<Outcome>(this.previousOutcomes.values());
    }

    private boolean recentlyChanged() {
        List<ResultValue> previousResultValues = this.getPreviousResultValues();
        if (previousResultValues.isEmpty()) {
            return false;
        }
        return previousResultValues.get(previousResultValues.size() - 1) != this.getResultValue();
    }

    private boolean changedSinceTag() {
        ResultValue tagResultValue = this.getTagResultValue();
        return tagResultValue != null && tagResultValue != this.getResultValue();
    }

    public Long lastRun(Long defaultValue) {
        if (!this.hasMetadata) {
            return defaultValue;
        }
        ArrayList<Long> runTimes = Lists.newArrayList(this.previousOutcomes.keySet());
        return runTimes.isEmpty() ? defaultValue : (Long)runTimes.get(runTimes.size() - 1);
    }
}

