/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vogar.ExpectationStore;

public class DescriptionGenerator
extends Doclet {
    static final String HOST_CONTROLLER = "dalvik.annotation.HostController";
    static final String KNOWN_FAILURE = "dalvik.annotation.KnownFailure";
    static final String BROKEN_TEST = "dalvik.annotation.BrokenTest";
    static final String SIDE_EFFECT = "dalvik.annotation.SideEffect";
    static final String SUPPRESSED_TEST = "android.test.suitebuilder.annotation.Suppress";
    static final String CTS_EXPECTATION_DIR = "cts/tests/expectations";
    static final String JUNIT_TEST_CASE_CLASS_NAME = "junit.framework.testcase";
    static final String TAG_PACKAGE = "TestPackage";
    static final String TAG_SUITE = "TestSuite";
    static final String TAG_CASE = "TestCase";
    static final String TAG_TEST = "Test";
    static final String TAG_DESCRIPTION = "Description";
    static final String ATTRIBUTE_NAME_VERSION = "version";
    static final String ATTRIBUTE_VALUE_VERSION = "1.0";
    static final String ATTRIBUTE_NAME_FRAMEWORK = "AndroidFramework";
    static final String ATTRIBUTE_VALUE_FRAMEWORK = "Android 1.0";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_HOST_CONTROLLER = "HostController";
    static final String XML_OUTPUT_PATH = "./description.xml";
    static final String OUTPUT_PATH_OPTION = "-o";

    public static boolean start(RootDoc root) {
        String[][] options;
        ClassDoc[] classes = root.classes();
        if (classes == null) {
            Log.e("No class found!", null);
            return true;
        }
        String outputPath = XML_OUTPUT_PATH;
        for (String[] option : options = root.options()) {
            if (option.length != 2 || !option[0].equals(OUTPUT_PATH_OPTION)) continue;
            outputPath = option[1];
        }
        XMLGenerator xmlGenerator = null;
        try {
            xmlGenerator = new XMLGenerator(outputPath);
        }
        catch (ParserConfigurationException e) {
            Log.e("Cant initialize XML Generator!", e);
            return true;
        }
        ExpectationStore ctsExpectationStore = null;
        try {
            ctsExpectationStore = VogarUtils.provideExpectationStore("./cts/tests/expectations");
        }
        catch (IOException e) {
            Log.e("Couldn't load expectation store.", e);
            return false;
        }
        for (ClassDoc clazz : classes) {
            if (clazz.isAbstract() || !DescriptionGenerator.isValidJUnitTestCase(clazz)) continue;
            xmlGenerator.addTestClass(new TestClass(clazz, ctsExpectationStore));
        }
        try {
            xmlGenerator.dump();
        }
        catch (Exception e) {
            Log.e("Can't dump to XML file!", e);
        }
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals(OUTPUT_PATH_OPTION)) {
            return 2;
        }
        return 0;
    }

    static boolean isValidJUnitTestCase(ClassDoc clazz) {
        while ((clazz = clazz.superclass()) != null) {
            if (!JUNIT_TEST_CASE_CLASS_NAME.equals(clazz.qualifiedName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static class TestMethod {
        String mName;
        String mDescription;
        String mController;
        String mKnownFailure;
        boolean mIsBroken;
        boolean mIsSuppressed;

        TestMethod(String name, String description, String controller, String knownFailure, boolean isBroken, boolean isSuppressed) {
            this.mName = name;
            this.mDescription = description;
            this.mController = controller;
            this.mKnownFailure = knownFailure;
            this.mIsBroken = isBroken;
            this.mIsSuppressed = isSuppressed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClass {
        String mName;
        Collection<TestMethod> mCases;

        TestClass(String name, Collection<TestMethod> cases) {
            this.mName = name;
            this.mCases = cases;
        }

        TestClass(ClassDoc clazz, ExpectationStore expectationStore) {
            this.mName = clazz.toString();
            this.mCases = this.getTestMethods(expectationStore, clazz);
        }

        Collection<TestMethod> getTestMethods(ExpectationStore expectationStore, ClassDoc clazz) {
            Collection<MethodDoc> methods = this.getAllMethods(clazz);
            ArrayList<TestMethod> cases = new ArrayList<TestMethod>();
            for (MethodDoc method : methods) {
                String name = method.name();
                AnnotationDesc[] annotations = method.annotations();
                String controller = "";
                String knownFailure = null;
                boolean isBroken = false;
                boolean isSuppressed = false;
                for (AnnotationDesc cAnnot : annotations) {
                    AnnotationTypeDoc atype = cAnnot.annotationType();
                    if (atype.toString().equals(DescriptionGenerator.HOST_CONTROLLER)) {
                        controller = this.getAnnotationDescription(cAnnot);
                        continue;
                    }
                    if (atype.toString().equals(DescriptionGenerator.KNOWN_FAILURE)) {
                        knownFailure = this.getAnnotationDescription(cAnnot);
                        continue;
                    }
                    if (atype.toString().equals(DescriptionGenerator.BROKEN_TEST)) {
                        isBroken = true;
                        continue;
                    }
                    if (!atype.toString().equals(DescriptionGenerator.SUPPRESSED_TEST)) continue;
                    isSuppressed = true;
                }
                if (VogarUtils.isVogarKnownFailure(expectationStore, clazz.toString(), name)) {
                    isBroken = true;
                }
                if (!name.startsWith("test")) continue;
                cases.add(new TestMethod(name, method.commentText(), controller, knownFailure, isBroken, isSuppressed));
            }
            return cases;
        }

        String getAnnotationDescription(AnnotationDesc cAnnot) {
            AnnotationDesc.ElementValuePair[] cpairs = cAnnot.elementValues();
            AnnotationDesc.ElementValuePair evp = cpairs[0];
            AnnotationValue av = evp.value();
            String description = av.toString();
            description = description.substring(1, description.length() - 1);
            return description;
        }

        Collection<MethodDoc> getAllMethods(ClassDoc clazz) {
            ArrayList<MethodDoc> methods = new ArrayList<MethodDoc>();
            for (MethodDoc method : clazz.methods()) {
                methods.add(method);
            }
            for (ClassDoc superClass = clazz.superclass(); superClass != null; superClass = superClass.superclass()) {
                for (MethodDoc method : superClass.methods()) {
                    methods.add(method);
                }
            }
            return methods;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XMLGenerator {
        String mOutputPath;
        Document mDoc;

        XMLGenerator(String outputPath) throws ParserConfigurationException {
            this.mOutputPath = outputPath;
            this.mDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node testPackageElem = this.mDoc.appendChild(this.mDoc.createElement(DescriptionGenerator.TAG_PACKAGE));
            this.setAttribute(testPackageElem, DescriptionGenerator.ATTRIBUTE_NAME_VERSION, DescriptionGenerator.ATTRIBUTE_VALUE_VERSION);
            this.setAttribute(testPackageElem, DescriptionGenerator.ATTRIBUTE_NAME_FRAMEWORK, DescriptionGenerator.ATTRIBUTE_VALUE_FRAMEWORK);
        }

        void addTestClass(TestClass tc) {
            this.appendSuiteToElement(this.mDoc.getDocumentElement(), tc);
        }

        void dump() throws TransformerFactoryConfigurationError, FileNotFoundException, TransformerException {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            File file = new File(this.mOutputPath);
            file.getParentFile().mkdirs();
            t.transform(new DOMSource(this.mDoc), new StreamResult(new FileOutputStream(file)));
        }

        void rebuildDocument() {
            Collection<Node> suiteElems = this.getUnmutableChildNodes(this.mDoc.getDocumentElement());
            for (Node suiteElem : suiteElems) {
                this.mergeEmptySuites(suiteElem);
            }
        }

        void mergeEmptySuites(Node suiteElem) {
            Collection<Node> suiteChildren = this.getSuiteChildren(suiteElem);
            if (suiteChildren.size() > 1) {
                for (Node suiteChild : suiteChildren) {
                    this.mergeEmptySuites(suiteChild);
                }
            } else if (suiteChildren.size() == 1) {
                Node child = suiteChildren.iterator().next();
                String newName = this.getAttribute(suiteElem, DescriptionGenerator.ATTRIBUTE_NAME) + "." + this.getAttribute(child, DescriptionGenerator.ATTRIBUTE_NAME);
                this.setAttribute(child, DescriptionGenerator.ATTRIBUTE_NAME, newName);
                Node parentNode = suiteElem.getParentNode();
                parentNode.removeChild(suiteElem);
                parentNode.appendChild(child);
                this.mergeEmptySuites(child);
            }
        }

        private Collection<Node> getUnmutableChildNodes(Node node) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList nodelist = node.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                nodes.add(nodelist.item(i));
            }
            return nodes;
        }

        void appendSuiteToElement(Node elem, TestClass testSuite) {
            String suiteName = testSuite.mName;
            Collection<Node> children = this.getSuiteChildren(elem);
            int dotIndex = suiteName.indexOf(46);
            String name = dotIndex == -1 ? suiteName : suiteName.substring(0, dotIndex);
            boolean foundMatch = false;
            for (Node child : children) {
                String childName = child.getAttributes().getNamedItem(DescriptionGenerator.ATTRIBUTE_NAME).getNodeValue();
                if (!childName.equals(name)) continue;
                foundMatch = true;
                if (dotIndex == -1) {
                    this.appendTestCases(child, testSuite.mCases);
                    continue;
                }
                testSuite.mName = suiteName.substring(dotIndex + 1, suiteName.length());
                this.appendSuiteToElement(child, testSuite);
            }
            if (!foundMatch) {
                this.appendSuiteToElementImpl(elem, testSuite);
            }
        }

        Collection<Node> getSuiteChildren(Node elem) {
            ArrayList<Node> suites = new ArrayList<Node>();
            NodeList children = elem.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals(DescriptionGenerator.TAG_SUITE)) continue;
                suites.add(child);
            }
            return suites;
        }

        void appendTestCases(Node elem, Collection<TestMethod> cases) {
            if (cases.isEmpty()) {
                elem.getParentNode().removeChild(elem);
            } else {
                for (TestMethod caze : cases) {
                    if (caze.mIsBroken || caze.mIsSuppressed || caze.mKnownFailure != null) continue;
                    Node caseNode = elem.appendChild(this.mDoc.createElement(DescriptionGenerator.TAG_TEST));
                    this.setAttribute(caseNode, DescriptionGenerator.ATTRIBUTE_NAME, caze.mName);
                    if (caze.mController != null && caze.mController.length() != 0) {
                        this.setAttribute(caseNode, DescriptionGenerator.ATTRIBUTE_HOST_CONTROLLER, caze.mController);
                    }
                    if (caze.mDescription == null || caze.mDescription.equals("")) continue;
                    caseNode.appendChild(this.mDoc.createElement(DescriptionGenerator.TAG_DESCRIPTION)).setTextContent(caze.mDescription);
                }
            }
        }

        protected void setAttribute(Node elem, String name, String value) {
            Attr attr = this.mDoc.createAttribute(name);
            attr.setNodeValue(value);
            elem.getAttributes().setNamedItem(attr);
        }

        private String getAttribute(Node elem, String name) {
            return elem.getAttributes().getNamedItem(name).getNodeValue();
        }

        void appendSuiteToElementImpl(Node elem, TestClass testSuite) {
            int dotIndex;
            Node parent = elem;
            String suiteName = testSuite.mName;
            while ((dotIndex = suiteName.indexOf(46)) != -1) {
                String name = suiteName.substring(0, dotIndex);
                Node suiteElem = parent.appendChild(this.mDoc.createElement(DescriptionGenerator.TAG_SUITE));
                this.setAttribute(suiteElem, DescriptionGenerator.ATTRIBUTE_NAME, name);
                parent = suiteElem;
                suiteName = suiteName.substring(dotIndex + 1, suiteName.length());
            }
            Node leafSuiteElem = parent.appendChild(this.mDoc.createElement(DescriptionGenerator.TAG_CASE));
            this.setAttribute(leafSuiteElem, DescriptionGenerator.ATTRIBUTE_NAME, suiteName);
            this.appendTestCases(leafSuiteElem, testSuite.mCases);
        }
    }

    static class Log {
        private static boolean TRACE = true;
        private static BufferedWriter mTraceOutput = null;

        Log() {
        }

        static void e(String msg, Exception e) {
            System.out.println(msg);
            if (e != null) {
                e.printStackTrace();
            }
        }

        public static void t(String msg) {
            if (TRACE) {
                try {
                    if (mTraceOutput != null && msg != null) {
                        mTraceOutput.write(msg + "\n");
                        mTraceOutput.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void initTrace(String name) {
            if (TRACE) {
                try {
                    if (mTraceOutput == null) {
                        String fileName = "cts_debug_dg_" + name + ".txt";
                        mTraceOutput = new BufferedWriter(new FileWriter(fileName));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void closeTrace() {
            if (mTraceOutput != null) {
                try {
                    mTraceOutput.close();
                    mTraceOutput = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

