/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.location.CoordinateControls;
import com.android.ddmuilib.location.GpxParser;
import com.android.ddmuilib.location.KmlParser;
import com.android.ddmuilib.location.TrackContentProvider;
import com.android.ddmuilib.location.TrackLabelProvider;
import com.android.ddmuilib.location.TrackPoint;
import com.android.ddmuilib.location.WayPoint;
import com.android.ddmuilib.location.WayPointContentProvider;
import com.android.ddmuilib.location.WayPointLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class EmulatorControlPanel
extends SelectionDependentPanel {
    private static final double DEFAULT_LONGITUDE = -122.084095;
    private static final double DEFAULT_LATITUDE = 37.422006;
    private static final String SPEED_FORMAT = "Speed: %1$dX";
    private static final String[][] GSM_MODES = new String[][]{{"unregistered", EmulatorConsole.GsmMode.UNREGISTERED.getTag()}, {"home", EmulatorConsole.GsmMode.HOME.getTag()}, {"roaming", EmulatorConsole.GsmMode.ROAMING.getTag()}, {"searching", EmulatorConsole.GsmMode.SEARCHING.getTag()}, {"denied", EmulatorConsole.GsmMode.DENIED.getTag()}};
    private static final String[] NETWORK_SPEEDS = new String[]{"Full", "GSM", "HSCSD", "GPRS", "EDGE", "UMTS", "HSDPA"};
    private static final String[] NETWORK_LATENCIES = new String[]{"None", "GPRS", "EDGE", "UMTS"};
    private static final int[] PLAY_SPEEDS = new int[]{1, 2, 5, 10, 20, 50};
    private static final String RE_PHONE_NUMBER = "^[+#0-9]+$";
    private static final String PREFS_WAYPOINT_COL_NAME = "emulatorControl.waypoint.name";
    private static final String PREFS_WAYPOINT_COL_LONGITUDE = "emulatorControl.waypoint.longitude";
    private static final String PREFS_WAYPOINT_COL_LATITUDE = "emulatorControl.waypoint.latitude";
    private static final String PREFS_WAYPOINT_COL_ELEVATION = "emulatorControl.waypoint.elevation";
    private static final String PREFS_WAYPOINT_COL_DESCRIPTION = "emulatorControl.waypoint.desc";
    private static final String PREFS_TRACK_COL_NAME = "emulatorControl.track.name";
    private static final String PREFS_TRACK_COL_COUNT = "emulatorControl.track.count";
    private static final String PREFS_TRACK_COL_FIRST = "emulatorControl.track.first";
    private static final String PREFS_TRACK_COL_LAST = "emulatorControl.track.last";
    private static final String PREFS_TRACK_COL_COMMENT = "emulatorControl.track.comment";
    private EmulatorConsole mEmulatorConsole;
    private Composite mParent;
    private Label mVoiceLabel;
    private Combo mVoiceMode;
    private Label mDataLabel;
    private Combo mDataMode;
    private Label mSpeedLabel;
    private Combo mNetworkSpeed;
    private Label mLatencyLabel;
    private Combo mNetworkLatency;
    private Label mNumberLabel;
    private Text mPhoneNumber;
    private Button mVoiceButton;
    private Button mSmsButton;
    private Label mMessageLabel;
    private Text mSmsMessage;
    private Button mCallButton;
    private Button mCancelButton;
    private TabFolder mLocationFolders;
    private Button mDecimalButton;
    private Button mSexagesimalButton;
    private CoordinateControls mLongitudeControls;
    private CoordinateControls mLatitudeControls;
    private Button mGpxUploadButton;
    private Table mGpxWayPointTable;
    private Table mGpxTrackTable;
    private Button mKmlUploadButton;
    private Table mKmlWayPointTable;
    private Button mPlayGpxButton;
    private Button mGpxBackwardButton;
    private Button mGpxForwardButton;
    private Button mGpxSpeedButton;
    private Button mPlayKmlButton;
    private Button mKmlBackwardButton;
    private Button mKmlForwardButton;
    private Button mKmlSpeedButton;
    private Image mPlayImage;
    private Image mPauseImage;
    private Thread mPlayingThread;
    private boolean mPlayingTrack;
    private int mPlayDirection = 1;
    private int mSpeed;
    private int mSpeedIndex;
    private final SelectionAdapter mDirectionButtonAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (!b.getSelection()) {
                b.setSelection(true);
                return;
            }
            if (b == EmulatorControlPanel.this.mGpxForwardButton || b == EmulatorControlPanel.this.mKmlForwardButton) {
                EmulatorControlPanel.this.mGpxBackwardButton.setSelection(false);
                EmulatorControlPanel.this.mGpxForwardButton.setSelection(true);
                EmulatorControlPanel.this.mKmlBackwardButton.setSelection(false);
                EmulatorControlPanel.this.mKmlForwardButton.setSelection(true);
                EmulatorControlPanel.this.mPlayDirection = 1;
            } else {
                EmulatorControlPanel.this.mGpxBackwardButton.setSelection(true);
                EmulatorControlPanel.this.mGpxForwardButton.setSelection(false);
                EmulatorControlPanel.this.mKmlBackwardButton.setSelection(true);
                EmulatorControlPanel.this.mKmlForwardButton.setSelection(false);
                EmulatorControlPanel.this.mPlayDirection = -1;
            }
        }
    };
    private final SelectionAdapter mSpeedButtonAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            EmulatorControlPanel.this.mSpeedIndex = (EmulatorControlPanel.this.mSpeedIndex + 1) % PLAY_SPEEDS.length;
            EmulatorControlPanel.this.mSpeed = PLAY_SPEEDS[EmulatorControlPanel.this.mSpeedIndex];
            EmulatorControlPanel.this.mGpxSpeedButton.setText(String.format(EmulatorControlPanel.SPEED_FORMAT, EmulatorControlPanel.this.mSpeed));
            EmulatorControlPanel.this.mGpxPlayControls.pack();
            EmulatorControlPanel.this.mKmlSpeedButton.setText(String.format(EmulatorControlPanel.SPEED_FORMAT, EmulatorControlPanel.this.mSpeed));
            EmulatorControlPanel.this.mKmlPlayControls.pack();
            if (EmulatorControlPanel.this.mPlayingThread != null) {
                EmulatorControlPanel.this.mPlayingThread.interrupt();
            }
        }
    };
    private Composite mKmlPlayControls;
    private Composite mGpxPlayControls;

    public void deviceSelected() {
        this.handleNewDevice(this.getCurrentDevice());
    }

    public void clientSelected() {
    }

    protected Control createControl(Composite parent) {
        this.mParent = parent;
        final ScrolledComposite scollingParent = new ScrolledComposite(parent, 512);
        scollingParent.setExpandVertical(true);
        scollingParent.setExpandHorizontal(true);
        scollingParent.setLayoutData((Object)new GridData(1808));
        final Composite top = new Composite((Composite)scollingParent, 0);
        scollingParent.setContent((Control)top);
        top.setLayout((Layout)new GridLayout(1, false));
        scollingParent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scollingParent.getClientArea();
                scollingParent.setMinSize(top.computeSize(r.width, -1));
            }
        });
        this.createRadioControls(top);
        this.createCallControls(top);
        this.createLocationControls(top);
        this.doEnable(false);
        top.layout();
        Rectangle r = scollingParent.getClientArea();
        scollingParent.setMinSize(top.computeSize(r.width, -1));
        return scollingParent;
    }

    private void createRadioControls(Composite top) {
        Group g1 = new Group(top, 0);
        g1.setLayoutData((Object)new GridData(768));
        g1.setLayout((Layout)new GridLayout(2, false));
        g1.setText("Telephony Status");
        Composite insideGroup = new Composite((Composite)g1, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        insideGroup.setLayout((Layout)gl);
        this.mVoiceLabel = new Label(insideGroup, 0);
        this.mVoiceLabel.setText("Voice:");
        this.mVoiceLabel.setAlignment(131072);
        this.mVoiceMode = new Combo(insideGroup, 8);
        this.mVoiceMode.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : GSM_MODES) {
            this.mVoiceMode.add(stringArray[0]);
        }
        this.mVoiceMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorControlPanel.this.setVoiceMode(EmulatorControlPanel.this.mVoiceMode.getSelectionIndex());
            }
        });
        this.mSpeedLabel = new Label(insideGroup, 0);
        this.mSpeedLabel.setText("Speed:");
        this.mSpeedLabel.setAlignment(131072);
        this.mNetworkSpeed = new Combo(insideGroup, 8);
        this.mNetworkSpeed.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : NETWORK_SPEEDS) {
            this.mNetworkSpeed.add((String)stringArray);
        }
        this.mNetworkSpeed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorControlPanel.this.setNetworkSpeed(EmulatorControlPanel.this.mNetworkSpeed.getSelectionIndex());
            }
        });
        this.mDataLabel = new Label(insideGroup, 0);
        this.mDataLabel.setText("Data:");
        this.mDataLabel.setAlignment(131072);
        this.mDataMode = new Combo(insideGroup, 8);
        this.mDataMode.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : GSM_MODES) {
            this.mDataMode.add(stringArray[0]);
        }
        this.mDataMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorControlPanel.this.setDataMode(EmulatorControlPanel.this.mDataMode.getSelectionIndex());
            }
        });
        this.mLatencyLabel = new Label(insideGroup, 0);
        this.mLatencyLabel.setText("Latency:");
        this.mLatencyLabel.setAlignment(131072);
        this.mNetworkLatency = new Combo(insideGroup, 8);
        this.mNetworkLatency.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : NETWORK_LATENCIES) {
            this.mNetworkLatency.add((String)stringArray);
        }
        this.mNetworkLatency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorControlPanel.this.setNetworkLatency(EmulatorControlPanel.this.mNetworkLatency.getSelectionIndex());
            }
        });
        Label l = new Label((Composite)g1, 0);
        l.setLayoutData((Object)new GridData(768));
    }

    private void createCallControls(Composite top) {
        Group g2 = new Group(top, 0);
        g2.setLayoutData((Object)new GridData(768));
        g2.setLayout((Layout)new GridLayout(1, false));
        g2.setText("Telephony Actions");
        Composite phoneComp = new Composite((Composite)g2, 0);
        phoneComp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        phoneComp.setLayout((Layout)gl);
        this.mNumberLabel = new Label(phoneComp, 0);
        this.mNumberLabel.setText("Incoming number:");
        this.mPhoneNumber = new Text(phoneComp, 18436);
        this.mPhoneNumber.setLayoutData((Object)new GridData(768));
        this.mPhoneNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmulatorControlPanel.this.doEnable(EmulatorControlPanel.this.mEmulatorConsole != null);
            }
        });
        this.mVoiceButton = new Button(phoneComp, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.mVoiceButton.setText("Voice");
        this.mVoiceButton.setLayoutData((Object)gd);
        this.mVoiceButton.setEnabled(false);
        this.mVoiceButton.setSelection(true);
        this.mVoiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorControlPanel.this.doEnable(true);
                if (EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                    EmulatorControlPanel.this.mCallButton.setText("Call");
                } else {
                    EmulatorControlPanel.this.mCallButton.setText("Send");
                }
            }
        });
        this.mSmsButton = new Button(phoneComp, 16);
        this.mSmsButton.setText("SMS");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.mSmsButton.setLayoutData((Object)gd);
        this.mSmsButton.setEnabled(false);
        this.mMessageLabel = new Label(phoneComp, 0);
        gd = new GridData();
        gd.verticalAlignment = 128;
        this.mMessageLabel.setLayoutData((Object)gd);
        this.mMessageLabel.setText("Message:");
        this.mMessageLabel.setEnabled(false);
        this.mSmsMessage = new Text(phoneComp, 19010);
        gd = new GridData(768);
        this.mSmsMessage.setLayoutData((Object)gd);
        gd.heightHint = 70;
        this.mSmsMessage.setEnabled(false);
        Composite g2ButtonComp = new Composite((Composite)g2, 0);
        g2ButtonComp.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        g2ButtonComp.setLayout((Layout)gl);
        this.mCallButton = new Button(g2ButtonComp, 8);
        this.mCallButton.setText("Call");
        this.mCallButton.setEnabled(false);
        this.mCallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null) {
                    if (EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.call(EmulatorControlPanel.this.mPhoneNumber.getText().trim()));
                    } else {
                        String message = EmulatorControlPanel.this.mSmsMessage.getText();
                        message = message.replaceAll("\\\\", "\\\\\\\\");
                        message = message.replaceAll("\r\n", "\\\\n");
                        message = message.replaceAll("\n", "\\\\n");
                        message = message.replaceAll("\r", "\\\\n");
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendSms(EmulatorControlPanel.this.mPhoneNumber.getText().trim(), message));
                    }
                }
            }
        });
        this.mCancelButton = new Button(g2ButtonComp, 8);
        this.mCancelButton.setText("Hang Up");
        this.mCancelButton.setEnabled(false);
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null && EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                    EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.cancelCall(EmulatorControlPanel.this.mPhoneNumber.getText().trim()));
                }
            }
        });
    }

    private void createLocationControls(Composite top) {
        Label l = new Label(top, 0);
        l.setLayoutData((Object)new GridData(768));
        l.setText("Location Controls");
        this.mLocationFolders = new TabFolder(top, 0);
        this.mLocationFolders.setLayoutData((Object)new GridData(768));
        Composite manualLocationComp = new Composite((Composite)this.mLocationFolders, 0);
        TabItem item = new TabItem(this.mLocationFolders, 0);
        item.setText("Manual");
        item.setControl((Control)manualLocationComp);
        this.createManualLocationControl(manualLocationComp);
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mPlayImage = loader.loadImage("play.png", this.mParent.getDisplay());
        this.mPauseImage = loader.loadImage("pause.png", this.mParent.getDisplay());
        Composite gpxLocationComp = new Composite((Composite)this.mLocationFolders, 0);
        item = new TabItem(this.mLocationFolders, 0);
        item.setText("GPX");
        item.setControl((Control)gpxLocationComp);
        this.createGpxLocationControl(gpxLocationComp);
        Composite kmlLocationComp = new Composite((Composite)this.mLocationFolders, 0);
        kmlLocationComp.setLayout((Layout)new FillLayout());
        item = new TabItem(this.mLocationFolders, 0);
        item.setText("KML");
        item.setControl((Control)kmlLocationComp);
        this.createKmlLocationControl(kmlLocationComp);
    }

    private void createManualLocationControl(Composite manualLocationComp) {
        manualLocationComp.setLayout((Layout)new GridLayout(1, false));
        this.mDecimalButton = new Button(manualLocationComp, 16);
        this.mDecimalButton.setLayoutData((Object)new GridData(768));
        this.mDecimalButton.setText("Decimal");
        this.mSexagesimalButton = new Button(manualLocationComp, 16);
        this.mSexagesimalButton.setLayoutData((Object)new GridData(768));
        this.mSexagesimalButton.setText("Sexagesimal");
        final Composite content = new Composite(manualLocationComp, 0);
        final StackLayout sl = new StackLayout();
        content.setLayout((Layout)sl);
        final Composite decimalContent = new Composite(content, 0);
        GridLayout gl = new GridLayout(2, false);
        decimalContent.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mLongitudeControls = new CoordinateControls();
        this.mLatitudeControls = new CoordinateControls();
        Label label = new Label(decimalContent, 0);
        label.setText("Longitude");
        this.mLongitudeControls.createDecimalText(decimalContent);
        label = new Label(decimalContent, 0);
        label.setText("Latitude");
        this.mLatitudeControls.createDecimalText(decimalContent);
        final Composite sexagesimalContent = new Composite(content, 0);
        gl = new GridLayout(7, false);
        sexagesimalContent.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        label = new Label(sexagesimalContent, 0);
        label.setText("Longitude");
        this.mLongitudeControls.createSexagesimalDegreeText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("\u00b0");
        this.mLongitudeControls.createSexagesimalMinuteText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("'");
        this.mLongitudeControls.createSexagesimalSecondText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("\"");
        label = new Label(sexagesimalContent, 0);
        label.setText("Latitude");
        this.mLatitudeControls.createSexagesimalDegreeText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("\u00b0");
        this.mLatitudeControls.createSexagesimalMinuteText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("'");
        this.mLatitudeControls.createSexagesimalSecondText(sexagesimalContent);
        label = new Label(sexagesimalContent, 0);
        label.setText("\"");
        sl.topControl = decimalContent;
        this.mDecimalButton.setSelection(true);
        this.mDecimalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sl.topControl = EmulatorControlPanel.this.mDecimalButton.getSelection() ? decimalContent : sexagesimalContent;
                content.layout();
            }
        });
        Button sendButton = new Button(manualLocationComp, 8);
        sendButton.setText("Send");
        sendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null) {
                    EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(EmulatorControlPanel.this.mLongitudeControls.getValue(), EmulatorControlPanel.this.mLatitudeControls.getValue(), 0.0));
                }
            }
        });
        this.mLongitudeControls.setValue(-122.084095);
        this.mLatitudeControls.setValue(37.422006);
    }

    private void createGpxLocationControl(Composite gpxLocationComp) {
        IPreferenceStore store = DdmUiPreferences.getStore();
        gpxLocationComp.setLayout((Layout)new GridLayout(1, false));
        this.mGpxUploadButton = new Button(gpxLocationComp, 8);
        this.mGpxUploadButton.setText("Load GPX...");
        this.mGpxWayPointTable = new Table(gpxLocationComp, 66304);
        GridData gd = new GridData(768);
        this.mGpxWayPointTable.setLayoutData((Object)gd);
        gd.heightHint = 100;
        this.mGpxWayPointTable.setHeaderVisible(true);
        this.mGpxWayPointTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Name", 16384, "Some Name", PREFS_WAYPOINT_COL_NAME, store);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Longitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LONGITUDE, store);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Latitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LATITUDE, store);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Elevation", 16384, "99999.9", PREFS_WAYPOINT_COL_ELEVATION, store);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Description", 16384, "Some Description", PREFS_WAYPOINT_COL_DESCRIPTION, store);
        final TableViewer gpxWayPointViewer = new TableViewer(this.mGpxWayPointTable);
        gpxWayPointViewer.setContentProvider((IContentProvider)new WayPointContentProvider());
        gpxWayPointViewer.setLabelProvider((IBaseLabelProvider)new WayPointLabelProvider());
        gpxWayPointViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof WayPoint) {
                    WayPoint wayPoint = (WayPoint)selectedObject;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(wayPoint.getLongitude(), wayPoint.getLatitude(), wayPoint.getElevation()));
                    }
                }
            }
        });
        this.mGpxTrackTable = new Table(gpxLocationComp, 66304);
        gd = new GridData(768);
        this.mGpxTrackTable.setLayoutData((Object)gd);
        gd.heightHint = 100;
        this.mGpxTrackTable.setHeaderVisible(true);
        this.mGpxTrackTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Name", 16384, "Some very long name", PREFS_TRACK_COL_NAME, store);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Point Count", 131072, "9999", PREFS_TRACK_COL_COUNT, store);
        TableHelper.createTableColumn(this.mGpxTrackTable, "First Point Time", 16384, "999-99-99T99:99:99Z", PREFS_TRACK_COL_FIRST, store);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Last Point Time", 16384, "999-99-99T99:99:99Z", PREFS_TRACK_COL_LAST, store);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Comment", 16384, "-199.999999", PREFS_TRACK_COL_COMMENT, store);
        final TableViewer gpxTrackViewer = new TableViewer(this.mGpxTrackTable);
        gpxTrackViewer.setContentProvider((IContentProvider)new TrackContentProvider());
        gpxTrackViewer.setLabelProvider((IBaseLabelProvider)new TrackLabelProvider());
        gpxTrackViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof GpxParser.Track) {
                    GpxParser.Track track = (GpxParser.Track)selectedObject;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        TrackPoint[] points = track.getPoints();
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(points[0].getLongitude(), points[0].getLatitude(), points[0].getElevation()));
                    }
                    EmulatorControlPanel.this.mPlayGpxButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxBackwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxForwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxSpeedButton.setEnabled(true);
                    return;
                }
                EmulatorControlPanel.this.mPlayGpxButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxBackwardButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxForwardButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxSpeedButton.setEnabled(false);
            }
        });
        this.mGpxUploadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GpxParser parser;
                FileDialog fileDialog = new FileDialog(EmulatorControlPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Load GPX File");
                fileDialog.setFilterExtensions(new String[]{"*.gpx"});
                String fileName = fileDialog.open();
                if (fileName != null && (parser = new GpxParser(fileName)).parse()) {
                    gpxWayPointViewer.setInput((Object)parser.getWayPoints());
                    gpxTrackViewer.setInput((Object)parser.getTracks());
                }
            }
        });
        this.mGpxPlayControls = new Composite(gpxLocationComp, 0);
        GridLayout gl = new GridLayout(5, false);
        this.mGpxPlayControls.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mGpxPlayControls.setLayoutData((Object)new GridData(768));
        this.mPlayGpxButton = new Button(this.mGpxPlayControls, 0x800008);
        this.mPlayGpxButton.setImage(this.mPlayImage);
        this.mPlayGpxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EmulatorControlPanel.this.mPlayingTrack) {
                    IStructuredSelection structuredSelection;
                    Object selectedObject;
                    ISelection selection = gpxTrackViewer.getSelection();
                    if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof GpxParser.Track) {
                        GpxParser.Track track = (GpxParser.Track)selectedObject;
                        EmulatorControlPanel.this.playTrack(track);
                    }
                } else {
                    EmulatorControlPanel.this.mPlayingTrack = false;
                    if (EmulatorControlPanel.this.mPlayingThread != null) {
                        EmulatorControlPanel.this.mPlayingThread.interrupt();
                    }
                }
            }
        });
        Label separator = new Label(this.mGpxPlayControls, 514);
        gd = new GridData(1040);
        separator.setLayoutData((Object)gd);
        gd.heightHint = 0;
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mGpxBackwardButton = new Button(this.mGpxPlayControls, 0x800002);
        this.mGpxBackwardButton.setImage(loader.loadImage("backward.png", this.mParent.getDisplay()));
        this.mGpxBackwardButton.setSelection(false);
        this.mGpxBackwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mGpxForwardButton = new Button(this.mGpxPlayControls, 0x800002);
        this.mGpxForwardButton.setImage(loader.loadImage("forward.png", this.mParent.getDisplay()));
        this.mGpxForwardButton.setSelection(true);
        this.mGpxForwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mGpxSpeedButton = new Button(this.mGpxPlayControls, 0x800008);
        this.mSpeedIndex = 0;
        this.mSpeed = PLAY_SPEEDS[this.mSpeedIndex];
        this.mGpxSpeedButton.setText(String.format(SPEED_FORMAT, this.mSpeed));
        this.mGpxSpeedButton.addSelectionListener((SelectionListener)this.mSpeedButtonAdapter);
        this.mPlayGpxButton.setEnabled(false);
        this.mGpxBackwardButton.setEnabled(false);
        this.mGpxForwardButton.setEnabled(false);
        this.mGpxSpeedButton.setEnabled(false);
    }

    private void createKmlLocationControl(Composite kmlLocationComp) {
        IPreferenceStore store = DdmUiPreferences.getStore();
        kmlLocationComp.setLayout((Layout)new GridLayout(1, false));
        this.mKmlUploadButton = new Button(kmlLocationComp, 8);
        this.mKmlUploadButton.setText("Load KML...");
        this.mKmlWayPointTable = new Table(kmlLocationComp, 66304);
        GridData gd = new GridData(768);
        this.mKmlWayPointTable.setLayoutData((Object)gd);
        gd.heightHint = 200;
        this.mKmlWayPointTable.setHeaderVisible(true);
        this.mKmlWayPointTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Name", 16384, "Some Name", PREFS_WAYPOINT_COL_NAME, store);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Longitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LONGITUDE, store);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Latitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LATITUDE, store);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Elevation", 16384, "99999.9", PREFS_WAYPOINT_COL_ELEVATION, store);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Description", 16384, "Some Description", PREFS_WAYPOINT_COL_DESCRIPTION, store);
        final TableViewer kmlWayPointViewer = new TableViewer(this.mKmlWayPointTable);
        kmlWayPointViewer.setContentProvider((IContentProvider)new WayPointContentProvider());
        kmlWayPointViewer.setLabelProvider((IBaseLabelProvider)new WayPointLabelProvider());
        this.mKmlUploadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KmlParser parser;
                FileDialog fileDialog = new FileDialog(EmulatorControlPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Load KML File");
                fileDialog.setFilterExtensions(new String[]{"*.kml"});
                String fileName = fileDialog.open();
                if (fileName != null && (parser = new KmlParser(fileName)).parse()) {
                    kmlWayPointViewer.setInput((Object)parser.getWayPoints());
                    EmulatorControlPanel.this.mPlayKmlButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlBackwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlForwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlSpeedButton.setEnabled(true);
                }
            }
        });
        kmlWayPointViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof WayPoint) {
                    WayPoint wayPoint = (WayPoint)selectedObject;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(wayPoint.getLongitude(), wayPoint.getLatitude(), wayPoint.getElevation()));
                    }
                }
            }
        });
        this.mKmlPlayControls = new Composite(kmlLocationComp, 0);
        GridLayout gl = new GridLayout(5, false);
        this.mKmlPlayControls.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mKmlPlayControls.setLayoutData((Object)new GridData(768));
        this.mPlayKmlButton = new Button(this.mKmlPlayControls, 0x800008);
        this.mPlayKmlButton.setImage(this.mPlayImage);
        this.mPlayKmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EmulatorControlPanel.this.mPlayingTrack) {
                    Object input = kmlWayPointViewer.getInput();
                    if (input instanceof WayPoint[]) {
                        EmulatorControlPanel.this.playKml((WayPoint[])input);
                    }
                } else {
                    EmulatorControlPanel.this.mPlayingTrack = false;
                    if (EmulatorControlPanel.this.mPlayingThread != null) {
                        EmulatorControlPanel.this.mPlayingThread.interrupt();
                    }
                }
            }
        });
        Label separator = new Label(this.mKmlPlayControls, 514);
        gd = new GridData(1040);
        separator.setLayoutData((Object)gd);
        gd.heightHint = 0;
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mKmlBackwardButton = new Button(this.mKmlPlayControls, 0x800002);
        this.mKmlBackwardButton.setImage(loader.loadImage("backward.png", this.mParent.getDisplay()));
        this.mKmlBackwardButton.setSelection(false);
        this.mKmlBackwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mKmlForwardButton = new Button(this.mKmlPlayControls, 0x800002);
        this.mKmlForwardButton.setImage(loader.loadImage("forward.png", this.mParent.getDisplay()));
        this.mKmlForwardButton.setSelection(true);
        this.mKmlForwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mKmlSpeedButton = new Button(this.mKmlPlayControls, 0x800008);
        this.mSpeedIndex = 0;
        this.mSpeed = PLAY_SPEEDS[this.mSpeedIndex];
        this.mKmlSpeedButton.setText(String.format(SPEED_FORMAT, this.mSpeed));
        this.mKmlSpeedButton.addSelectionListener((SelectionListener)this.mSpeedButtonAdapter);
        this.mPlayKmlButton.setEnabled(false);
        this.mKmlBackwardButton.setEnabled(false);
        this.mKmlForwardButton.setEnabled(false);
        this.mKmlSpeedButton.setEnabled(false);
    }

    public void setFocus() {
    }

    protected void postCreation() {
    }

    private synchronized void setDataMode(int selectionIndex) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setGsmDataMode(EmulatorConsole.GsmMode.getEnum((String)GSM_MODES[selectionIndex][1])));
        }
    }

    private synchronized void setVoiceMode(int selectionIndex) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setGsmVoiceMode(EmulatorConsole.GsmMode.getEnum((String)GSM_MODES[selectionIndex][1])));
        }
    }

    private synchronized void setNetworkLatency(int selectionIndex) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setNetworkLatency(selectionIndex));
        }
    }

    private synchronized void setNetworkSpeed(int selectionIndex) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setNetworkSpeed(selectionIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewDevice(IDevice device) {
        EmulatorControlPanel emulatorControlPanel;
        boolean enable;
        if (this.mParent.isDisposed()) {
            return;
        }
        EmulatorControlPanel emulatorControlPanel2 = this;
        synchronized (emulatorControlPanel2) {
            this.mEmulatorConsole = null;
        }
        try {
            if (device != null) {
                Display d;
                EmulatorConsole.GsmStatus gsm = null;
                EmulatorConsole.NetworkStatus netstatus = null;
                EmulatorControlPanel emulatorControlPanel3 = this;
                synchronized (emulatorControlPanel3) {
                    this.mEmulatorConsole = EmulatorConsole.getConsole((IDevice)device);
                    if (this.mEmulatorConsole != null) {
                        gsm = this.mEmulatorConsole.getGsmStatus();
                        netstatus = this.mEmulatorConsole.getNetworkStatus();
                        if (gsm == null || netstatus == null) {
                            this.mEmulatorConsole = null;
                        }
                    }
                }
                if (gsm != null && netstatus != null && !(d = this.mParent.getDisplay()).isDisposed()) {
                    final EmulatorConsole.GsmStatus f_gsm = gsm;
                    final EmulatorConsole.NetworkStatus f_netstatus = netstatus;
                    d.asyncExec(new Runnable(){

                        public void run() {
                            if (f_gsm.voice != EmulatorConsole.GsmMode.UNKNOWN) {
                                EmulatorControlPanel.this.mVoiceMode.select(EmulatorControlPanel.this.getGsmComboIndex(f_gsm.voice));
                            } else {
                                EmulatorControlPanel.this.mVoiceMode.clearSelection();
                            }
                            if (f_gsm.data != EmulatorConsole.GsmMode.UNKNOWN) {
                                EmulatorControlPanel.this.mDataMode.select(EmulatorControlPanel.this.getGsmComboIndex(f_gsm.data));
                            } else {
                                EmulatorControlPanel.this.mDataMode.clearSelection();
                            }
                            if (f_netstatus.speed != -1) {
                                EmulatorControlPanel.this.mNetworkSpeed.select(f_netstatus.speed);
                            } else {
                                EmulatorControlPanel.this.mNetworkSpeed.clearSelection();
                            }
                            if (f_netstatus.latency != -1) {
                                EmulatorControlPanel.this.mNetworkLatency.select(f_netstatus.latency);
                            } else {
                                EmulatorControlPanel.this.mNetworkLatency.clearSelection();
                            }
                        }
                    });
                }
            }
            enable = false;
            emulatorControlPanel = this;
        }
        catch (Throwable throwable) {
            boolean enable2 = false;
            EmulatorControlPanel emulatorControlPanel4 = this;
            synchronized (emulatorControlPanel4) {
                enable2 = this.mEmulatorConsole != null;
            }
            this.enable(enable2);
            throw throwable;
        }
        synchronized (emulatorControlPanel) {
            enable = this.mEmulatorConsole != null;
        }
        this.enable(enable);
    }

    private void enable(final boolean enabled) {
        try {
            Display d = this.mParent.getDisplay();
            d.asyncExec(new Runnable(){

                public void run() {
                    if (!EmulatorControlPanel.this.mParent.isDisposed()) {
                        EmulatorControlPanel.this.doEnable(enabled);
                    }
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    private boolean isValidPhoneNumber() {
        String number = this.mPhoneNumber.getText().trim();
        return number.matches(RE_PHONE_NUMBER);
    }

    protected void doEnable(boolean enabled) {
        boolean smsValid;
        this.mVoiceLabel.setEnabled(enabled);
        this.mVoiceMode.setEnabled(enabled);
        this.mDataLabel.setEnabled(enabled);
        this.mDataMode.setEnabled(enabled);
        this.mSpeedLabel.setEnabled(enabled);
        this.mNetworkSpeed.setEnabled(enabled);
        this.mLatencyLabel.setEnabled(enabled);
        this.mNetworkLatency.setEnabled(enabled);
        if (this.mPhoneNumber.isEnabled() != enabled) {
            this.mNumberLabel.setEnabled(enabled);
            this.mPhoneNumber.setEnabled(enabled);
        }
        boolean valid = this.isValidPhoneNumber();
        this.mVoiceButton.setEnabled(enabled && valid);
        this.mSmsButton.setEnabled(enabled && valid);
        boolean bl = smsValid = enabled && valid && this.mSmsButton.getSelection();
        if (this.mSmsMessage.isEnabled() != smsValid) {
            this.mMessageLabel.setEnabled(smsValid);
            this.mSmsMessage.setEnabled(smsValid);
        }
        if (!enabled) {
            this.mSmsMessage.setText("");
        }
        this.mCallButton.setEnabled(enabled && valid);
        this.mCancelButton.setEnabled(enabled && valid && this.mVoiceButton.getSelection());
        if (!enabled) {
            this.mVoiceMode.clearSelection();
            this.mDataMode.clearSelection();
            this.mNetworkSpeed.clearSelection();
            this.mNetworkLatency.clearSelection();
            if (this.mPhoneNumber.getText().length() > 0) {
                this.mPhoneNumber.setText("");
            }
        }
        this.mLocationFolders.setEnabled(enabled);
        this.mDecimalButton.setEnabled(enabled);
        this.mSexagesimalButton.setEnabled(enabled);
        this.mLongitudeControls.setEnabled(enabled);
        this.mLatitudeControls.setEnabled(enabled);
        this.mGpxUploadButton.setEnabled(enabled);
        this.mGpxWayPointTable.setEnabled(enabled);
        this.mGpxTrackTable.setEnabled(enabled);
        this.mKmlUploadButton.setEnabled(enabled);
        this.mKmlWayPointTable.setEnabled(enabled);
    }

    private int getGsmComboIndex(EmulatorConsole.GsmMode mode) {
        for (int i = 0; i < GSM_MODES.length; ++i) {
            String[] modes = GSM_MODES[i];
            if (!mode.getTag().equals(modes[1])) continue;
            return i;
        }
        return -1;
    }

    private boolean processCommandResult(final String result) {
        if (result != EmulatorConsole.RESULT_OK) {
            try {
                this.mParent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!EmulatorControlPanel.this.mParent.isDisposed()) {
                            MessageDialog.openError((Shell)EmulatorControlPanel.this.mParent.getShell(), (String)"Emulator Console", (String)result);
                        }
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private void playTrack(final GpxParser.Track track) {
        if (this.mEmulatorConsole != null) {
            this.mPlayGpxButton.setImage(this.mPauseImage);
            this.mPlayKmlButton.setImage(this.mPauseImage);
            this.mPlayingTrack = true;
            this.mPlayingThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block29: {
                        trackPoints = track.getPoints();
                        count = trackPoints.length;
                        start = 0;
                        if (EmulatorControlPanel.access$400(EmulatorControlPanel.this) == -1) {
                            start = count - 1;
                        }
                        p = start;
lbl8:
                        // 2 sources

                        while (p >= 0 && p < count) {
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            ** GOTO lbl21
                        }
                        break block29;
                        {
                            block30: {
                                catch (Throwable var19_20) {
                                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                    try {
                                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                if (!EmulatorControlPanel.this.mPlayGpxButton.isDisposed()) {
                                                    EmulatorControlPanel.this.mPlayGpxButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                    EmulatorControlPanel.this.mPlayKmlButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                }
                                            }
                                        });
                                        throw var19_20;
                                    }
                                    catch (SWTException e) {
                                        // empty catch block
                                    }
                                    throw var19_20;
                                }
lbl21:
                                // 1 sources

                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException e) {
                                    // empty catch block
                                }
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    trackPoint = trackPoints[p];
                                    var6_9 = EmulatorControlPanel.this;
                                    synchronized (var6_9) {
                                        if (EmulatorControlPanel.access$2100(EmulatorControlPanel.this) != null && EmulatorControlPanel.access$2500(EmulatorControlPanel.this, EmulatorControlPanel.access$2100(EmulatorControlPanel.this).sendLocation(trackPoint.getLongitude(), trackPoint.getLatitude(), trackPoint.getElevation()))) break block30;
                                    }
                                }
                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException e) {
                                    // empty catch block
                                }
                                return;
                            }
                            nextIndex = p + EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            if (nextIndex < 0 || nextIndex >= count) ** GOTO lbl-1000
                            nextPoint = trackPoints[nextIndex];
                            delta = nextPoint.getTime() - trackPoint.getTime();
                            if (delta < 0L) {
                                delta = -delta;
                            }
                            startTime = System.currentTimeMillis();
                            try {
                                24.sleep(delta / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this));
                            }
                            catch (InterruptedException e) {}
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                            try {
                                EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            catch (SWTException e) {
                                // empty catch block
                            }
                            return;
lbl-1000:
                            // 3 sources

                            {
                                while ((waited = System.currentTimeMillis() - startTime) < (needToWait = delta / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this))) {
                                    try {
                                        24.sleep(needToWait - waited);
                                    }
                                    catch (InterruptedException e1) {
                                        if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) continue;
                                        EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                        try {
                                            EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                            return;
                                        }
                                        catch (SWTException e) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                            }
                        }
lbl-1000:
                        // 3 sources

                        {
                            p += EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            ** GOTO lbl8
                        }
                    }
                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                    try {
                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    catch (SWTException var1_2) {
                        return;
                    }
                }
            };
            this.mPlayingThread.start();
        }
    }

    private void playKml(final WayPoint[] trackPoints) {
        if (this.mEmulatorConsole != null) {
            this.mPlayGpxButton.setImage(this.mPauseImage);
            this.mPlayKmlButton.setImage(this.mPauseImage);
            this.mPlayingTrack = true;
            this.mPlayingThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block29: {
                        count = trackPoints.length;
                        start = 0;
                        if (EmulatorControlPanel.access$400(EmulatorControlPanel.this) == -1) {
                            start = count - 1;
                        }
                        p = start;
lbl7:
                        // 2 sources

                        while (p >= 0 && p < count) {
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            ** GOTO lbl20
                        }
                        break block29;
                        {
                            block30: {
                                catch (Throwable var17_18) {
                                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                    try {
                                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                if (!EmulatorControlPanel.this.mPlayGpxButton.isDisposed()) {
                                                    EmulatorControlPanel.this.mPlayGpxButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                    EmulatorControlPanel.this.mPlayKmlButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                }
                                            }
                                        });
                                        throw var17_18;
                                    }
                                    catch (SWTException e) {
                                        // empty catch block
                                    }
                                    throw var17_18;
                                }
lbl20:
                                // 1 sources

                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException e) {
                                    // empty catch block
                                }
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    trackPoint = trackPoints[p];
                                    var5_8 = EmulatorControlPanel.this;
                                    synchronized (var5_8) {
                                        if (EmulatorControlPanel.access$2100(EmulatorControlPanel.this) != null && EmulatorControlPanel.access$2500(EmulatorControlPanel.this, EmulatorControlPanel.access$2100(EmulatorControlPanel.this).sendLocation(trackPoint.getLongitude(), trackPoint.getLatitude(), trackPoint.getElevation()))) break block30;
                                    }
                                }
                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException e) {
                                    // empty catch block
                                }
                                return;
                            }
                            nextIndex = p + EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            if (nextIndex < 0 || nextIndex >= count) ** GOTO lbl-1000
                            delta = 1000L;
                            if (delta < 0L) {
                                delta = -delta;
                            }
                            startTime = System.currentTimeMillis();
                            try {
                                25.sleep(delta / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this));
                            }
                            catch (InterruptedException e) {}
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                            try {
                                EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            catch (SWTException e) {
                                // empty catch block
                            }
                            return;
lbl-1000:
                            // 3 sources

                            {
                                while ((waited = System.currentTimeMillis() - startTime) < (needToWait = delta / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this))) {
                                    try {
                                        25.sleep(needToWait - waited);
                                    }
                                    catch (InterruptedException e1) {
                                        if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) continue;
                                        EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                        try {
                                            EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                            return;
                                        }
                                        catch (SWTException e) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                            }
                        }
lbl-1000:
                        // 3 sources

                        {
                            p += EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            ** GOTO lbl7
                        }
                    }
                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                    try {
                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    catch (SWTException var1_2) {
                        return;
                    }
                }
            };
            this.mPlayingThread.start();
        }
    }

    static /* synthetic */ int access$400(EmulatorControlPanel x0) {
        return x0.mPlayDirection;
    }
}

