/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.DdmUiPreferences;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;

public class Addr2Line {
    private static final HashMap<String, Addr2Line> sProcessCache = new HashMap();
    private static final byte[] sCrLf = new byte[]{10};
    private String mLibrary;
    private Process mProcess;
    private BufferedReader mResultReader;
    private BufferedOutputStream mAddressWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Addr2Line getProcess(String library) {
        if (library != null) {
            HashMap<String, Addr2Line> hashMap = sProcessCache;
            synchronized (hashMap) {
                Addr2Line process = sProcessCache.get(library);
                if (process == null) {
                    process = new Addr2Line(library);
                    boolean status = process.start();
                    if (status) {
                        sProcessCache.put(library, process);
                    } else {
                        process = null;
                    }
                }
                return process;
            }
        }
        return null;
    }

    private Addr2Line(String library) {
        this.mLibrary = library;
    }

    private boolean start() {
        block5: {
            String symbols = System.getenv("ANDROID_SYMBOLS");
            if (symbols == null) {
                symbols = DdmUiPreferences.getSymbolDirectory();
            }
            String[] command = new String[]{DdmUiPreferences.getAddr2Line(), "-C", "-f", "-e", symbols + this.mLibrary};
            try {
                this.mProcess = Runtime.getRuntime().exec(command);
                if (this.mProcess != null) {
                    InputStreamReader is = new InputStreamReader(this.mProcess.getInputStream());
                    this.mResultReader = new BufferedReader(is);
                    this.mAddressWriter = new BufferedOutputStream(this.mProcess.getOutputStream());
                    if (this.mResultReader == null || this.mAddressWriter == null) {
                        this.mProcess.destroy();
                        this.mProcess = null;
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException e) {
                String msg = String.format("Error while trying to start %1$s process for library %2$s", DdmUiPreferences.getAddr2Line(), this.mLibrary);
                Log.e((String)"ddm-Addr2Line", (String)msg);
                if (this.mProcess == null) break block5;
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                sProcessCache.remove(this.mLibrary);
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            Collection<Addr2Line> col = sProcessCache.values();
            for (Addr2Line a2l : col) {
                a2l.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeStackCallInfo getAddress(long addr) {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                String tmp = Long.toString(addr, 16);
                try {
                    this.mAddressWriter.write(tmp.getBytes());
                    this.mAddressWriter.write(sCrLf);
                    this.mAddressWriter.flush();
                    String method = this.mResultReader.readLine();
                    String source = this.mResultReader.readLine();
                    if (method != null && source != null) {
                        return new NativeStackCallInfo(this.mLibrary, method, source);
                    }
                }
                catch (IOException e) {
                    Log.e((String)"ddms", (String)("Error while trying to get information for addr: " + tmp + " in library: " + this.mLibrary));
                }
            }
        }
        return null;
    }
}

