/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.utils.ArrayHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

public final class SyncService {
    private static final byte[] ID_OKAY = new byte[]{79, 75, 65, 89};
    private static final byte[] ID_FAIL = new byte[]{70, 65, 73, 76};
    private static final byte[] ID_STAT = new byte[]{83, 84, 65, 84};
    private static final byte[] ID_RECV = new byte[]{82, 69, 67, 86};
    private static final byte[] ID_DATA = new byte[]{68, 65, 84, 65};
    private static final byte[] ID_DONE = new byte[]{68, 79, 78, 69};
    private static final byte[] ID_SEND = new byte[]{83, 69, 78, 68};
    private static final NullSyncProgresMonitor sNullSyncProgressMonitor = new NullSyncProgresMonitor();
    private static final int S_ISOCK = 49152;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFBLK = 24576;
    private static final int S_IFDIR = 16384;
    private static final int S_IFCHR = 8192;
    private static final int S_IFIFO = 4096;
    private static final int SYNC_DATA_MAX = 65536;
    private static final int REMOTE_PATH_MAX_LENGTH = 1024;
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCELED = 1;
    public static final int RESULT_UNKNOWN_ERROR = 2;
    public static final int RESULT_CONNECTION_ERROR = 3;
    public static final int RESULT_NO_REMOTE_OBJECT = 4;
    public static final int RESULT_TARGET_IS_FILE = 5;
    public static final int RESULT_NO_DIR_TARGET = 6;
    public static final int RESULT_REMOTE_PATH_ENCODING = 7;
    public static final int RESULT_REMOTE_PATH_LENGTH = 8;
    public static final int RESULT_FILE_WRITE_ERROR = 9;
    public static final int RESULT_FILE_READ_ERROR = 10;
    public static final int RESULT_NO_LOCAL_FILE = 11;
    public static final int RESULT_LOCAL_IS_DIRECTORY = 12;
    public static final int RESULT_REMOTE_IS_FILE = 13;
    public static final int RESULT_BUFFER_OVERRUN = 14;
    public static final int RESULT_CONNECTION_TIMEOUT = 15;
    private InetSocketAddress mAddress;
    private Device mDevice;
    private SocketChannel mChannel;
    private byte[] mBuffer;

    SyncService(InetSocketAddress address, Device device) {
        this.mAddress = address;
        this.mDevice = device;
    }

    boolean openSync() throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            this.mChannel = SocketChannel.open(this.mAddress);
            this.mChannel.configureBlocking(false);
            AdbHelper.setDevice(this.mChannel, this.mDevice);
            byte[] request = AdbHelper.formAdbRequest("sync:");
            AdbHelper.write(this.mChannel, request, -1, DdmPreferences.getTimeOut());
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(this.mChannel, false);
            if (!resp.okay) {
                Log.w("ddms", "Got unhappy response from ADB sync req: " + resp.message);
                this.mChannel.close();
                this.mChannel = null;
                return false;
            }
        }
        catch (TimeoutException e) {
            if (this.mChannel != null) {
                try {
                    this.mChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.mChannel = null;
            }
            throw e;
        }
        catch (IOException e) {
            if (this.mChannel != null) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mChannel = null;
            }
            throw e;
        }
        return true;
    }

    public void close() {
        if (this.mChannel != null) {
            try {
                this.mChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mChannel = null;
        }
    }

    public static ISyncProgressMonitor getNullProgressMonitor() {
        return sNullSyncProgressMonitor;
    }

    private static String errorCodeToString(int code) {
        switch (code) {
            case 0: {
                return "Success.";
            }
            case 1: {
                return "Tranfert canceled by the user.";
            }
            case 2: {
                return "Unknown Error.";
            }
            case 3: {
                return "Adb Connection Error.";
            }
            case 4: {
                return "Remote object doesn't exist!";
            }
            case 5: {
                return "Target object is a file.";
            }
            case 6: {
                return "Target directory doesn't exist.";
            }
            case 7: {
                return "Remote Path encoding is not supported.";
            }
            case 8: {
                return "Remove path is too long.";
            }
            case 9: {
                return "Writing local file failed!";
            }
            case 10: {
                return "Reading local file failed!";
            }
            case 11: {
                return "Local file doesn't exist.";
            }
            case 12: {
                return "Local path is a directory.";
            }
            case 13: {
                return "Remote path is a file.";
            }
            case 14: {
                return "Receiving too much data.";
            }
            case 15: {
                return "timeout";
            }
        }
        throw new RuntimeException();
    }

    public SyncResult pull(FileListingService.FileEntry[] entries, String localPath, ISyncProgressMonitor monitor) {
        File f = new File(localPath);
        if (!f.exists()) {
            return new SyncResult(6);
        }
        if (!f.isDirectory()) {
            return new SyncResult(5);
        }
        FileListingService fls = new FileListingService(this.mDevice);
        int total = this.getTotalRemoteFileSize(entries, fls);
        monitor.start(total);
        SyncResult result = this.doPull(entries, localPath, fls, monitor);
        monitor.stop();
        return result;
    }

    public SyncResult pullFile(FileListingService.FileEntry remote, String localFilename, ISyncProgressMonitor monitor) {
        int total = remote.getSizeValue();
        monitor.start(total);
        SyncResult result = this.doPullFile(remote.getFullPath(), localFilename, monitor);
        monitor.stop();
        return result;
    }

    public SyncResult pullFile(String remoteFilepath, String localFilename, ISyncProgressMonitor monitor) {
        monitor.start(0);
        SyncResult result = this.doPullFile(remoteFilepath, localFilename, monitor);
        monitor.stop();
        return result;
    }

    public SyncResult push(String[] local, FileListingService.FileEntry remote, ISyncProgressMonitor monitor) {
        if (!remote.isDirectory()) {
            return new SyncResult(13);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String path : local) {
            files.add(new File(path));
        }
        File[] fileArray = files.toArray(new File[files.size()]);
        int total = this.getTotalLocalFileSize(fileArray);
        monitor.start(total);
        SyncResult result = this.doPush(fileArray, remote.getFullPath(), monitor);
        monitor.stop();
        return result;
    }

    public SyncResult pushFile(String local, String remote, ISyncProgressMonitor monitor) {
        File f = new File(local);
        if (!f.exists()) {
            return new SyncResult(11);
        }
        if (f.isDirectory()) {
            return new SyncResult(12);
        }
        monitor.start((int)f.length());
        SyncResult result = this.doPushFile(local, remote, monitor);
        monitor.stop();
        return result;
    }

    private int getTotalRemoteFileSize(FileListingService.FileEntry[] entries, FileListingService fls) {
        int count = 0;
        for (FileListingService.FileEntry e : entries) {
            int type = e.getType();
            if (type == 1) {
                FileListingService.FileEntry[] children = fls.getChildren(e, false, null);
                count += this.getTotalRemoteFileSize(children, fls) + 1;
                continue;
            }
            if (type != 0) continue;
            count += e.getSizeValue();
        }
        return count;
    }

    private int getTotalLocalFileSize(File[] files) {
        int count = 0;
        for (File f : files) {
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                return this.getTotalLocalFileSize(f.listFiles()) + 1;
            }
            if (!f.isFile()) continue;
            count = (int)((long)count + f.length());
        }
        return count;
    }

    private SyncResult doPull(FileListingService.FileEntry[] entries, String localPath, FileListingService fileListingService, ISyncProgressMonitor monitor) {
        for (FileListingService.FileEntry e : entries) {
            String dest;
            if (monitor.isCanceled()) {
                return new SyncResult(1);
            }
            int type = e.getType();
            if (type == 1) {
                monitor.startSubTask(e.getFullPath());
                dest = localPath + File.separator + e.getName();
                File d = new File(dest);
                d.mkdir();
                FileListingService.FileEntry[] children = fileListingService.getChildren(e, true, null);
                SyncResult result = this.doPull(children, dest, fileListingService, monitor);
                if (result.mCode != 0) {
                    return result;
                }
                monitor.advance(1);
                continue;
            }
            if (type != 0) continue;
            monitor.startSubTask(e.getFullPath());
            dest = localPath + File.separator + e.getName();
            SyncResult result = this.doPullFile(e.getFullPath(), dest, monitor);
            if (result.mCode == 0) continue;
            return result;
        }
        return new SyncResult(0);
    }

    private SyncResult doPullFile(String remotePath, String localPath, ISyncProgressMonitor monitor) {
        byte[] msg = null;
        byte[] pullResult = new byte[8];
        int timeOut = DdmPreferences.getTimeOut();
        try {
            byte[] remotePathContent = remotePath.getBytes("ISO-8859-1");
            if (remotePathContent.length > 1024) {
                return new SyncResult(8);
            }
            msg = SyncService.createFileReq(ID_RECV, remotePathContent);
            AdbHelper.write(this.mChannel, msg, -1, timeOut);
            AdbHelper.read(this.mChannel, pullResult, -1, timeOut);
            if (!SyncService.checkResult(pullResult, ID_DATA) && !SyncService.checkResult(pullResult, ID_DONE)) {
                return new SyncResult(3);
            }
        }
        catch (UnsupportedEncodingException e) {
            return new SyncResult(7, e);
        }
        catch (TimeoutException e) {
            return new SyncResult(15, e);
        }
        catch (IOException e) {
            return new SyncResult(3, e);
        }
        File f = new File(localPath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            return new SyncResult(9, e);
        }
        byte[] data = new byte[65536];
        while (true) {
            if (monitor.isCanceled()) {
                return new SyncResult(1);
            }
            if (SyncService.checkResult(pullResult, ID_DONE)) break;
            if (!SyncService.checkResult(pullResult, ID_DATA)) {
                return new SyncResult(3);
            }
            int length = ArrayHelper.swap32bitFromArray(pullResult, 4);
            if (length > 65536) {
                return new SyncResult(14);
            }
            try {
                AdbHelper.read(this.mChannel, data, length, timeOut);
                AdbHelper.read(this.mChannel, pullResult, -1, timeOut);
            }
            catch (TimeoutException e) {
                return new SyncResult(15, e);
            }
            catch (IOException e) {
                return new SyncResult(3, e);
            }
            try {
                fos.write(data, 0, length);
            }
            catch (IOException e) {
                return new SyncResult(9, e);
            }
            monitor.advance(length);
        }
        try {
            fos.flush();
        }
        catch (IOException e) {
            return new SyncResult(9, e);
        }
        return new SyncResult(0);
    }

    private SyncResult doPush(File[] fileArray, String remotePath, ISyncProgressMonitor monitor) {
        for (File f : fileArray) {
            SyncResult result;
            if (monitor.isCanceled()) {
                return new SyncResult(1);
            }
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                String dest = remotePath + "/" + f.getName();
                monitor.startSubTask(dest);
                result = this.doPush(f.listFiles(), dest, monitor);
                if (result.mCode != 0) {
                    return result;
                }
                monitor.advance(1);
                continue;
            }
            if (!f.isFile()) continue;
            String remoteFile = remotePath + "/" + f.getName();
            monitor.startSubTask(remoteFile);
            result = this.doPushFile(f.getAbsolutePath(), remoteFile, monitor);
            if (result.mCode == 0) continue;
            return result;
        }
        return new SyncResult(0);
    }

    private SyncResult doPushFile(String localPath, String remotePath, ISyncProgressMonitor monitor) {
        byte[] msg;
        FileInputStream fis = null;
        int timeOut = DdmPreferences.getTimeOut();
        try {
            byte[] remotePathContent = remotePath.getBytes("ISO-8859-1");
            if (remotePathContent.length > 1024) {
                return new SyncResult(8);
            }
            File f = new File(localPath);
            if (!f.exists()) {
                return new SyncResult(11);
            }
            fis = new FileInputStream(f);
            msg = SyncService.createSendFileReq(ID_SEND, remotePathContent, 420);
        }
        catch (UnsupportedEncodingException e) {
            return new SyncResult(7, e);
        }
        catch (FileNotFoundException e) {
            return new SyncResult(10, e);
        }
        try {
            AdbHelper.write(this.mChannel, msg, -1, timeOut);
        }
        catch (TimeoutException e) {
            return new SyncResult(15, e);
        }
        catch (IOException e) {
            return new SyncResult(3, e);
        }
        if (this.mBuffer == null) {
            this.mBuffer = new byte[65544];
        }
        System.arraycopy(ID_DATA, 0, this.mBuffer, 0, ID_DATA.length);
        while (true) {
            if (monitor.isCanceled()) {
                return new SyncResult(1);
            }
            int readCount = 0;
            try {
                readCount = fis.read(this.mBuffer, 8, 65536);
            }
            catch (IOException e) {
                return new SyncResult(10, e);
            }
            if (readCount == -1) break;
            ArrayHelper.swap32bitsToArray(readCount, this.mBuffer, 4);
            try {
                AdbHelper.write(this.mChannel, this.mBuffer, readCount + 8, timeOut);
            }
            catch (TimeoutException e) {
                return new SyncResult(15, e);
            }
            catch (IOException e) {
                return new SyncResult(3, e);
            }
            monitor.advance(readCount);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            return new SyncResult(10, e);
        }
        try {
            long time = System.currentTimeMillis() / 1000L;
            msg = SyncService.createReq(ID_DONE, (int)time);
            AdbHelper.write(this.mChannel, msg, -1, timeOut);
            byte[] result = new byte[8];
            AdbHelper.read(this.mChannel, result, -1, timeOut);
            if (!SyncService.checkResult(result, ID_OKAY)) {
                if (SyncService.checkResult(result, ID_FAIL)) {
                    int len = ArrayHelper.swap32bitFromArray(result, 4);
                    AdbHelper.read(this.mChannel, this.mBuffer, len, timeOut);
                    String message = new String(this.mBuffer, 0, len);
                    Log.e("ddms", "transfer error: " + message);
                    return new SyncResult(2, message);
                }
                return new SyncResult(2);
            }
        }
        catch (TimeoutException e) {
            return new SyncResult(15, e);
        }
        catch (IOException e) {
            return new SyncResult(3, e);
        }
        return new SyncResult(0);
    }

    private Integer readMode(String path) throws TimeoutException, IOException {
        byte[] msg = SyncService.createFileReq(ID_STAT, path);
        AdbHelper.write(this.mChannel, msg, -1, DdmPreferences.getTimeOut());
        byte[] statResult = new byte[16];
        AdbHelper.read(this.mChannel, statResult, -1, DdmPreferences.getTimeOut());
        if (!SyncService.checkResult(statResult, ID_STAT)) {
            return null;
        }
        return ArrayHelper.swap32bitFromArray(statResult, 4);
    }

    private static byte[] createReq(byte[] command, int value) {
        byte[] array = new byte[8];
        System.arraycopy(command, 0, array, 0, 4);
        ArrayHelper.swap32bitsToArray(value, array, 4);
        return array;
    }

    private static byte[] createFileReq(byte[] command, String path) {
        byte[] pathContent = null;
        try {
            pathContent = path.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return SyncService.createFileReq(command, pathContent);
    }

    private static byte[] createFileReq(byte[] command, byte[] path) {
        byte[] array = new byte[8 + path.length];
        System.arraycopy(command, 0, array, 0, 4);
        ArrayHelper.swap32bitsToArray(path.length, array, 4);
        System.arraycopy(path, 0, array, 8, path.length);
        return array;
    }

    private static byte[] createSendFileReq(byte[] command, byte[] path, int mode) {
        String modeStr = "," + (mode & 0x1FF);
        byte[] modeContent = null;
        try {
            modeContent = modeStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] array = new byte[8 + path.length + modeContent.length];
        System.arraycopy(command, 0, array, 0, 4);
        ArrayHelper.swap32bitsToArray(path.length + modeContent.length, array, 4);
        System.arraycopy(path, 0, array, 8, path.length);
        System.arraycopy(modeContent, 0, array, 8 + path.length, modeContent.length);
        return array;
    }

    private static boolean checkResult(byte[] result, byte[] code) {
        return result[0] == code[0] && result[1] == code[1] && result[2] == code[2] && result[3] == code[3];
    }

    private static int getFileType(int mode) {
        if ((mode & 0xC000) == 49152) {
            return 6;
        }
        if ((mode & 0xA000) == 40960) {
            return 5;
        }
        if ((mode & 0x8000) == 32768) {
            return 0;
        }
        if ((mode & 0x6000) == 24576) {
            return 3;
        }
        if ((mode & 0x4000) == 16384) {
            return 1;
        }
        if ((mode & 0x2000) == 8192) {
            return 4;
        }
        if ((mode & 0x1000) == 4096) {
            return 7;
        }
        return 8;
    }

    private static class NullSyncProgresMonitor
    implements ISyncProgressMonitor {
        private NullSyncProgresMonitor() {
        }

        public void advance(int work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void start(int totalWork) {
        }

        public void startSubTask(String name) {
        }

        public void stop() {
        }
    }

    public static interface ISyncProgressMonitor {
        public void start(int var1);

        public void stop();

        public boolean isCanceled();

        public void startSubTask(String var1);

        public void advance(int var1);
    }

    public static class SyncResult {
        private int mCode;
        private String mMessage;

        SyncResult(int code, String message) {
            this.mCode = code;
            this.mMessage = message;
        }

        SyncResult(int code, Exception e) {
            this(code, e.getMessage());
        }

        SyncResult(int code) {
            this(code, SyncService.errorCodeToString(code));
        }

        public int getCode() {
            return this.mCode;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }
}

