/*
 * Decompiled with CFR 0.152.
 */
package dasm;

public class Utils {
    public static String convertDotsToSlashes(String name) {
        if (name == null) {
            return null;
        }
        return name.replace('.', '/');
    }

    public static String[] splitRegList(String list) {
        String[] result = null;
        if (list.length() > 0) {
            result = list.split("[\\s]*,[\\s]*|[\\s]*\\.\\.[\\s]*");
        }
        return result;
    }

    public static Number stringToNumber(String str) throws NumberFormatException {
        if (str.startsWith("+")) {
            return new Integer(str.substring(1));
        }
        if (str.startsWith("0x")) {
            return Utils.stringToSmallestInteger(str.substring(2), 16);
        }
        if (str.indexOf(46) != -1) {
            double x = Double.parseDouble(str);
            if (x <= 3.4028234663852886E38 && x >= (double)1.4E-45f) {
                return new Float((float)x);
            }
            return new Double(x);
        }
        return Utils.stringToSmallestInteger(str, 10);
    }

    private static Number stringToSmallestInteger(String str, int radix) throws NumberFormatException {
        long x = Long.parseLong(str, radix);
        if (x <= Integer.MAX_VALUE && x >= Integer.MIN_VALUE) {
            return new Integer((int)x);
        }
        return new Long(x);
    }

    public static String[] getClassMethodSignatureFromString(String name) {
        int i;
        String signature = Utils.convertDotsToSlashes(name);
        String[] result = new String[3];
        int mpos = 0;
        int sigpos = 0;
        sigpos = signature.indexOf(40);
        if (sigpos == -1) {
            sigpos = 0;
            i = signature.length() - 1;
        } else {
            i = sigpos - 1;
        }
        while (i >= 0) {
            if (signature.charAt(i) == '/') {
                mpos = i;
                break;
            }
            --i;
        }
        try {
            result[0] = signature.substring(0, mpos);
            result[1] = signature.substring(mpos + 1, sigpos);
            result[2] = signature.substring(sigpos);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("malformed method signature : " + name);
        }
        return result;
    }

    public static String[] getClassFieldFromString(String name) {
        name = Utils.convertDotsToSlashes(name);
        String[] result = new String[2];
        int pos = name.lastIndexOf(47);
        if (pos == -1) {
            result[0] = null;
            result[1] = name;
        } else {
            result[0] = name.substring(0, pos);
            result[1] = name.substring(pos + 1);
        }
        return result;
    }

    public static String[] getMethodSignatureFromString(String name) {
        int sigpos = name.indexOf(40);
        if (sigpos == -1) {
            sigpos = 0;
        }
        String[] result = new String[]{name.substring(0, sigpos), Utils.convertDotsToSlashes(name.substring(sigpos))};
        return result;
    }
}

