/*
 * Decompiled with CFR 0.152.
 */
package dasm;

import dasm.DasmError;
import dasm.DopInfo;
import dasm.ReservedWords;
import dasm.Utils;
import dasm.tokens.number_token;
import dasm.tokens.relative_number_token;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java_cup.runtime.int_token;
import java_cup.runtime.str_token;
import java_cup.runtime.token;

class Scanner {
    protected Reader inputReader;
    protected int nextChar;
    protected CharBuffer charBuf = new CharBuffer();
    protected static final String WHITESPACE = " \n\t\r";
    protected static final String SEPARATORS = " \n\t\r:=,";
    public int line_num;
    public int token_line_num;
    public int char_num;
    public StringBuffer line;
    public Hashtable dict = new Hashtable();

    public Scanner(Reader i) throws IOException, DasmError {
        this.inputReader = i;
        this.line_num = 1;
        this.char_num = 0;
        this.line = new StringBuffer();
        this.nextChar = 0;
        this.skipEmptyLines();
        if (this.nextChar == -1) {
            throw new DasmError("empty source file");
        }
    }

    protected static boolean isWhitespace(int c) {
        return WHITESPACE.indexOf(c) != -1;
    }

    protected static boolean isSeparator(int c) {
        return c == -1 || SEPARATORS.indexOf(c) != -1;
    }

    protected void readNextChar() throws IOException {
        this.nextChar = this.inputReader.read();
        switch (this.nextChar) {
            case -1: {
                if (this.char_num == 0) {
                    this.char_num = -1;
                    break;
                }
                this.nextChar = 10;
            }
            case 10: {
                ++this.line_num;
                this.char_num = 0;
                break;
            }
            default: {
                this.line.append((char)this.nextChar);
                ++this.char_num;
                return;
            }
        }
        this.line.setLength(0);
    }

    private void skipEmptyLines() throws IOException {
        while (true) {
            if (this.nextChar != 59) {
                do {
                    this.readNextChar();
                } while (Scanner.isWhitespace(this.nextChar));
                if (this.nextChar != 59) {
                    return;
                }
            }
            do {
                this.readNextChar();
                if (this.nextChar != -1) continue;
                return;
            } while (this.nextChar != 10);
        }
    }

    private char readUnicodeChar() throws IOException, DasmError {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            this.readNextChar();
            if (this.nextChar == -1) {
                return '\u0000';
            }
            int tmp = Character.digit((char)this.nextChar, 16);
            if (tmp == -1) {
                throw new DasmError("Invalid '\\u' escape sequence");
            }
            result = result << 4 | tmp;
        }
        return (char)result;
    }

    private char nameEscape() throws IOException, DasmError {
        this.readNextChar();
        if (this.nextChar != 117) {
            throw new DasmError("Only '\\u' escape sequence allowed in names");
        }
        char chval = this.readUnicodeChar();
        if (this.nextChar == -1) {
            throw new DasmError("Left over '\\u' escape sequence");
        }
        return chval;
    }

    public token next_token() throws IOException, DasmError {
        this.token_line_num = this.line_num;
        block17: while (true) {
            switch (this.nextChar) {
                case 10: 
                case 59: {
                    this.skipEmptyLines();
                    this.token_line_num = this.line_num;
                    return new token(65);
                }
                case 9: 
                case 13: 
                case 32: 
                case 44: {
                    this.readNextChar();
                    continue block17;
                }
                case -1: {
                    this.char_num = -1;
                    return new token(0);
                }
                case 61: {
                    this.readNextChar();
                    return new token(64);
                }
                case 58: {
                    this.readNextChar();
                    return new token(66);
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber();
                }
                case 34: {
                    return this.readQuotedString();
                }
                case 123: {
                    return this.readRegList();
                }
                case 39: {
                    return this.readQuotedReservedWord();
                }
            }
            break;
        }
        boolean only_name = false;
        this.charBuf.reset();
        do {
            char chval = (char)this.nextChar;
            if (this.nextChar == 92) {
                chval = this.nameEscape();
                only_name = true;
            }
            this.charBuf.add(chval);
            this.readNextChar();
        } while (!Scanner.isSeparator(this.nextChar));
        String str = this.charBuf.toString();
        if (!only_name) {
            token tok = ReservedWords.get(str);
            if (tok != null) {
                return tok;
            }
            if (DopInfo.contains(str)) {
                return new str_token(69, str);
            }
            if (str.charAt(0) == '$') {
                String s = str.substring(1);
                int n = 10;
                boolean neg = false;
                switch (s.charAt(0)) {
                    default: {
                        break;
                    }
                    case '-': {
                        neg = true;
                    }
                    case '+': {
                        s = s.substring(1);
                        if (s.startsWith("0x")) {
                            n = 16;
                            s = s.substring(2);
                        }
                        try {
                            n = Integer.parseInt(s, n);
                        }
                        catch (NumberFormatException e) {
                            throw new DasmError("Bad relative offset number");
                        }
                        if (neg) {
                            n = -n;
                        }
                        return new relative_number_token(72, n);
                    }
                }
                Object v = this.dict.get(s);
                if (v != null) {
                    return (token)v;
                }
            }
        }
        return new str_token(68, str);
    }

    protected token readQuotedString() throws IOException, DasmError {
        boolean f = false;
        this.charBuf.reset();
        block13: while (true) {
            if (f) {
                f = false;
            } else {
                this.readNextChar();
            }
            if (this.nextChar == 34) {
                this.readNextChar();
                return new str_token(67, this.charBuf.toString());
            }
            if (this.nextChar == -1) {
                throw new DasmError("Unterminated string");
            }
            int chval = this.nextChar;
            if (chval == 92) {
                this.readNextChar();
                switch (this.nextChar) {
                    case -1: {
                        f = true;
                        continue block13;
                    }
                    case 110: {
                        chval = 10;
                        break;
                    }
                    case 114: {
                        chval = 13;
                        break;
                    }
                    case 116: {
                        chval = 9;
                        break;
                    }
                    case 102: {
                        chval = 12;
                        break;
                    }
                    case 98: {
                        chval = 8;
                        break;
                    }
                    case 34: {
                        chval = 34;
                        break;
                    }
                    case 39: {
                        chval = 39;
                        break;
                    }
                    case 92: {
                        chval = 92;
                        break;
                    }
                    case 117: {
                        chval = this.readUnicodeChar();
                        if (this.nextChar != -1) break;
                        f = true;
                        continue block13;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int res = this.nextChar & 7;
                        this.readNextChar();
                        if (this.nextChar < 48 || this.nextChar > 55) {
                            f = true;
                        } else {
                            res = res * 8 + (this.nextChar & 7);
                            this.readNextChar();
                            if (this.nextChar < 48 || this.nextChar > 55) {
                                f = true;
                            } else {
                                int val = res * 8 + (this.nextChar & 7);
                                if (val >= 256) {
                                    f = true;
                                } else {
                                    res = val;
                                }
                            }
                        }
                        chval = (char)res;
                        break;
                    }
                    default: {
                        throw new DasmError("Incorrect backslash escape sequence");
                    }
                }
            }
            this.charBuf.add((char)chval);
        }
    }

    protected token readRegList() throws IOException, DasmError {
        this.charBuf.reset();
        while (true) {
            this.readNextChar();
            if (this.nextChar == 125) {
                this.readNextChar();
                return new str_token(68, this.charBuf.toString());
            }
            if (this.nextChar == -1) {
                throw new DasmError("Unterminated list of registers");
            }
            this.charBuf.add((char)this.nextChar);
        }
    }

    protected token readNumber() throws IOException, DasmError {
        Number num;
        this.charBuf.reset();
        do {
            this.charBuf.add((char)this.nextChar);
            this.readNextChar();
        } while (!Scanner.isSeparator(this.nextChar));
        String str = this.charBuf.toString();
        token tok = ReservedWords.get(str);
        if (tok != null) {
            return tok;
        }
        try {
            num = Utils.stringToNumber(str);
        }
        catch (NumberFormatException e) {
            if (this.charBuf.charAt(0) != '.') {
                throw new DasmError("Bad number format");
            }
            throw new DasmError("Unknown directive or bad number format");
        }
        if (num instanceof Integer) {
            return new int_token(70, num.intValue());
        }
        return new number_token(71, num);
    }

    protected token readQuotedReservedWord() throws IOException, DasmError {
        this.charBuf.reset();
        while (true) {
            this.readNextChar();
            if (Scanner.isSeparator(this.nextChar)) {
                throw new DasmError("Unterminated ''-enclosed name");
            }
            if (this.nextChar == 39) {
                if (this.charBuf.size() == 0) {
                    throw new DasmError("Empty ''-enclosed name");
                }
                this.readNextChar();
                if (!Scanner.isSeparator(this.nextChar)) {
                    throw new DasmError("Missed separator after ''-enclosed name");
                }
                return new str_token(68, this.charBuf.toString());
            }
            char chval = (char)this.nextChar;
            if (this.nextChar == 92) {
                chval = this.nameEscape();
            }
            this.charBuf.add(chval);
        }
    }

    class CharBuffer {
        private int buffer_size = 256;
        private char[] buffer = new char[this.buffer_size];
        private int cur_pos = 0;

        CharBuffer() {
        }

        private void expand() {
            char[] tmp = new char[this.buffer_size * 2];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer_size);
            this.buffer_size *= 2;
            this.buffer = tmp;
        }

        void add(char c) {
            this.buffer[this.cur_pos] = c;
            ++this.cur_pos;
            if (this.cur_pos == this.buffer_size) {
                this.expand();
            }
        }

        int size() {
            return this.cur_pos;
        }

        char charAt(int idx) {
            return this.buffer[idx];
        }

        public String toString() {
            return new String(this.buffer, 0, this.cur_pos);
        }

        void reset() {
            this.cur_pos = 0;
        }
    }
}

