/*
 * Decompiled with CFR 0.152.
 */
package dasm;

import dasm.DAsm;
import dasm.DasmError;
import dasm.Utils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class Main {
    public static final String version = "v0.1";
    public static final boolean DEBUG = true;
    private static String destPath = null;
    private static boolean humanHeadable = false;
    private static String encoding = null;
    private static boolean generateLineNumbers = false;

    private static void incompleteOption(String opt) {
        System.err.println("Command line option " + opt + " required argument missed");
        System.exit(-1);
    }

    private static Reader createReader(String fname) throws IOException {
        FileInputStream fs = new FileInputStream(fname);
        InputStreamReader ir = encoding == null ? new InputStreamReader(fs) : new InputStreamReader((InputStream)fs, encoding);
        return new BufferedReader(ir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assemble(String fname) {
        DAsm dAsm = new DAsm();
        Reader inp = null;
        try {
            inp = Main.createReader(fname);
            dAsm.readD(inp, new File(fname).getName(), generateLineNumbers);
            Main.close(inp);
        }
        catch (DasmError e) {
            e.printStackTrace();
            System.err.println("DASM Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception <" + e.getClass().getName() + ">" + e.getMessage() + " while reading and parsing " + fname);
            return;
        }
        finally {
            Main.close(inp);
        }
        if (dAsm.errorCount() > 0) {
            System.err.println("Found " + dAsm.errorCount() + " errors " + " while reading and parsing " + fname);
            return;
        }
        String[] class_path = Utils.getClassFieldFromString(dAsm.getClassName());
        String class_name = class_path[1];
        String dest_dir = destPath;
        if (class_path[0] != null) {
            String class_dir = class_path[0].replaceAll("/|\\.", Character.toString(File.separatorChar));
            dest_dir = dest_dir != null ? dest_dir + File.separator + class_dir : class_dir;
        }
        File out_file = null;
        File hr_file = null;
        if (dest_dir == null) {
            out_file = new File(class_name + ".dex");
            hr_file = new File(class_name + ".dxt");
        } else {
            out_file = new File(dest_dir, class_name + ".dex");
            hr_file = new File(dest_dir, class_name + ".dxt");
            File dest = new File(dest_dir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if (!dest.isDirectory()) {
                System.err.println("Cannot create directory " + dest_dir);
                return;
            }
        }
        FileOutputStream outp = null;
        FileWriter hr_outp = null;
        try {
            outp = new FileOutputStream(out_file);
            if (humanHeadable) {
                hr_outp = new FileWriter(hr_file);
            }
            dAsm.write(outp, hr_outp);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                System.err.println("Exception <" + e.getClass().getName() + ">" + e.getMessage() + " while writing " + out_file.getPath());
                Main.close(hr_outp);
                Main.close(outp);
                hr_file.delete();
                out_file.delete();
            }
            catch (Throwable throwable) {
                Main.close(hr_outp);
                Main.close(outp);
                throw throwable;
            }
            Main.close(hr_outp);
            Main.close(outp);
            return;
        }
        Main.close(hr_outp);
        Main.close(outp);
        System.out.println("Generated: " + out_file.getPath());
    }

    private static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        int i;
        String[] files = new String[args.length];
        int num_files = 0;
        if (args.length == 0) {
            Main.printUsage();
            System.exit(-1);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-help") || args[i].equals("-?")) {
                Main.printUsage();
                System.exit(0);
            }
            if (args[i].equals("-version")) {
                System.out.println("DAsm version: v0.1");
                System.out.println("(compiled with DEBUG flag on)");
                System.exit(0);
            }
            if (args[i].equals("-g")) {
                generateLineNumbers = true;
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i >= args.length) {
                    Main.incompleteOption("-d");
                    continue;
                }
                destPath = args[i];
                continue;
            }
            if (args[i].equals("-h")) {
                humanHeadable = true;
                continue;
            }
            if (args[i].equals("-e")) {
                if (++i >= args.length) {
                    Main.incompleteOption("-e");
                    continue;
                }
                encoding = args[i];
                continue;
            }
            files[num_files++] = args[i];
        }
        for (i = 0; i < num_files; ++i) {
            Main.assemble(files[i]);
        }
    }

    static void printUsage() {
        System.err.println("dasm [-d <outpath>] [-g] [-h] [-e <encoding>] <file>[<file> ...]\n\n  -g - autogenerate linenumbers\n  -e - codepage for inputfile encoding\n  -d - path for generated classfiles\n  -h - generate human-readable output\n  file  - sourcefile\nor: dasm -version\nor: dasm -help");
    }
}

