/*
 * Decompiled with CFR 0.152.
 */
package dasm;

import com.android.dx.dex.code.CatchBuilder;
import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.dex.code.CatchTable;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import dasm.DAsm;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DasmCatchBuilder
implements CatchBuilder {
    private Vector<UnprocessedCatch> unprocessed_catches = new Vector();
    private Hashtable<String, DAsm.LabelTableEntry> labels_table;

    public DasmCatchBuilder(Hashtable<String, DAsm.LabelTableEntry> labels_table) {
        this.labels_table = labels_table;
    }

    public HashSet<Type> getCatchTypes() {
        int sz = this.unprocessed_catches.size();
        HashSet<Type> result = new HashSet<Type>(sz);
        for (int i = 0; i < sz; ++i) {
            Enumeration<CstType> keys = this.unprocessed_catches.elementAt((int)i).type_branch.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement().getClassType());
            }
        }
        return result;
    }

    public boolean hasAnyCatches() {
        return this.unprocessed_catches.size() != 0;
    }

    public void add(String exception, String start, String end, String branch) {
        int sz = this.unprocessed_catches.size();
        for (int i = 0; i < sz; ++i) {
            UnprocessedCatch uc = this.unprocessed_catches.elementAt(i);
            if (uc.from.compareToIgnoreCase(start) != 0) continue;
            if (uc.to.compareToIgnoreCase(end) != 0) {
                throw new RuntimeException("Bad .catch directive: two blocks have the same start address (" + uc.from + ") and different end addresses (" + uc.to + " and " + end + ")");
            }
            uc.add(exception, branch);
            return;
        }
        this.unprocessed_catches.add(new UnprocessedCatch(exception, start, end, branch));
    }

    public CatchTable build() {
        int sz = this.unprocessed_catches.size();
        CatchTable result = new CatchTable(sz);
        for (int i = 0; i < sz; ++i) {
            UnprocessedCatch uc = this.unprocessed_catches.elementAt(i);
            DAsm.LabelTableEntry lte = this.labels_table.get(uc.from);
            if (lte == null || !lte.planted) {
                throw new RuntimeException("Label " + uc.from + " not defined");
            }
            CodeAddress from = lte.code_address;
            lte = this.labels_table.get(uc.to);
            if (lte == null || !lte.planted) {
                throw new RuntimeException("Label " + uc.to + " not defined");
            }
            CodeAddress to = lte.code_address;
            CatchHandlerList chl = new CatchHandlerList(uc.type_branch.size());
            Enumeration<CstType> keys = uc.type_branch.keys();
            int j = 0;
            CatchHandlerList.Entry catch_all = null;
            while (keys.hasMoreElements()) {
                CstType type = keys.nextElement();
                String branch = uc.type_branch.get(type);
                lte = this.labels_table.get(branch);
                if (lte == null || !lte.planted) {
                    throw new RuntimeException("Label " + branch + " not defined");
                }
                CatchHandlerList.Entry chle = new CatchHandlerList.Entry(type, lte.code_address.getAddress());
                if (type.equals((Object)CstType.OBJECT)) {
                    catch_all = chle;
                    continue;
                }
                chl.set(j, chle);
                ++j;
            }
            if (catch_all != null) {
                chl.set(j, catch_all);
            }
            chl.setImmutable();
            CatchTable.Entry entry = new CatchTable.Entry(from.getAddress(), to.getAddress(), chl);
            result.set(i, entry);
        }
        return result;
    }

    private class UnprocessedCatch {
        String from;
        String to;
        Hashtable<CstType, String> type_branch = new Hashtable();

        UnprocessedCatch(String exception, String from, String to, String branch) {
            this.from = from;
            this.to = to;
            this.add(exception, branch);
        }

        void add(String exception, String branch) {
            CstType type = exception.compareToIgnoreCase("all") == 0 ? CstType.OBJECT : CstType.intern((Type)Type.internClassName((String)exception));
            String s = this.type_branch.get(type);
            if (s != null && s.compareToIgnoreCase(branch) != 0) {
                throw new RuntimeException("Bad .catch directive: same exception (" + exception + ") but different branch addresses (" + s + " and " + branch + ")");
            }
            this.type_branch.put(type, branch);
        }
    }
}

