/*
 * Decompiled with CFR 0.152.
 */
package dasm;

import com.android.dx.dex.code.ArrayData;
import com.android.dx.dex.code.CatchBuilder;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.OddSpacer;
import com.android.dx.dex.code.OutputFinisher;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.dex.code.SwitchData;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.dex.code.form.Form51l;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstByte;
import com.android.dx.rop.cst.CstChar;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstShort;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.IntList;
import dasm.DasmCatchBuilder;
import dasm.DasmError;
import dasm.DopInfo;
import dasm.Scanner;
import dasm.Utils;
import dasm.parser;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAsm {
    private static final boolean PARSER_DEBUG = false;
    int errors;
    DexFile dexFile;
    int line_num;
    Scanner scanner;
    boolean class_header;
    String class_name;
    int class_acc;
    String superclass_name;
    String source_name;
    String filename;
    Vector<String> interfaces = new Vector();
    ClassDefItem classDef;
    EncodedMethod enc_method;
    CstNat method_nat;
    int method_acc;
    int regs_count;
    OutputFinisher output_finisher;
    Vector<String> throw_list = new Vector();
    DasmCatchBuilder catch_builder;
    Hashtable<String, LabelTableEntry> labels_table;
    int current_insn_number;
    Hashtable<Integer, CodeAddress> unprocessed_relative_goto_addr = new Hashtable();
    int fill_data_reg;
    String fill_array_data_type;
    Vector<Number> fill_array_data_values;
    int switch_reg;
    Vector<Object> switch_targets;
    IntList switch_keys;
    int packed_switch_first_key;
    int packed_switch_current_key;
    Vector<DalvInsn> data_blocks = new Vector();

    public int errorCount() {
        return this.errors;
    }

    void report_error(String msg) {
        ++this.errors;
        System.out.println("Line " + this.line_num + ": " + msg);
    }

    void throwDasmError(String msg) throws DasmError {
        throw new DasmError("Line " + this.line_num + ": " + msg);
    }

    void addLineInfo(int line_num) throws DasmError {
        throw new IllegalStateException(".line not implemented");
    }

    void addLine(int line_num) throws DasmError {
        throw new IllegalStateException(".line not implemented");
    }

    void addVar(String startLab, String endLab, String name, String desc, String sign, int var_num) throws DasmError {
        throw new IllegalStateException(".var is not implemented");
    }

    void addVar(int startOffset, int endOffset, String name, String desc, String sign, int var_num) throws DasmError {
        throw new IllegalStateException(".var is not implemented");
    }

    void setLine(int l) {
        this.line_num = l;
    }

    void addInner(short iacc, String name, String inner, String outer) {
        throw new IllegalStateException(".inner is not implemented");
    }

    void setSource(String name) {
        this.source_name = name;
    }

    void setVersion(Number version2) {
        throw new IllegalStateException(".bytecode is not implemented");
    }

    void setClass(String name, int acc) {
        this.class_name = name;
        this.class_acc = acc;
        this.class_header = true;
        this.interfaces.clear();
        this.superclass_name = null;
    }

    public String getClassName() {
        return this.class_name;
    }

    void setSuperClass(String name) {
        this.superclass_name = name;
    }

    void addInterface(String name) {
        int sz = this.interfaces.size();
        boolean found = false;
        for (int i = 0; i < sz; ++i) {
            String s = this.interfaces.elementAt(i);
            if (s.compareTo(name) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            this.interfaces.add(name);
        }
    }

    void setSignature(String str) throws DasmError {
        throw new IllegalStateException(".signature is not implemented");
    }

    void setEnclosingMethod(String str) {
        throw new IllegalStateException(".enclosing is not implemented");
    }

    void addGenericAttr(String name, String file) throws DasmError {
        throw new IllegalStateException(".attribute is not implemented");
    }

    void endHeader() {
        TypeList tl = this.createTypeListFromStrings(this.interfaces);
        this.classDef = new ClassDefItem(CstType.intern((Type)Type.internClassName((String)this.class_name)), this.class_acc, this.superclass_name != null ? CstType.intern((Type)Type.internClassName((String)this.superclass_name)) : null, tl, new CstUtf8(this.source_name));
        this.dexFile.add(this.classDef);
        this.class_header = false;
    }

    void beginField(short access, String name, String desc, Object value) throws DasmError {
        throw new IllegalStateException("multiline fields are not implemented yet");
    }

    void endField() throws DasmError {
        throw new IllegalStateException("multiline fields are not implemented yet");
    }

    void addField(short access, String name, String desc, String sig, Object value) throws DasmError {
        CstNat nat = new CstNat(new CstUtf8(name), new CstUtf8(desc));
        CstFieldRef field = new CstFieldRef(this.classDef.getThisClass(), nat);
        EncodedField ef = new EncodedField(field, (int)access);
        if ((access & 8) != 0) {
            if (value != null) {
                throw new IllegalStateException("addField: field initialization not implemented yet");
            }
            this.classDef.addStaticField(ef, null);
        } else {
            this.classDef.addInstanceField(ef);
        }
    }

    void newMethod(String name, String descriptor, int access) {
        this.output_finisher = null;
        this.throw_list.clear();
        this.unprocessed_relative_goto_addr.clear();
        this.labels_table = new Hashtable();
        this.catch_builder = new DasmCatchBuilder(this.labels_table);
        this.current_insn_number = 0;
        this.regs_count = 1;
        this.method_nat = new CstNat(new CstUtf8(name), new CstUtf8(descriptor));
        if (this.method_nat.isClassInit()) {
            access |= 8;
        }
        if (this.method_nat.isInstanceInit()) {
            access |= 0x10000;
        }
        this.method_acc = access;
    }

    void endMethod() throws DasmError {
        int sz = this.data_blocks.size();
        for (int i = 0; i < sz; ++i) {
            this.addInsn(this.data_blocks.elementAt(i));
        }
        this.data_blocks.clear();
        if (this.unprocessed_relative_goto_addr.size() != 0) {
            this.report_error("Relative forward jump offset too big.");
        }
        Enumeration<String> e = this.labels_table.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            LabelTableEntry lte = this.labels_table.get(key);
            if (lte.planted) continue;
            this.report_error("Label " + key + " not found.");
        }
        TypeList tl = this.createTypeListFromStrings(this.throw_list);
        CstMethodRef meth = new CstMethodRef(this.classDef.getThisClass(), this.method_nat);
        DalvCode code = null;
        if (this.output_finisher != null) {
            code = new DalvCode(1, this.output_finisher, (CatchBuilder)this.catch_builder);
        }
        this.enc_method = new EncodedMethod(meth, this.method_acc, code, tl);
        if (meth.isInstanceInit() || meth.isClassInit() || (this.method_acc & 8) != 0 || (this.method_acc & 2) != 0) {
            this.classDef.addDirectMethod(this.enc_method);
        } else {
            this.classDef.addVirtualMethod(this.enc_method);
        }
        this.catch_builder = null;
        this.labels_table = null;
    }

    void setRegsSize(int v) throws DasmError {
        this.regs_count = v;
    }

    void addThrow(String name) throws DasmError {
        this.throw_list.add(name);
    }

    void addCatch(String name, String start_lab, String end_lab, String branch_lab) throws DasmError {
        this.catch_builder.add(name, start_lab, end_lab, branch_lab);
    }

    void addCatch(String name, int start_off, int end_off, int branch_off) throws DasmError {
        throw new IllegalStateException("addCatch(String, int, int, int) is not implemented yet");
    }

    void plantLabel(String name) throws DasmError {
        this.createOutputFinisher();
        LabelTableEntry lte = this.labels_table.get(name);
        if (lte != null) {
            if (lte.planted) {
                this.report_error("Label " + name + " already defined");
            } else {
                lte.planted = true;
                this.addInsn((DalvInsn)lte.code_address);
            }
        } else {
            CodeAddress code_address = new CodeAddress(this.createSourcePosition());
            this.addInsn((DalvInsn)code_address);
            this.labels_table.put(name, new LabelTableEntry(code_address, true));
        }
    }

    void addOpcode(String name) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.equals("")) {
            SimpleInsn dalvInsn = new SimpleInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.EMPTY);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Missing arguments for instruction " + name);
        }
    }

    void addOpcode(String name, String val) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("R") == 0) {
            int reg_num = -1;
            try {
                reg_num = this.getRegNumberFromString(val);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
            }
            RegisterSpec reg_spec = RegisterSpec.make((int)reg_num, (TypeBearer)Type.INT);
            SimpleInsn dalvInsn = new SimpleInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg_spec));
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("A") == 0) {
            LabelTableEntry lte = this.labels_table.get(val);
            if (lte == null) {
                CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
                lte = new LabelTableEntry(code_address, false);
                this.labels_table.put(val, lte);
            }
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.EMPTY, lte.code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
        }
    }

    void addRelativeGoto(String name, int val) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("A") == 0) {
            if (val == 0) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
            }
            CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
            if (val < 0) {
                this.output_finisher.insert(this.current_insn_number + val, (DalvInsn)code_address);
                ++this.current_insn_number;
            } else {
                this.unprocessed_relative_goto_addr.put(this.current_insn_number + val, code_address);
            }
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.EMPTY, code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
        }
    }

    void addOpcode(String name, String v1, String v2) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RR") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            SimpleInsn dalvInsn = new SimpleInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec));
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RA") == 0) {
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            LabelTableEntry lte = this.labels_table.get(v2);
            if (lte == null) {
                CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
                lte = new LabelTableEntry(code_address, false);
                this.labels_table.put(v2, lte);
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec), lte.code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RS") == 0) {
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.STRING);
            CstString constant = new CstString(new CstUtf8(v2));
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RT") == 0) {
            Type type;
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                type = Type.intern((String)v2);
            }
            catch (IllegalArgumentException e) {
                type = Type.internClassName((String)v2);
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)type);
            CstType constant = CstType.intern((Type)type);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("ZT") == 0 || insn.args.compareToIgnoreCase("ZM") == 0 || insn.args.compareToIgnoreCase("ZY") == 0) {
            CstType constant;
            RegisterSpecList reg_spec_list = RegisterSpecList.EMPTY;
            String[] regs = Utils.splitRegList(v1);
            if (regs != null) {
                int rn = regs.length;
                if (rn == 0 || rn > 5) {
                    this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
                }
                int[] reg_num = new int[rn];
                reg_spec_list = new RegisterSpecList(rn);
                for (int i = 0; i < rn; ++i) {
                    try {
                        reg_num[i] = this.getRegNumberFromString(regs[i]);
                    }
                    catch (IllegalArgumentException e) {
                        this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
                    }
                    reg_spec_list.set(i, RegisterSpec.make((int)reg_num[i], (TypeBearer)Type.INT));
                }
            }
            if (insn.args.compareToIgnoreCase("ZT") == 0) {
                Type type;
                try {
                    type = Type.intern((String)v2);
                }
                catch (IllegalArgumentException e) {
                    type = Type.internClassName((String)v2);
                }
                constant = CstType.intern((Type)type);
            } else {
                String[] names = Utils.getClassMethodSignatureFromString(v2);
                CstNat method_nat = new CstNat(new CstUtf8(names[1]), new CstUtf8(names[2]));
                constant = new CstMethodRef(CstType.intern((Type)Type.internClassName((String)names[0])), method_nat);
            }
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), reg_spec_list, (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("GT") == 0 || insn.args.compareToIgnoreCase("GM") == 0 || insn.args.compareToIgnoreCase("GY") == 0) {
            CstType constant;
            RegisterSpecList reg_spec_list;
            String[] regs = Utils.splitRegList(v1);
            if (regs != null && regs.length > 0) {
                int regC = -1;
                int regN = -1;
                try {
                    regC = this.getRegNumberFromString(regs[0]);
                }
                catch (IllegalArgumentException e) {
                    this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
                }
                if (regs.length > 1) {
                    try {
                        regN = this.getRegNumberFromString(regs[1]);
                    }
                    catch (IllegalArgumentException e) {
                        this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
                    }
                    if (regC >= regN) {
                        this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
                    }
                } else {
                    regN = regC;
                }
                int sz = regN - regC + 1;
                reg_spec_list = new RegisterSpecList(sz);
                for (int i = 0; i < sz; ++i) {
                    reg_spec_list.set(i, RegisterSpec.make((int)(regC + i), (TypeBearer)Type.INT));
                }
            } else {
                reg_spec_list = RegisterSpecList.EMPTY;
            }
            if (insn.args.compareToIgnoreCase("GT") == 0) {
                Type type;
                try {
                    type = Type.intern((String)v2);
                }
                catch (IllegalArgumentException e) {
                    type = Type.internClassName((String)v2);
                }
                constant = CstType.intern((Type)type);
            } else {
                String[] names = Utils.getClassMethodSignatureFromString(v2);
                CstNat method_nat = new CstNat(new CstUtf8(names[1]), new CstUtf8(names[2]));
                constant = new CstMethodRef(CstType.intern((Type)Type.internClassName((String)names[0])), method_nat);
            }
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), reg_spec_list, (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ", " + v2 + ")");
        }
    }

    void addRelativeGoto(String name, String v1, int val) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RA") == 0) {
            if (val == 0) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
            }
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpecList rsl = RegisterSpecList.make((RegisterSpec)reg1_spec);
            CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
            if (val < 0) {
                this.output_finisher.insert(this.current_insn_number + val, (DalvInsn)code_address);
                ++this.current_insn_number;
            } else {
                this.unprocessed_relative_goto_addr.put(this.current_insn_number + val, code_address);
            }
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), rsl, code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
        }
    }

    void addOpcode(String name, String v1, Number v2) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RI") == 0) {
            CstLong constant;
            RegisterSpec reg1_spec;
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            if (v2 instanceof Long || v2 instanceof Integer && insn.opcode.getFormat() == Form51l.THE_ONE) {
                reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.LONG);
                constant = CstLong.make((long)v2.longValue());
            } else if (v2 instanceof Float && insn.opcode.getFormat() != Form51l.THE_ONE) {
                reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.FLOAT);
                constant = CstFloat.make((int)Float.floatToIntBits(v2.floatValue()));
            } else if (v2 instanceof Double || v2 instanceof Float && insn.opcode.getFormat() == Form51l.THE_ONE) {
                reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.DOUBLE);
                constant = CstDouble.make((long)Double.doubleToLongBits(v2.doubleValue()));
            } else {
                reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
                constant = CstInteger.make((int)v2.intValue());
            }
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ", " + v2 + ")");
        }
    }

    void addOpcode(String name, String v1, String v2, String v3) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RRR") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            int reg3_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            try {
                reg3_num = this.getRegNumberFromString(v3);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v3 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            RegisterSpec reg3_spec = RegisterSpec.make((int)reg3_num, (TypeBearer)Type.INT);
            SimpleInsn dalvInsn = new SimpleInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec, (RegisterSpec)reg3_spec));
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RRA") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            LabelTableEntry lte = this.labels_table.get(v3);
            if (lte == null) {
                CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
                lte = new LabelTableEntry(code_address, false);
                this.labels_table.put(v3, lte);
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec), lte.code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RF") == 0) {
            int reg1_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            String[] names = Utils.getClassFieldFromString(v2);
            CstNat field_nat = new CstNat(new CstUtf8(names[1]), new CstUtf8(v3));
            CstFieldRef constant = new CstFieldRef(CstType.intern((Type)Type.internClassName((String)names[0])), field_nat);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("RRT") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            Type type = Type.internClassName((String)v3);
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)type);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)type);
            CstType constant = CstType.intern((Type)type);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ", " + v2 + ", " + v3 + ")");
        }
    }

    void addOpcode(String name, String v1, String v2, String v3, String v4) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RRF") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            String[] names = Utils.getClassFieldFromString(v3);
            CstNat field_nat = new CstNat(new CstUtf8(names[1]), new CstUtf8(v4));
            CstFieldRef constant = new CstFieldRef(CstType.intern((Type)Type.internClassName((String)names[0])), field_nat);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else if (insn.args.compareToIgnoreCase("GT") == 0) {
            Type type;
            String[] regs = Utils.splitRegList(v1);
            if (regs.length != 2) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            int regC = -1;
            int regN = -1;
            try {
                regC = this.getRegNumberFromString(regs[0]);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                regN = this.getRegNumberFromString(regs[1]);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            if (regC >= regN) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            int sz = regN - regC + 1;
            RegisterSpecList reg_spec_list = new RegisterSpecList(sz);
            for (int i = 0; i < sz; ++i) {
                reg_spec_list.set(i, RegisterSpec.make((int)(regC + i), (TypeBearer)Type.INT));
            }
            try {
                type = Type.intern((String)v2);
            }
            catch (IllegalArgumentException e) {
                type = Type.internClassName((String)v2);
            }
            CstType constant = CstType.intern((Type)type);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), reg_spec_list, (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ", " + v2 + ", " + v3 + ", " + v4 + ")");
        }
    }

    void addRelativeGoto(String name, String v1, String v2, int val) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RRA") == 0) {
            if (val == 0) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
            }
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            RegisterSpecList rsl = RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec);
            CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
            if (val < 0) {
                this.output_finisher.insert(this.current_insn_number + val, (DalvInsn)code_address);
                ++this.current_insn_number;
            } else {
                this.unprocessed_relative_goto_addr.put(this.current_insn_number + val, code_address);
            }
            TargetInsn dalvInsn = new TargetInsn(insn.opcode, this.createSourcePosition(), rsl, code_address);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + val + ")");
        }
    }

    void addOpcode(String name, String v1, String v2, int v3) throws DasmError {
        this.createOutputFinisher();
        DopInfo insn = DopInfo.get(name);
        if (insn.args.compareToIgnoreCase("RRI") == 0) {
            int reg1_num = -1;
            int reg2_num = -1;
            try {
                reg1_num = this.getRegNumberFromString(v1);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ")");
            }
            try {
                reg2_num = this.getRegNumberFromString(v2);
            }
            catch (IllegalArgumentException e) {
                this.throwDasmError("Bad arguments for instruction " + name + "(" + v2 + ")");
            }
            RegisterSpec reg1_spec = RegisterSpec.make((int)reg1_num, (TypeBearer)Type.INT);
            RegisterSpec reg2_spec = RegisterSpec.make((int)reg2_num, (TypeBearer)Type.INT);
            CstInteger constant = CstInteger.make((int)v3);
            CstInsn dalvInsn = new CstInsn(insn.opcode, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)reg1_spec, (RegisterSpec)reg2_spec), (Constant)constant);
            this.addInsn((DalvInsn)dalvInsn);
        } else {
            this.throwDasmError("Bad arguments for instruction " + name + "(" + v1 + ", " + v2 + ", " + v3 + ")");
        }
    }

    void newFillArrayData(String reg, String type) throws DasmError {
        try {
            this.fill_data_reg = this.getRegNumberFromString(reg);
        }
        catch (IllegalArgumentException e) {
            this.throwDasmError("Bad arguments for fill-array-data (" + reg + ")");
        }
        this.fill_array_data_type = type;
        this.fill_array_data_values = new Vector();
    }

    void addFillArrayData(Number num) throws DasmError {
        this.fill_array_data_values.add(num);
    }

    void endFillArrayData() throws DasmError {
        int sz = this.fill_array_data_values.size();
        ArrayList<CstLong> values = new ArrayList<CstLong>(sz);
        CstType arrayType = CstType.intern((Type)Type.intern((String)("[" + this.fill_array_data_type)));
        for (int i = 0; i < sz; ++i) {
            Number num = this.fill_array_data_values.elementAt(i);
            Object constant = arrayType == CstType.LONG_ARRAY ? CstLong.make((long)num.longValue()) : (arrayType == CstType.FLOAT_ARRAY ? CstFloat.make((int)Float.floatToIntBits(num.floatValue())) : (arrayType == CstType.DOUBLE_ARRAY ? CstDouble.make((long)Double.doubleToLongBits(num.doubleValue())) : (arrayType == CstType.BOOLEAN_ARRAY ? CstBoolean.make((int)num.intValue()) : (arrayType == CstType.BYTE_ARRAY ? CstByte.make((int)num.intValue()) : (arrayType == CstType.CHAR_ARRAY ? CstChar.make((int)num.intValue()) : (arrayType == CstType.SHORT_ARRAY ? CstShort.make((int)num.intValue()) : CstInteger.make((int)num.intValue())))))));
            values.add((CstLong)constant);
        }
        CodeAddress insn_addr = new CodeAddress(this.createSourcePosition());
        CodeAddress data_addr = new CodeAddress(SourcePosition.NO_INFO);
        TargetInsn dalvInsn = new TargetInsn(Dops.FILL_ARRAY_DATA, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)RegisterSpec.make((int)this.fill_data_reg, (TypeBearer)Type.intern((String)this.fill_array_data_type))), data_addr);
        OddSpacer spacer = new OddSpacer(SourcePosition.NO_INFO);
        ArrayData array_data = new ArrayData(SourcePosition.NO_INFO, insn_addr, values, (Constant)arrayType);
        this.addInsn((DalvInsn)insn_addr);
        this.addInsn((DalvInsn)dalvInsn);
        this.data_blocks.add((DalvInsn)spacer);
        this.data_blocks.add((DalvInsn)data_addr);
        this.data_blocks.add((DalvInsn)array_data);
        this.fill_array_data_values = null;
        this.fill_array_data_type = null;
    }

    void newPackedSwitch(String reg, int first_key) throws DasmError {
        try {
            this.switch_reg = this.getRegNumberFromString(reg);
        }
        catch (IllegalArgumentException e) {
            this.throwDasmError("Bad arguments for packed-switch (" + reg + ")");
        }
        this.packed_switch_first_key = first_key;
        this.packed_switch_current_key = 0;
        this.switch_targets = new Vector();
        this.switch_keys = new IntList();
    }

    void addPackedSwitchData(String target) throws DasmError {
        this.switch_targets.add(target);
        this.switch_keys.add(this.packed_switch_first_key + this.packed_switch_current_key);
        ++this.packed_switch_current_key;
    }

    void addPackedSwitchData(int target) throws DasmError {
        this.switch_targets.add(new Integer(target));
        this.switch_keys.add(this.packed_switch_first_key + this.packed_switch_current_key);
        ++this.packed_switch_current_key;
    }

    void newSparseSwitch(String reg) throws DasmError {
        try {
            this.switch_reg = this.getRegNumberFromString(reg);
        }
        catch (IllegalArgumentException e) {
            this.throwDasmError("Bad arguments for sparse-switch (" + reg + ")");
        }
        this.switch_targets = new Vector();
        this.switch_keys = new IntList();
    }

    void addSparseSwitchData(int key, String target) throws DasmError {
        this.switch_targets.add(target);
        this.switch_keys.add(key);
    }

    void addSparseSwitchData(int key, int target) throws DasmError {
        this.switch_targets.add(new Integer(target));
        this.switch_keys.add(key);
    }

    void endSwitch() throws DasmError {
        int sz = this.switch_targets.size();
        CodeAddress[] targets = new CodeAddress[sz];
        for (int i = 0; i < sz; ++i) {
            CodeAddress addr;
            Object t;
            Object o = this.switch_targets.elementAt(i);
            if (o instanceof String) {
                t = (String)o;
                LabelTableEntry lte = this.labels_table.get(t);
                if (lte == null) {
                    CodeAddress code_address = new CodeAddress(SourcePosition.NO_INFO);
                    lte = new LabelTableEntry(code_address, false);
                    this.labels_table.put((String)t, lte);
                }
                addr = lte.code_address;
            } else {
                t = (Integer)o;
                addr = new CodeAddress(SourcePosition.NO_INFO);
                if ((Integer)t < 0) {
                    this.output_finisher.insert(this.current_insn_number + (Integer)t, (DalvInsn)addr);
                    ++this.current_insn_number;
                } else {
                    this.unprocessed_relative_goto_addr.put(this.current_insn_number + (Integer)t, addr);
                }
            }
            targets[i] = addr;
        }
        CodeAddress insn_addr = new CodeAddress(this.createSourcePosition());
        CodeAddress data_addr = new CodeAddress(SourcePosition.NO_INFO);
        OddSpacer spacer = new OddSpacer(SourcePosition.NO_INFO);
        SwitchData switch_data = new SwitchData(SourcePosition.NO_INFO, insn_addr, this.switch_keys, targets);
        TargetInsn dalvInsn = new TargetInsn(switch_data.isPacked() ? Dops.PACKED_SWITCH : Dops.SPARSE_SWITCH, this.createSourcePosition(), RegisterSpecList.make((RegisterSpec)RegisterSpec.make((int)this.switch_reg, (TypeBearer)Type.INT)), data_addr);
        this.addInsn((DalvInsn)insn_addr);
        this.addInsn((DalvInsn)dalvInsn);
        this.data_blocks.add((DalvInsn)spacer);
        this.data_blocks.add((DalvInsn)data_addr);
        this.data_blocks.add((DalvInsn)switch_data);
        this.switch_targets = null;
        this.switch_keys = null;
    }

    protected SourcePosition createSourcePosition() {
        return new SourcePosition(new CstUtf8(this.filename), -1, this.line_num);
    }

    protected TypeList createTypeListFromStrings(Vector<String> strings) {
        StdTypeList tl;
        if (strings.size() == 0) {
            tl = StdTypeList.EMPTY;
        } else {
            int sz = strings.size();
            tl = new StdTypeList(sz);
            for (int i = 0; i < sz; ++i) {
                tl.set(i, Type.internClassName((String)strings.elementAt(i)));
            }
        }
        return tl;
    }

    private void createOutputFinisher() {
        if (this.output_finisher == null) {
            this.output_finisher = new OutputFinisher(5, this.regs_count);
        }
    }

    private int getRegNumberFromString(String val) throws IllegalArgumentException {
        int reg_num;
        int l = "v".length();
        if (val.length() <= l || val.substring(0, l).compareToIgnoreCase("v") != 0) {
            throw new IllegalArgumentException("Wrong register name prefix");
        }
        try {
            reg_num = Integer.parseInt(val.substring(l));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong register name");
        }
        return reg_num;
    }

    private void addInsn(DalvInsn insn) {
        this.createOutputFinisher();
        CodeAddress code_address = this.unprocessed_relative_goto_addr.get(this.current_insn_number);
        if (code_address != null) {
            this.output_finisher.add((DalvInsn)code_address);
            this.unprocessed_relative_goto_addr.remove(this.current_insn_number);
            ++this.current_insn_number;
        }
        this.output_finisher.add(insn);
        ++this.current_insn_number;
    }

    public void write(OutputStream outp, FileWriter human_readable) throws IOException, DasmError {
        this.dexFile.writeTo(outp, (Writer)human_readable, true);
    }

    public void readD(Reader input, String name, boolean numberLines) throws IOException, Exception {
        this.errors = 0;
        this.filename = name;
        this.source_name = name;
        this.class_header = false;
        this.classDef = null;
        this.dexFile = new DexFile();
        this.scanner = new Scanner(input);
        parser parse_obj = new parser(this, this.scanner);
        parse_obj.parse();
    }

    class LabelTableEntry {
        CodeAddress code_address;
        boolean planted;

        LabelTableEntry(CodeAddress code_address, boolean planted) {
            this.code_address = code_address;
            this.planted = planted;
        }
    }
}

