/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.HostConfig;
import com.android.cts.XMLResourceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPlan
extends XMLResourceHandler {
    public static final String EXCLUDE_SEPARATOR = ";";

    public static Collection<String> getEntries(String planPath, ArrayList<String> removedPkgList) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> entries = new ArrayList<String>();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        File planFile = new File(planPath);
        Document doc = builder.parse(planFile);
        NodeList pkgEntries = doc.getElementsByTagName("Entry");
        for (int i = 0; i < pkgEntries.getLength(); ++i) {
            Node pkgEntry = pkgEntries.item(i);
            String uri = TestPlan.getStringAttributeValue(pkgEntry, "uri");
            String packageBinaryName = HostConfig.getInstance().getPackageBinaryName(uri);
            if (packageBinaryName != null) {
                entries.add(TestPlan.getStringAttributeValue(pkgEntry, "uri"));
                continue;
            }
            removedPkgList.add(uri);
        }
        return entries;
    }

    public static boolean isValidPackageName(String pkgName) {
        String xmlPath = HostConfig.getInstance().getCaseRepository().getXmlPath(pkgName);
        String apkPath = HostConfig.getInstance().getCaseRepository().getApkPath(pkgName);
        File xmlFile = new File(xmlPath);
        File apkFile = new File(apkPath);
        return xmlFile.exists() && apkFile.exists();
    }

    public static interface Attribute {
        public static final String NAME = "name";
        public static final String URI = "uri";
        public static final String EXCLUDE = "exclude";
        public static final String AMOUNT = "amount";
    }

    public static interface Tag {
        public static final String TEST_SUITE = "TestSuite";
        public static final String ENTRY = "Entry";
        public static final String TEST_PLAN = "TestPlan";
        public static final String PLAN_SETTING = "PlanSettings";
        public static final String REQUIRED_DEVICE = "RequiredDevice";
        public static final String TEST_CASE = "TestCase";
    }
}

