/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.CommandParser;
import java.util.ArrayList;
import java.util.List;

public class CommandHistory {
    private static final int CMD_RECORD_DEPTH = 50;
    private List<String> mCmdRecords = new ArrayList<String>();

    public boolean isHistoryCommand(String cmd) {
        return "history".equals(cmd) || "h".equals(cmd);
    }

    public int size() {
        return this.mCmdRecords.size();
    }

    public String get(int index) {
        return this.mCmdRecords.get(index);
    }

    public void show(int cmdCount) {
        int cmdSize = this.mCmdRecords.size();
        int start = 0;
        if (cmdSize == 0) {
            CUIOutputStream.println("no history command list");
            return;
        }
        if (cmdCount < cmdSize) {
            start = cmdSize - cmdCount;
        }
        while (start < cmdSize) {
            String cmdLine = this.mCmdRecords.get(start);
            CUIOutputStream.println("  " + Long.toString(start) + "\t" + cmdLine);
            ++start;
        }
    }

    public void addCommand(CommandParser cp, String cmdLine) {
        if (cmdLine == null || cmdLine.length() == 0) {
            return;
        }
        if (this.isValidCommand(cp.getAction()) && !this.hasCommand(cmdLine)) {
            this.mCmdRecords.add(cmdLine);
            if (this.mCmdRecords.size() > 50) {
                this.mCmdRecords.remove(0);
            }
        }
    }

    private boolean isValidCommand(String action) {
        return !"history".equals(action) && !"h".equals(action) && ("add".equals(action) || "exit".equals(action) || "help".equals(action) || "ls".equals(action) || "rm".equals(action) || "start".equals(action));
    }

    private boolean hasCommand(String cmdLine) {
        for (String cmd : this.mCmdRecords) {
            if (!cmd.equals(cmdLine)) continue;
            return true;
        }
        return false;
    }
}

