/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.JarHostTest;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPackageDef {
    private static final String LOG_TAG = "TestPackageDef";
    private String mUri = null;
    private String mAppNameSpace = null;
    private String mName = null;
    private String mRunner = null;
    private boolean mIsHostSideTest = false;
    private String mJarPath = null;
    private boolean mIsSignatureTest = false;
    private boolean mIsReferenceAppTest = false;
    private Collection<TestIdentifier> mTests = new ArrayList<TestIdentifier>();

    void setUri(String uri) {
        this.mUri = uri;
    }

    public String getUri() {
        return this.mUri;
    }

    void setAppNameSpace(String appNameSpace) {
        this.mAppNameSpace = appNameSpace;
    }

    String getAppNameSpace() {
        return this.mAppNameSpace;
    }

    void setName(String name) {
        this.mName = name;
    }

    String getName() {
        return this.mName;
    }

    void setRunner(String runnerName) {
        this.mRunner = runnerName;
    }

    String getRunner() {
        return this.mRunner;
    }

    void setIsHostSideTest(boolean hostSideTest) {
        this.mIsHostSideTest = hostSideTest;
    }

    boolean isHostSideTest() {
        return this.mIsHostSideTest;
    }

    void setJarPath(String jarPath) {
        this.mJarPath = jarPath;
    }

    String getJarPath() {
        return this.mJarPath;
    }

    void setIsSignatureCheck(boolean isSignatureCheckTest) {
        this.mIsSignatureTest = isSignatureCheckTest;
    }

    boolean isSignatureCheck() {
        return this.mIsSignatureTest;
    }

    void setIsReferenceApp(boolean isReferenceApp) {
        this.mIsReferenceAppTest = isReferenceApp;
    }

    boolean isReferenceApp() {
        return this.mIsReferenceAppTest;
    }

    public IRemoteTest createTest(File testCaseDir) {
        if (this.mIsHostSideTest) {
            Log.d((String)LOG_TAG, (String)String.format("Creating host test for %s", this.mName));
            JarHostTest hostTest = new JarHostTest();
            hostTest.setRunName(this.mName);
            hostTest.setJarFile(new File(testCaseDir, this.mJarPath));
            hostTest.setTestAppPath(testCaseDir.getAbsolutePath());
            hostTest.setTests(this.mTests);
            return hostTest;
        }
        if (this.mIsSignatureTest) {
            Log.w((String)LOG_TAG, (String)String.format("Skipping currently unsupported signature test %s", this.mName));
            return null;
        }
        if (this.mIsReferenceAppTest) {
            Log.w((String)LOG_TAG, (String)String.format("Skipping currently unsupported reference app test %s", this.mName));
            return null;
        }
        Log.d((String)LOG_TAG, (String)String.format("Creating instrumentation test for %s", this.mName));
        InstrumentationTest instrTest = new InstrumentationTest();
        instrTest.setPackageName(this.mAppNameSpace);
        instrTest.setRunnerName(this.mRunner);
        File apkFile = new File(testCaseDir, String.format("%s.apk", this.mName));
        if (!apkFile.exists()) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find apk file %s", apkFile.getAbsolutePath()));
            return null;
        }
        instrTest.setInstallFile(apkFile);
        return instrTest;
    }

    void addTest(TestIdentifier testDef) {
        this.mTests.add(testDef);
    }

    Collection<TestIdentifier> getTests() {
        return this.mTests;
    }
}

