/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.ITestCaseRepo;
import com.android.cts.tradefed.testtype.TestPackageDef;
import com.android.cts.tradefed.testtype.TestPackageXmlParser;
import com.android.ddmlib.Log;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestCaseRepo
implements ITestCaseRepo {
    private static final String LOG_TAG = "TestCaseRepo";
    private File mTestCaseDir;
    private Map<String, TestPackageDef> mTestMap;

    public TestCaseRepo(File testCaseDir) {
        this.mTestCaseDir = testCaseDir;
        this.mTestMap = new Hashtable<String, TestPackageDef>();
        this.parse(this.mTestCaseDir);
    }

    private void parse(File dir) {
        File[] xmlFiles;
        for (File xmlFile : xmlFiles = dir.listFiles(new XmlFilter())) {
            this.parseTestFromXml(xmlFile);
        }
    }

    private void parseTestFromXml(File xmlFile) {
        TestPackageXmlParser parser = new TestPackageXmlParser();
        try {
            parser.parse(this.createStreamFromFile(xmlFile));
            TestPackageDef def = parser.getTestPackageDef();
            if (def != null) {
                this.mTestMap.put(def.getUri(), def);
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Could not find test package info in xml file %s", xmlFile.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find test case xml file %s", xmlFile.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)e);
        }
        catch (AbstractXmlParser.ParseException e) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to parse test case xml file %s", xmlFile.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)e);
        }
    }

    InputStream createStreamFromFile(File xmlFile) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(xmlFile));
    }

    @Override
    public Collection<IRemoteTest> getTests(Collection<String> testUris) {
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>(testUris.size());
        for (String uri : testUris) {
            TestPackageDef def = this.mTestMap.get(uri);
            if (def != null) {
                IRemoteTest test = def.createTest(this.mTestCaseDir);
                if (test != null) {
                    tests.add(test);
                    continue;
                }
                Log.w((String)LOG_TAG, (String)String.format("Failed to create test from package uri %s", uri));
                continue;
            }
            Log.w((String)LOG_TAG, (String)String.format("Could not find test with uri %s", uri));
        }
        return tests;
    }

    private static class XmlFilter
    implements FilenameFilter {
        private XmlFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

