/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.device.DeviceInfoCollector;
import com.android.cts.tradefed.testtype.IPlanXmlParser;
import com.android.cts.tradefed.testtype.ITestCaseRepo;
import com.android.cts.tradefed.testtype.PlanXmlParser;
import com.android.cts.tradefed.testtype.TestCaseRepo;
import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "PlanTest";
    public static final String TEST_CASES_DIR_OPTION = "test-cases-path";
    public static final String TEST_PLANS_DIR_OPTION = "test-plans-path";
    private ITestDevice mDevice;
    @Option(name="plan", description="the test plan to run")
    private String mPlanName = null;
    @Option(name="test-cases-path", description="file path to directory containing CTS test cases")
    private File mTestCaseDir = null;
    @Option(name="test-plans-path", description="file path to directory containing CTS test plans")
    private File mTestPlanDir = null;

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void setTestPlanDir(File planDir) {
        this.mTestPlanDir = planDir;
    }

    void setTestCaseDir(File testCaseDir) {
        this.mTestCaseDir = testCaseDir;
    }

    void setPlanName(String planName) {
        this.mPlanName = planName;
    }

    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.mPlanName == null) {
            throw new IllegalArgumentException("missing --plan option");
        }
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("missing device");
        }
        if (this.mTestCaseDir == null) {
            throw new IllegalArgumentException(String.format("missing %s option", TEST_CASES_DIR_OPTION));
        }
        if (this.mTestPlanDir == null) {
            throw new IllegalArgumentException(String.format("missing %s", TEST_PLANS_DIR_OPTION));
        }
        Log.i((String)LOG_TAG, (String)String.format("Executing CTS test plan %s", this.mPlanName));
        try {
            String ctsPlanRelativePath = String.format("%s.xml", this.mPlanName);
            File ctsPlanFile = new File(this.mTestPlanDir, ctsPlanRelativePath);
            IPlanXmlParser parser = this.createXmlParser();
            parser.parse(this.createXmlStream(ctsPlanFile));
            Collection<String> testUris = parser.getTestUris();
            ITestCaseRepo testRepo = this.createTestCaseRepo();
            Collection<IRemoteTest> tests = testRepo.getTests(testUris);
            this.collectDeviceInfo(this.getDevice(), this.mTestCaseDir, listeners);
            for (IRemoteTest test : tests) {
                if (test instanceof IDeviceTest) {
                    ((IDeviceTest)test).setDevice(this.getDevice());
                }
                test.run(listeners);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("failed to find CTS plan file", e);
        }
        catch (AbstractXmlParser.ParseException e) {
            throw new IllegalArgumentException("failed to parse CTS plan file", e);
        }
    }

    private void collectDeviceInfo(ITestDevice device, File testApkDir, List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        DeviceInfoCollector.collectDeviceInfo(device, testApkDir, listeners);
    }

    ITestCaseRepo createTestCaseRepo() {
        return new TestCaseRepo(this.mTestCaseDir);
    }

    IPlanXmlParser createXmlParser() {
        return new PlanXmlParser();
    }

    InputStream createXmlStream(File xmlFile) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(xmlFile));
    }
}

