/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.TestTimeoutException;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.hosttest.DeviceTest;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarHostTest
extends AbstractRemoteTest
implements IDeviceTest {
    private static final String LOG_TAG = "JarHostTest";
    private ITestDevice mDevice;
    private File mJarFile;
    private Collection<TestIdentifier> mTests;
    private long mTimeoutMs = 600000L;
    private String mRunName;
    private String mTestAppPath;

    void setJarFile(File jarFile) {
        this.mJarFile = jarFile;
    }

    void setTests(Collection<TestIdentifier> tests) {
        this.mTests = tests;
    }

    void setTimeout(long testTimeoutMs) {
        this.mTimeoutMs = testTimeoutMs;
    }

    void setRunName(String runName) {
        this.mRunName = runName;
    }

    void setTestAppPath(String testAppPath) {
        this.mTestAppPath = testAppPath;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public int countTestCases() {
        if (this.mTests == null) {
            throw new IllegalStateException();
        }
        return this.mTests.size();
    }

    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        this.checkFields();
        Log.i((String)LOG_TAG, (String)String.format("Running %s test package from jar, contains %d tests.", this.mRunName, this.countTestCases()));
        JUnitToInvocationResultForwarder resultForwarder = new JUnitToInvocationResultForwarder(listeners);
        TestResult junitResult = new TestResult();
        junitResult.addListener((TestListener)resultForwarder);
        long startTime = System.currentTimeMillis();
        this.reportRunStarted(listeners);
        for (TestIdentifier testId : this.mTests) {
            Test junitTest = this.loadTest(testId.getClassName(), testId.getTestName());
            if (junitTest == null) continue;
            this.runTest(testId, junitTest, junitResult);
        }
        this.reportRunEnded(System.currentTimeMillis() - startTime, listeners);
    }

    private void reportRunStarted(List<ITestInvocationListener> listeners) {
        for (ITestInvocationListener listener : listeners) {
            listener.testRunStarted(this.mRunName, this.countTestCases());
        }
    }

    private void runTest(TestIdentifier testId, final Test junitTest, final TestResult junitResult) {
        if (junitTest instanceof IDeviceTest) {
            ((IDeviceTest)junitTest).setDevice(this.getDevice());
        } else if (junitTest instanceof DeviceTest) {
            DeviceTest deviceTest = (DeviceTest)junitTest;
            deviceTest.setDevice(this.getDevice().getIDevice());
            deviceTest.setTestAppPath(this.mTestAppPath);
        }
        CommandStatus status = RunUtil.getInstance().runTimed(this.mTimeoutMs, new IRunUtil.IRunnableResult(){

            public boolean run() throws Exception {
                junitTest.run(junitResult);
                return true;
            }

            public void cancel() {
            }
        });
        if (status.equals((Object)CommandStatus.TIMED_OUT)) {
            junitResult.addError(junitTest, (Throwable)new TestTimeoutException());
            junitResult.endTest(junitTest);
        }
    }

    private void reportRunEnded(long elapsedTime, List<ITestInvocationListener> listeners) {
        for (ITestInvocationListener listener : listeners) {
            listener.testRunEnded(elapsedTime, Collections.EMPTY_MAP);
        }
    }

    private Test loadTest(String className, String testName) {
        try {
            URL[] urls = new URL[]{this.mJarFile.getCanonicalFile().toURI().toURL()};
            Class<?> testClass = this.loadClass(className, urls);
            if (TestCase.class.isAssignableFrom(testClass)) {
                TestCase testCase = (TestCase)testClass.newInstance();
                testCase.setName(testName);
                return testCase;
            }
            if (Test.class.isAssignableFrom(testClass)) {
                Test test = (Test)testClass.newInstance();
                return test;
            }
            Log.e((String)LOG_TAG, (String)String.format("Class '%s' from jar '%s' is not a Test", className, this.mJarFile.getAbsolutePath()));
        }
        catch (ClassNotFoundException e) {
            this.reportLoadError(this.mJarFile, className, e);
        }
        catch (IllegalAccessException e) {
            this.reportLoadError(this.mJarFile, className, e);
        }
        catch (IOException e) {
            this.reportLoadError(this.mJarFile, className, e);
        }
        catch (InstantiationException e) {
            this.reportLoadError(this.mJarFile, className, e);
        }
        return null;
    }

    Class<?> loadClass(String className, URL[] urls) throws ClassNotFoundException {
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> testClass = cl.loadClass(className);
        return testClass;
    }

    private void reportLoadError(File jarFile, String className, Exception e) {
        Log.e((String)LOG_TAG, (String)String.format("Failed to load test class '%s' from jar '%s'", className, jarFile.getAbsolutePath()));
        Log.e((String)LOG_TAG, (Throwable)e);
    }

    private void checkFields() {
        if (this.mRunName == null) {
            throw new IllegalArgumentException("run name has not been set");
        }
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mJarFile == null) {
            throw new IllegalArgumentException("jar file has not been set");
        }
        if (this.mTests == null) {
            throw new IllegalArgumentException("tests has not been set");
        }
    }
}

