/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.device;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.InstrumentationTest;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceInfoCollector {
    private static final String LOG_TAG = "DeviceInfoCollector";
    private static final String APK_NAME = "TestDeviceSetup";
    public static final String APP_PACKAGE_NAME = "android.tests.devicesetup";
    private static final String INSTRUMENTATION_NAME = "android.tests.getinfo.DeviceInfoInstrument";
    public static final String SCREEN_WIDTH = "screen_width";
    public static final String SCREEN_HEIGHT = "screen_height";
    public static final String PHONE_NUMBER = "phoneNumber";
    public static final String FEATURES = "features";
    public static final String PROCESSES = "processes";

    public static void collectDeviceInfo(ITestDevice device, File testApkDir, List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        File apkFile = new File(testApkDir, String.format("%s.apk", APK_NAME));
        if (!apkFile.exists()) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find %s", apkFile.getAbsolutePath()));
        }
        InstrumentationTest instrTest = new InstrumentationTest();
        instrTest.setDevice(device);
        instrTest.setInstallFile(apkFile);
        instrTest.setRerunMode(false);
        instrTest.setPackageName(APP_PACKAGE_NAME);
        instrTest.setRunnerName(INSTRUMENTATION_NAME);
        instrTest.run(listeners);
    }
}

