/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.TestPackageDef;
import com.android.cts.tradefed.testtype.TestPackageXmlParser;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestPackageXmlParserTest
extends TestCase {
    private static String INSTR_TEST_DATA = "<TestPackage AndroidFramework=\"Android 1.0\" appNameSpace=\"com.example\" appPackageName=\"android.example\" name=\"CtsExampleTestCases\" runner=\"android.test.InstrumentationTestRunner\" version=\"1.0\"></TestPackage>";
    private static String HOST_TEST_DATA = "<TestPackage hostSideOnly=\"true\" >\n    <TestSuite name=\"com\" >\n        <TestSuite name=\"example\" >\n            <TestCase name=\"ExampleTest\" >\n                <Test name=\"testFoo\" />\n                <Test name=\"testFoo2\" />\n            </TestCase>\n        </TestSuite>\n        <TestSuite name=\"example2\" >\n            <TestCase name=\"Example2Test\" >\n                <Test name=\"testFoo\" />\n            </TestCase>\n        </TestSuite>\n    </TestSuite>\n</TestPackage>";
    private static String BAD_HOST_TEST_DATA = "<TestPackage hostSideOnly=\"blah\" ></TestPackage>";
    private static String NO_TEST_DATA = "<invalid />";

    public void testParse_instrPackage() throws AbstractXmlParser.ParseException {
        TestPackageXmlParser parser = new TestPackageXmlParser();
        parser.parse(this.getStringAsStream(INSTR_TEST_DATA));
        TestPackageDef def = parser.getTestPackageDef();
        TestPackageXmlParserTest.assertEquals((String)"com.example", (String)def.getAppNameSpace());
        TestPackageXmlParserTest.assertEquals((String)"android.example", (String)def.getUri());
        TestPackageXmlParserTest.assertEquals((String)"android.test.InstrumentationTestRunner", (String)def.getRunner());
    }

    public void testParse_hostTest() throws AbstractXmlParser.ParseException {
        TestPackageXmlParser parser = new TestPackageXmlParser();
        parser.parse(this.getStringAsStream(HOST_TEST_DATA));
        TestPackageDef def = parser.getTestPackageDef();
        TestPackageXmlParserTest.assertTrue((boolean)def.isHostSideTest());
        TestPackageXmlParserTest.assertEquals((int)3, (int)def.getTests().size());
        Iterator iterator = def.getTests().iterator();
        TestIdentifier firstTest = (TestIdentifier)iterator.next();
        TestPackageXmlParserTest.assertEquals((String)"com.example.ExampleTest", (String)firstTest.getClassName());
        TestPackageXmlParserTest.assertEquals((String)"testFoo", (String)firstTest.getTestName());
        TestIdentifier secondTest = (TestIdentifier)iterator.next();
        TestPackageXmlParserTest.assertEquals((String)"com.example.ExampleTest", (String)secondTest.getClassName());
        TestPackageXmlParserTest.assertEquals((String)"testFoo2", (String)secondTest.getTestName());
        TestIdentifier thirdTest = (TestIdentifier)iterator.next();
        TestPackageXmlParserTest.assertEquals((String)"com.example2.Example2Test", (String)thirdTest.getClassName());
        TestPackageXmlParserTest.assertEquals((String)"testFoo", (String)thirdTest.getTestName());
    }

    public void testParse_badHostTest() throws AbstractXmlParser.ParseException {
        TestPackageXmlParser parser = new TestPackageXmlParser();
        parser.parse(this.getStringAsStream(BAD_HOST_TEST_DATA));
        TestPackageDef def = parser.getTestPackageDef();
        TestPackageXmlParserTest.assertFalse((boolean)def.isHostSideTest());
    }

    public void testParse_noData() throws AbstractXmlParser.ParseException {
        TestPackageXmlParser parser = new TestPackageXmlParser();
        parser.parse(this.getStringAsStream(NO_TEST_DATA));
        TestPackageXmlParserTest.assertNull((Object)parser.getTestPackageDef());
    }

    private InputStream getStringAsStream(String input) {
        return new ByteArrayInputStream(input.getBytes());
    }
}

