/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.IPlanXmlParser;
import com.android.cts.tradefed.testtype.ITestCaseRepo;
import com.android.cts.tradefed.testtype.PlanTest;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class PlanTestTest
extends TestCase {
    private PlanTest mPlanTest;
    private ITestCaseRepo mMockRepo;
    private IPlanXmlParser mMockPlanParser;
    private ITestDevice mMockDevice;
    private ITestInvocationListener mMockListener;
    private static final String PLAN_NAME = "CTS";

    protected void setUp() throws Exception {
        super.setUp();
        this.mMockRepo = EasyMock.createMock(ITestCaseRepo.class);
        this.mMockPlanParser = EasyMock.createMock(IPlanXmlParser.class);
        this.mMockDevice = EasyMock.createMock(ITestDevice.class);
        this.mMockListener = EasyMock.createNiceMock(ITestInvocationListener.class);
        this.mPlanTest = new PlanTest(){

            ITestCaseRepo createTestCaseRepo() {
                return PlanTestTest.this.mMockRepo;
            }

            IPlanXmlParser createXmlParser() {
                return PlanTestTest.this.mMockPlanParser;
            }

            InputStream createXmlStream(File xmlFile) throws FileNotFoundException {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
        this.mPlanTest.setDevice(this.mMockDevice);
        this.mPlanTest.setTestCaseDir(new File("tmp"));
        this.mPlanTest.setTestPlanDir(new File("tmp"));
        this.mPlanTest.setPlanName(PLAN_NAME);
    }

    public void testRun() throws DeviceNotAvailableException, AbstractXmlParser.ParseException {
        this.mMockPlanParser.parse((InputStream)EasyMock.anyObject());
        ArrayList<String> uris = new ArrayList<String>(1);
        uris.add("test-uri");
        EasyMock.expect(this.mMockPlanParser.getTestUris()).andReturn(uris);
        IRemoteTest mockTest = EasyMock.createMock(IRemoteTest.class);
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>(1);
        tests.add(mockTest);
        EasyMock.expect(this.mMockRepo.getTests(uris)).andReturn(tests);
        mockTest.run((List)EasyMock.anyObject());
        this.replayMocks();
        EasyMock.replay(mockTest);
        this.mPlanTest.run(this.mMockListener);
        this.verifyMocks();
    }

    private void replayMocks() {
        EasyMock.replay(this.mMockRepo, this.mMockPlanParser, this.mMockDevice, this.mMockListener);
    }

    private void verifyMocks() {
        EasyMock.verify(this.mMockRepo, this.mMockPlanParser, this.mMockDevice, this.mMockListener);
    }
}

