/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.targetsetup;

import com.android.cts.tradefed.targetsetup.CtsBuildHelper;
import com.android.cts.tradefed.targetsetup.CtsSetup;
import com.android.cts.tradefed.targetsetup.StubCtsBuildHelper;
import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.BuildError;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IFolderBuildInfo;
import com.android.tradefed.targetsetup.TargetSetupError;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class CtsSetupTest
extends TestCase {
    private static final String LOG_TAG = "CtsSetupTest";
    private CtsSetup mSetup;
    private ITestDevice mMockDevice;

    protected void setUp() throws Exception {
        super.setUp();
        this.mSetup = new CtsSetup(){

            CtsBuildHelper createBuildHelper(File rootDir) {
                try {
                    return StubCtsBuildHelper.createStubHelper();
                }
                catch (IOException e) {
                    Log.e((String)CtsSetupTest.LOG_TAG, (Throwable)e);
                    Assert.fail((String)"failed to create stub helper");
                    return null;
                }
            }
        };
        this.mMockDevice = EasyMock.createMock(ITestDevice.class);
    }

    public void testSetUp_wrongBuildInfo() throws TargetSetupError, BuildError, DeviceNotAvailableException {
        try {
            this.mSetup.setUp(this.mMockDevice, EasyMock.createMock(IBuildInfo.class));
            CtsSetupTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetUp() throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IFolderBuildInfo ctsBuild = EasyMock.createMock(IFolderBuildInfo.class);
        EasyMock.expect(ctsBuild.getRootDir()).andReturn(new File("tmp")).anyTimes();
        EasyMock.expect(ctsBuild.getBuildId()).andStubReturn(0);
        EasyMock.expect(this.mMockDevice.installPackage((File)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn(null).anyTimes();
        EasyMock.replay(ctsBuild, this.mMockDevice);
        this.mSetup.setUp(this.mMockDevice, (IBuildInfo)ctsBuild);
    }
}

