/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.targetsetup.BuildInfo;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;

public class CtsXmlResultReporterTest
extends TestCase {
    private CtsXmlResultReporter mResultReporter;
    private ByteArrayOutputStream mOutputStream;
    private File mReportDir;

    protected void setUp() throws Exception {
        super.setUp();
        this.mOutputStream = new ByteArrayOutputStream();
        this.mResultReporter = new CtsXmlResultReporter(){

            OutputStream createOutputResultStream(File reportDir) throws IOException {
                return CtsXmlResultReporterTest.this.mOutputStream;
            }

            String getTimestamp() {
                return "ignore";
            }
        };
        this.mReportDir = FileUtil.createTempDir((String)"foo");
        this.mResultReporter.setReportDir(this.mReportDir);
    }

    protected void tearDown() throws Exception {
        if (this.mReportDir != null) {
            FileUtil.recursiveDelete((File)this.mReportDir);
        }
        super.tearDown();
    }

    public void testEmptyGeneration() {
        String expectedOutput = "<?xml version='1.0' encoding='UTF-8' standalone='no' ?><?xml-stylesheet type=\"text/xsl\" href=\"cts_result.xsl\"?><TestResult testPlan=\"unknown\" profile=\"unknown\" starttime=\"ignore\" endtime=\"ignore\" version=\"2.0\"> <Summary failed=\"0\" notExecuted=\"0\" timeout=\"0\" omitted=\"0\" pass=\"0\" total=\"0\" /></TestResult>";
        this.mResultReporter.invocationStarted((IBuildInfo)new BuildInfo(1, "test", "test"));
        this.mResultReporter.invocationEnded(1L);
        CtsXmlResultReporterTest.assertEquals((String)"<?xml version='1.0' encoding='UTF-8' standalone='no' ?><?xml-stylesheet type=\"text/xsl\" href=\"cts_result.xsl\"?><TestResult testPlan=\"unknown\" profile=\"unknown\" starttime=\"ignore\" endtime=\"ignore\" version=\"2.0\"> <Summary failed=\"0\" notExecuted=\"0\" timeout=\"0\" omitted=\"0\" pass=\"0\" total=\"0\" /></TestResult>", (String)this.getOutput());
    }

    public void testSinglePass() {
        Map emptyMap = Collections.emptyMap();
        TestIdentifier testId = new TestIdentifier("com.foo.FooTest", "testFoo");
        this.mResultReporter.invocationStarted((IBuildInfo)new BuildInfo());
        this.mResultReporter.testRunStarted("run", 1);
        this.mResultReporter.testStarted(testId);
        this.mResultReporter.testEnded(testId, emptyMap);
        this.mResultReporter.testRunEnded(3000L, emptyMap);
        this.mResultReporter.invocationEnded(1L);
        String output = this.getOutput();
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains("<Summary failed=\"0\" notExecuted=\"0\" timeout=\"0\" omitted=\"0\" pass=\"1\" total=\"1\" />"));
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains("<TestPackage name=\"run\" runTime=\"3s\" digest=\"\" failed=\"0\" notExecuted=\"0\" timeout=\"0\" omitted=\"0\" pass=\"1\" total=\"1\">"));
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains(String.format("<TestCase name=\"%s\">", testId.getClassName())));
        String testCaseTag = String.format("<Test name=\"%s\" result=\"pass\" />", testId.getTestName());
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains(testCaseTag));
    }

    public void testSingleFail() {
        Map emptyMap = Collections.emptyMap();
        TestIdentifier testId = new TestIdentifier("FooTest", "testFoo");
        String trace = "this is a trace\nmore trace";
        this.mResultReporter.invocationStarted((IBuildInfo)new BuildInfo());
        this.mResultReporter.testRunStarted("run", 1);
        this.mResultReporter.testStarted(testId);
        this.mResultReporter.testFailed(ITestRunListener.TestFailure.FAILURE, testId, "this is a trace\nmore trace");
        this.mResultReporter.testEnded(testId, emptyMap);
        this.mResultReporter.testRunEnded(3L, emptyMap);
        this.mResultReporter.invocationEnded(1L);
        String output = this.getOutput();
        System.out.print(this.getOutput());
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains("<Summary failed=\"1\" notExecuted=\"0\" timeout=\"0\" omitted=\"0\" pass=\"0\" total=\"1\" />"));
        String failureTag = "<FailedScene message=\"this is a trace\">this is a tracemore trace";
        CtsXmlResultReporterTest.assertTrue((boolean)output.contains("<FailedScene message=\"this is a trace\">this is a tracemore trace"));
    }

    private String getOutput() {
        String output = this.mOutputStream.toString();
        output = output.replaceAll("[\\r\\n\\t]", "");
        return output.replaceAll("  ", " ");
    }
}

