/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import java.io.File;
import java.io.IOException;
import sun.tools.jar.Main;
import util.build.BuildStep;

public class JarBuildStep
extends BuildStep {
    String destFileName;
    private final boolean deleteInputFileAfterBuild;

    public JarBuildStep(BuildStep.BuildFile inputFile, String destFileName, BuildStep.BuildFile outputFile, boolean deleteInputFileAfterBuild) {
        super(inputFile, outputFile);
        this.destFileName = destFileName;
        this.deleteInputFileAfterBuild = deleteInputFileAfterBuild;
    }

    boolean build() {
        if (super.build()) {
            File tempFile = new File(this.inputFile.folder, this.destFileName);
            try {
                if (!this.inputFile.fileName.equals(tempFile)) {
                    JarBuildStep.copyFile(this.inputFile.fileName, tempFile);
                } else {
                    tempFile = null;
                }
            }
            catch (IOException e) {
                System.err.println("io exception:" + e.getMessage());
                e.printStackTrace();
                return false;
            }
            File outDir = this.outputFile.fileName.getParentFile();
            if (!outDir.exists() && !outDir.mkdirs()) {
                System.err.println("failed to create output dir: " + outDir.getAbsolutePath());
                return false;
            }
            Main main = new Main(System.out, System.err, "jar");
            String[] arguments = new String[]{"-cMf", this.outputFile.fileName.getAbsolutePath(), "-C", this.inputFile.folder.getAbsolutePath(), this.destFileName};
            boolean success = main.run(arguments);
            if (success) {
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (this.deleteInputFileAfterBuild) {
                    this.inputFile.fileName.delete();
                }
            } else {
                System.err.println("exception in JarBuildStep while calling jar with args: \"-cMf\", " + this.outputFile.fileName.getAbsolutePath() + ", \"-C\"," + this.inputFile.folder.getAbsolutePath() + ", " + this.destFileName);
            }
            return success;
        }
        return false;
    }

    public int hashCode() {
        return this.inputFile.hashCode() ^ this.outputFile.hashCode() ^ this.destFileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            JarBuildStep other = (JarBuildStep)obj;
            return this.inputFile.equals(other.inputFile) && this.outputFile.equals(other.outputFile) && this.destFileName.equals(other.destFileName);
        }
        return false;
    }
}

