/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BuildStep
implements Comparable<BuildStep> {
    BuildFile inputFile;
    BuildFile outputFile;
    private Set<BuildStep> children;

    BuildStep(BuildFile inputFile, BuildFile outputFile) {
        if (inputFile == null) {
            throw new NullPointerException("inputFile is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is null");
        }
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    BuildStep() {
    }

    boolean build() {
        if (this.children != null) {
            for (BuildStep child : this.children) {
                if (child.build()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    public abstract int hashCode();

    public void addChild(BuildStep child) {
        if (this.children == null) {
            this.children = new HashSet<BuildStep>();
        }
        this.children.add(child);
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    @Override
    public int compareTo(BuildStep o) {
        return this.inputFile == o.inputFile ? 0 : (this.inputFile != null ? (o.inputFile != null ? this.inputFile.getPath().compareTo(o.inputFile.getPath()) : 1) : -1);
    }

    static class BuildFile {
        final File folder;
        final File fileName;

        BuildFile(String folder, String fileName) {
            this.folder = new File(folder);
            this.fileName = new File(this.folder, fileName);
        }

        String getPath() {
            return this.fileName.getAbsolutePath();
        }

        public int hashCode() {
            return this.fileName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() == obj.getClass()) {
                BuildFile other = (BuildFile)obj;
                return this.fileName.equals(other.fileName);
            }
            return false;
        }
    }
}

