/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import com.android.dx.util.FileUtils;
import dot.junit.AllTests;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.textui.TestRunner;
import util.build.BuildStep;
import util.build.DFHBuildStep;
import util.build.DasmBuildStep;
import util.build.DexBuildStep;
import util.build.JarBuildStep;
import util.build.JavacBuildStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDalvikSuite {
    public static boolean DEBUG = true;
    private static String JAVASRC_FOLDER = "";
    private static String MAIN_SRC_OUTPUT_FOLDER = "";
    private static String HOSTJUNIT_SRC_OUTPUT_FOLDER = "";
    private static String OUTPUT_FOLDER = "";
    private static String COMPILED_CLASSES_FOLDER = "";
    private static String CLASSES_OUTPUT_FOLDER = "";
    private static String HOSTJUNIT_CLASSES_OUTPUT_FOLDER = "";
    private static String CLASS_PATH = "";
    private static String restrictTo = null;
    private static final String TARGET_JAR_ROOT_PATH = "/data/local/tmp";
    private int testClassCnt = 0;
    private int testMethodsCnt = 0;
    private LinkedHashMap<String, List<String>> map = new LinkedHashMap();
    private static final String ctsAllTestsB = "package dot.junit;\nimport junit.framework.Test;\nimport junit.framework.TestSuite;\nimport com.android.hosttest.DeviceTestSuite;\n\npublic class AllJunitHostTests extends DeviceTestSuite {\n    public static final Test suite() {\n        TestSuite suite = new TestSuite(\"CTS Host tests for all  dalvik vm opcodes\");\n";
    private static final String ctsAllTestsE = "    }}";
    private static final String curFileDataE = "}\n";
    private String curAllTestsData = "package dot.junit;\nimport junit.framework.Test;\nimport junit.framework.TestSuite;\nimport com.android.hosttest.DeviceTestSuite;\n\npublic class AllJunitHostTests extends DeviceTestSuite {\n    public static final Test suite() {\n        TestSuite suite = new TestSuite(\"CTS Host tests for all  dalvik vm opcodes\");\n";
    private String curJunitFileName = null;
    private String curJunitFileData = "";
    private JavacBuildStep javacHostJunitBuildStep;

    public static void main(String[] args) throws IOException {
        if (args.length > 5) {
            JAVASRC_FOLDER = args[0];
            OUTPUT_FOLDER = args[1];
            CLASS_PATH = args[2];
            MAIN_SRC_OUTPUT_FOLDER = args[3];
            CLASSES_OUTPUT_FOLDER = MAIN_SRC_OUTPUT_FOLDER + "/classes";
            COMPILED_CLASSES_FOLDER = args[4];
            HOSTJUNIT_SRC_OUTPUT_FOLDER = args[5];
            HOSTJUNIT_CLASSES_OUTPUT_FOLDER = HOSTJUNIT_SRC_OUTPUT_FOLDER + "/classes";
            if (args.length > 6) {
                restrictTo = args[6];
                System.out.println("restricting build to: " + restrictTo);
            }
        } else {
            System.out.println("usage: java-src-folder output-folder classpath generated-main-files compiled_output generated-main-files [restrict-to-opcode]");
            System.exit(-1);
        }
        long start = System.currentTimeMillis();
        BuildDalvikSuite cat = new BuildDalvikSuite();
        cat.compose();
        long end = System.currentTimeMillis();
        System.out.println("elapsed seconds: " + (end - start) / 1000L);
    }

    public void compose() throws IOException {
        System.out.println("Collecting all junit tests...");
        new TestRunner(){

            protected TestResult createTestResult() {
                return new TestResult(){

                    protected void run(TestCase test) {
                        BuildDalvikSuite.this.addToTests(test);
                    }
                };
            }
        }.doRun(AllTests.suite());
        this.handleTests();
    }

    private void addToTests(TestCase test) {
        String packageName = test.getClass().getPackage().getName();
        packageName = packageName.substring(packageName.lastIndexOf(46));
        String method = test.getName();
        String fqcn = test.getClass().getName();
        if (restrictTo != null && !fqcn.contains(restrictTo)) {
            return;
        }
        ++this.testMethodsCnt;
        List<String> li = this.map.get(fqcn);
        if (li == null) {
            ++this.testClassCnt;
            li = new ArrayList<String>();
            this.map.put(fqcn, li);
        }
        li.add(method);
    }

    private void flushHostJunitFile() {
        if (this.curJunitFileName != null) {
            File toWrite = new File(this.curJunitFileName);
            String absPath = toWrite.getAbsolutePath();
            this.javacHostJunitBuildStep.addSourceFile(absPath);
            this.curJunitFileData = this.curJunitFileData + "\n}\n";
            this.writeToFileMkdir(toWrite, this.curJunitFileData);
            this.curJunitFileName = null;
            this.curJunitFileData = "";
        }
    }

    private void ctsFinish() {
        this.flushHostJunitFile();
        this.curAllTestsData = this.curAllTestsData + "return suite;\n}\n}\n";
        String allTestsFileName = HOSTJUNIT_SRC_OUTPUT_FOLDER + "/dot/junit/AllJunitHostTests.java";
        File toWrite = new File(allTestsFileName);
        this.writeToFileMkdir(toWrite, this.curAllTestsData);
        this.javacHostJunitBuildStep.addSourceFile(toWrite.getAbsolutePath());
        this.javacHostJunitBuildStep.addSourceFile(new File(HOSTJUNIT_SRC_OUTPUT_FOLDER + "/dot/junit/DeviceUtil.java").getAbsolutePath());
    }

    private void openCTSHostFileFor(String pName, String classOnlyName) {
        String sourceName = "JUnit_" + classOnlyName;
        String suiteline = "suite.addTestSuite(" + pName + "." + sourceName + ".class);\n";
        this.curAllTestsData = this.curAllTestsData + suiteline;
        this.flushHostJunitFile();
        this.curJunitFileName = HOSTJUNIT_SRC_OUTPUT_FOLDER + "/" + pName.replaceAll("\\.", "/") + "/" + sourceName + ".java";
        this.curJunitFileData = "package " + pName + ";\n" + "import java.io.IOException;\n" + "import junit.framework.TestCase;\n" + "import com.android.hosttest.DeviceTestCase;\n" + "import dot.junit.DeviceUtil;\n" + "\n" + "public class " + sourceName + " extends DeviceTestCase {\n";
    }

    private String getADBPushJavaLine(String source, String target) {
        return "DeviceUtil.adbPush(getDevice(), \"" + source + "\", \"" + target + "\");";
    }

    private String getADBExecJavaLine(String classpath, String mainclass) {
        return "DeviceUtil.adbExec(getDevice(), \"" + classpath + "\", \"" + mainclass + "\");";
    }

    private void addCTSHostMethod(String pName, String method, MethodData md, Set<String> dependentTestClassNames) {
        String targetCoreJarPath = String.format("%s/dexcore.jar", TARGET_JAR_ROOT_PATH);
        this.curJunitFileData = this.curJunitFileData + "public void " + method + "() throws Exception {\n";
        this.curJunitFileData = this.curJunitFileData + "    " + this.getADBPushJavaLine("dot/junit/dexcore.jar", targetCoreJarPath);
        String mjar = "Main_" + method + ".jar";
        String mainJar = String.format("%s/%s", TARGET_JAR_ROOT_PATH, mjar);
        String pPath = pName.replaceAll("\\.", "/");
        this.curJunitFileData = this.curJunitFileData + "    " + this.getADBPushJavaLine(pPath + "/" + mjar, mainJar);
        String cp = String.format("%s:%s", targetCoreJarPath, mainJar);
        for (String depFqcn : dependentTestClassNames) {
            int lastDotPos = depFqcn.lastIndexOf(46);
            String targetName = String.format("%s/%s.jar", TARGET_JAR_ROOT_PATH, depFqcn.substring(lastDotPos + 1));
            String sourceName = depFqcn.replaceAll("\\.", "/") + ".jar";
            this.curJunitFileData = this.curJunitFileData + "    " + this.getADBPushJavaLine(sourceName, targetName);
            cp = cp + ":" + targetName;
        }
        String mainclass = pName + ".Main_" + method;
        this.curJunitFileData = this.curJunitFileData + "    " + this.getADBExecJavaLine(cp, mainclass);
        this.curJunitFileData = this.curJunitFileData + "}\n\n";
    }

    private void handleTests() throws IOException {
        System.out.println("collected " + this.testMethodsCnt + " test methods in " + this.testClassCnt + " junit test classes");
        String datafileContent = "";
        TreeSet<BuildStep> targets = new TreeSet<BuildStep>();
        this.javacHostJunitBuildStep = new JavacBuildStep(HOSTJUNIT_CLASSES_OUTPUT_FOLDER, CLASS_PATH);
        JavacBuildStep javacBuildStep = new JavacBuildStep(CLASSES_OUTPUT_FOLDER, CLASS_PATH);
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            String fqcn = entry.getKey();
            int lastDotPos = fqcn.lastIndexOf(46);
            String pName = fqcn.substring(0, lastDotPos);
            String classOnlyName = fqcn.substring(lastDotPos + 1);
            String instPrefix = "new " + classOnlyName + "()";
            this.openCTSHostFileFor(pName, classOnlyName);
            List<String> methods = entry.getValue();
            Collections.sort(methods, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            for (String method : methods) {
                String details;
                String description;
                String comment;
                if (!method.startsWith("test")) {
                    throw new RuntimeException("no test method: " + method);
                }
                MethodData md = this.parseTestMethod(pName, classOnlyName, method);
                String methodContent = md.methodBody;
                Set<String> dependentTestClassNames = this.parseTestClassName(pName, classOnlyName, methodContent);
                this.addCTSHostMethod(pName, method, md, dependentTestClassNames);
                if (dependentTestClassNames.isEmpty()) continue;
                String content = "//autogenerated by " + this.getClass().getName() + ", do not change\n" + "package " + pName + ";\n" + "import " + pName + ".d.*;\n" + "import dot.junit.*;\n" + "public class Main_" + method + " extends DxAbstractMain {\n" + "    public static void main(String[] args) " + "throws Exception {" + methodContent + "\n}\n";
                String fileName = this.getFileName(pName, method, ".java");
                File sourceFile = this.getFileFromPackage(pName, method);
                File classFile = new File(CLASSES_OUTPUT_FOLDER + "/" + this.getFileName(pName, method, ".class"));
                this.writeToFile(sourceFile, content);
                javacBuildStep.addSourceFile(sourceFile.getAbsolutePath());
                BuildStep dexBuildStep = this.generateDexBuildStep(CLASSES_OUTPUT_FOLDER, this.getFileName(pName, method, ""));
                targets.add(dexBuildStep);
                char ca = method.charAt("test".length());
                switch (ca) {
                    case 'N': {
                        comment = "Normal #" + method.substring(5);
                        break;
                    }
                    case 'B': {
                        comment = "Boundary #" + method.substring(5);
                        break;
                    }
                    case 'E': {
                        comment = "Exception #" + method.substring(5);
                        break;
                    }
                    case 'V': {
                        comment = "Verifier #" + method.substring(7);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown test abbreviation:" + method + " for " + fqcn);
                    }
                }
                String line = pName + ".Main_" + method + ";";
                for (String className : dependentTestClassNames) {
                    line = line + className + " ";
                }
                String[] pparts = pName.split("\\.");
                String detail = pparts[pparts.length - 1];
                String type = pparts[pparts.length - 2];
                if ("format".equals(type)) {
                    description = "format";
                } else if ("opcodes".equals(type)) {
                    detail = detail.replaceAll("_", "-");
                    detail = detail.replace("-from16", "/from16");
                    detail = detail.replace("-high16", "/high16");
                    detail = detail.replace("-lit8", "/lit8");
                    detail = detail.replace("-lit16", "/lit16");
                    detail = detail.replace("-4", "/4");
                    detail = detail.replace("-16", "/16");
                    detail = detail.replace("-32", "/32");
                    detail = detail.replace("-jumbo", "/jumbo");
                    detail = detail.replace("-range", "/range");
                    detail = detail.replace("-2addr", "/2addr");
                    description = detail = detail.replace("opc-", "");
                } else {
                    description = "verify".equals(type) ? "verifier" : type + " " + detail;
                }
                String string = details = md.title != null ? md.title : "";
                if (md.constraint != null) {
                    details = " Constraint " + md.constraint + ", " + details;
                }
                if (details.length() != 0) {
                    details = details.substring(0, 1).toUpperCase() + details.substring(1);
                }
                line = line + ";" + description + ";" + comment + ";" + details;
                datafileContent = datafileContent + line + "\n";
                this.generateBuildStepFor(pName, method, dependentTestClassNames, targets);
            }
        }
        this.ctsFinish();
        File scriptDataDir = new File(OUTPUT_FOLDER + "/data/");
        scriptDataDir.mkdirs();
        this.writeToFile(new File(scriptDataDir, "scriptdata"), datafileContent);
        if (!this.javacHostJunitBuildStep.build()) {
            System.out.println("main javac cts-host-hostjunit-classes build step failed");
            System.exit(1);
        }
        if (javacBuildStep.build()) {
            for (BuildStep buildStep : targets) {
                if (buildStep.build()) continue;
                System.out.println("building failed. buildStep: " + buildStep.getClass().getName() + ", " + buildStep);
                System.exit(1);
            }
        } else {
            System.out.println("main javac dalvik-cts-buildutil build step failed");
            System.exit(1);
        }
    }

    private void generateBuildStepFor(String pName, String method, Set<String> dependentTestClassNames, Set<BuildStep> targets) {
        for (String dependentTestClassName : dependentTestClassNames) {
            this.generateBuildStepForDependant(dependentTestClassName, targets);
        }
    }

    private void generateBuildStepForDependant(String dependentTestClassName, Set<BuildStep> targets) {
        File sourceFolder = new File(JAVASRC_FOLDER);
        String fileName = dependentTestClassName.replace('.', '/').trim();
        if (new File(sourceFolder, fileName + ".dfh").exists()) {
            BuildStep.BuildFile inputFile = new BuildStep.BuildFile(JAVASRC_FOLDER, fileName + ".dfh");
            BuildStep.BuildFile dexFile = new BuildStep.BuildFile(OUTPUT_FOLDER, fileName + ".dex");
            DFHBuildStep buildStep = new DFHBuildStep(inputFile, dexFile);
            BuildStep.BuildFile jarFile = new BuildStep.BuildFile(OUTPUT_FOLDER, fileName + ".jar");
            JarBuildStep jarBuildStep = new JarBuildStep(dexFile, "classes.dex", jarFile, true);
            jarBuildStep.addChild(buildStep);
            targets.add(jarBuildStep);
            return;
        }
        if (new File(sourceFolder, fileName + ".d").exists()) {
            BuildStep.BuildFile inputFile = new BuildStep.BuildFile(JAVASRC_FOLDER, fileName + ".d");
            BuildStep.BuildFile dexFile = new BuildStep.BuildFile(OUTPUT_FOLDER, fileName + ".dex");
            DasmBuildStep buildStep = new DasmBuildStep(inputFile, dexFile);
            BuildStep.BuildFile jarFile = new BuildStep.BuildFile(OUTPUT_FOLDER, fileName + ".jar");
            JarBuildStep jarBuildStep = new JarBuildStep(dexFile, "classes.dex", jarFile, true);
            jarBuildStep.addChild(buildStep);
            targets.add(jarBuildStep);
            return;
        }
        if (new File(sourceFolder, fileName + ".java").exists()) {
            BuildStep dexBuildStep = this.generateDexBuildStep(COMPILED_CLASSES_FOLDER, fileName);
            targets.add(dexBuildStep);
            return;
        }
        try {
            if (Class.forName(dependentTestClassName) != null) {
                BuildStep dexBuildStep = this.generateDexBuildStep(COMPILED_CLASSES_FOLDER, fileName);
                targets.add(dexBuildStep);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        throw new RuntimeException("neither .dfh,.d,.java file of dependant test class found : " + dependentTestClassName + ";" + fileName);
    }

    private BuildStep generateDexBuildStep(String classFileFolder, String classFileName) {
        BuildStep.BuildFile classFile = new BuildStep.BuildFile(classFileFolder, classFileName + ".class");
        BuildStep.BuildFile tmpJarFile = new BuildStep.BuildFile(OUTPUT_FOLDER, classFileName + "_tmp.jar");
        JarBuildStep jarBuildStep = new JarBuildStep(classFile, classFileName + ".class", tmpJarFile, false);
        BuildStep.BuildFile outputFile = new BuildStep.BuildFile(OUTPUT_FOLDER, classFileName + ".jar");
        DexBuildStep dexBuildStep = new DexBuildStep(tmpJarFile, outputFile, true);
        dexBuildStep.addChild(jarBuildStep);
        return dexBuildStep;
    }

    private Set<String> parseTestClassName(String pName, String classOnlyName, String methodSource) {
        String pattern;
        HashSet<String> entries = new HashSet<String>();
        String opcodeName = classOnlyName.substring(5);
        Scanner scanner = new Scanner(methodSource);
        String[] patterns = new String[]{"new\\s(T_" + opcodeName + "\\w*)", "(T_" + opcodeName + "\\w*)", "new\\s(T\\w*)"};
        String token = null;
        String[] arr$ = patterns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (token = scanner.findWithinHorizon(pattern = arr$[i$], methodSource.length())) == null; ++i$) {
        }
        if (token == null) {
            System.err.println("warning: failed to find dependent test class name: " + pName + ", " + classOnlyName + " in methodSource:\n" + methodSource);
            return entries;
        }
        MatchResult result = scanner.match();
        entries.add((pName + ".d." + result.group(1)).trim());
        Pattern p = Pattern.compile("@uses\\s+(.*)\\s+", 8);
        Matcher m = p.matcher(methodSource);
        while (m.find()) {
            String res = m.group(1);
            entries.add(res.trim());
        }
        return entries;
    }

    private MethodData parseTestMethod(String pname, String classOnlyName, String method) {
        Scanner scanner2;
        Scanner scanner;
        String path = pname.replaceAll("\\.", "/");
        String absPath = JAVASRC_FOLDER + "/" + path + "/" + classOnlyName + ".java";
        File f = new File(absPath);
        try {
            scanner = new Scanner(f);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("error while reading to file: " + e.getClass().getName() + ", msg:" + e.getMessage());
        }
        String methodPattern = "public\\s+void\\s+" + method + "[^\\{]+\\{";
        String token = scanner.findWithinHorizon(methodPattern, (int)f.length());
        if (token == null) {
            throw new RuntimeException("cannot find method source of 'public void" + method + "' in file '" + absPath + "'");
        }
        MatchResult result = scanner.match();
        result.start();
        result.end();
        StringBuilder builder = new StringBuilder();
        try {
            char currentChar;
            FileReader reader = new FileReader(f);
            reader.skip(result.end());
            int blocks = 1;
            block10: while ((currentChar = (char)reader.read()) != '\uffffffff' && blocks > 0) {
                switch (currentChar) {
                    case '}': {
                        --blocks;
                        builder.append(currentChar);
                        continue block10;
                    }
                    case '{': {
                        ++blocks;
                        builder.append(currentChar);
                        continue block10;
                    }
                }
                builder.append(currentChar);
            }
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse", e);
        }
        try {
            scanner2 = new Scanner(f);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("error while reading to file: " + e.getClass().getName() + ", msg:" + e.getMessage());
        }
        String all = new String(FileUtils.readFile((File)f));
        String commentPattern = "/\\*\\*([^{]*)\\*/\\s*" + methodPattern;
        Pattern p = Pattern.compile(commentPattern, 32);
        Matcher m = p.matcher(all);
        String title = null;
        String constraint = null;
        if (m.find()) {
            String res = m.group(1);
            Matcher titleM = Pattern.compile("@title (.*)", 32).matcher(res);
            if (titleM.find()) {
                title = titleM.group(1).replaceAll("\\n     \\*", "");
                title = title.replaceAll("\\n", " ");
                title = title.trim();
            } else {
                System.err.println("warning: no @title found for method " + method + " in " + pname + "," + classOnlyName);
            }
            Matcher constraintM = Pattern.compile("@constraint (.*)").matcher(res);
            if (constraintM.find()) {
                constraint = constraintM.group(1);
                constraint = constraint.trim();
            } else if (method.contains("VFE")) {
                System.err.println("warning: no @constraint for for a VFE method:" + method + " in " + pname + "," + classOnlyName);
            }
        } else {
            System.err.println("warning: no javadoc found for method " + method + " in " + pname + "," + classOnlyName);
        }
        MethodData md = new MethodData();
        md.methodBody = builder.toString();
        md.constraint = constraint;
        md.title = title;
        if (scanner != null) {
            scanner.close();
        }
        if (scanner2 != null) {
            scanner.close();
        }
        return md;
    }

    private void writeToFileMkdir(File file, String content) {
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("failed to create directory: " + parent.getAbsolutePath());
        }
        this.writeToFile(file, content);
    }

    private void writeToFile(File file, String content) {
        try {
            if (file.length() == (long)content.length()) {
                FileReader reader = new FileReader(file);
                char[] charContents = new char[(int)file.length()];
                reader.read(charContents);
                String contents = new String(charContents);
                if (contents.equals(content)) {
                    return;
                }
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            bw.write(content);
            bw.close();
        }
        catch (Exception e) {
            throw new RuntimeException("error while writing to file: " + e.getClass().getName() + ", msg:" + e.getMessage());
        }
    }

    private File getFileFromPackage(String pname, String methodName) throws IOException {
        String path = this.getFileName(pname, methodName, ".java");
        String absPath = MAIN_SRC_OUTPUT_FOLDER + "/" + path;
        File dirPath = new File(absPath);
        File parent = dirPath.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("failed to create directory: " + absPath);
        }
        return dirPath;
    }

    private String getFileName(String pname, String methodName, String extension) {
        String path = pname.replaceAll("\\.", "/");
        return new File(path, "Main_" + methodName + extension).getPath();
    }

    private class MethodData {
        String methodBody;
        String constraint;
        String title;

        private MethodData() {
        }
    }
}

