/*
 * Decompiled with CFR 0.152.
 */
package dot.junit.opcodes.float_to_double;

import dot.junit.DxTestCase;
import dot.junit.DxUtil;
import dot.junit.opcodes.float_to_double.d.T_float_to_double_1;
import dot.junit.opcodes.float_to_double.d.T_float_to_double_7;

public class Test_float_to_double
extends DxTestCase {
    public void testN1() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertEquals((double)0.5, (double)t.run(0.5f), (double)0.0);
    }

    public void testN2() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertEquals((double)1.0, (double)t.run(1.0f), (double)0.0);
    }

    public void testN3() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertEquals((double)-1.0, (double)t.run(-1.0f), (double)0.0);
    }

    public void testN4() {
        T_float_to_double_7 t = new T_float_to_double_7();
        try {
            t.run(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testB1() {
        T_float_to_double_1 t = new T_float_to_double_1();
        double r = 3.4028234663852886E38;
        Test_float_to_double.assertEquals((double)r, (double)t.run(Float.MAX_VALUE), (double)0.0);
    }

    public void testB2() {
        T_float_to_double_1 t = new T_float_to_double_1();
        double r = 1.4E-45f;
        Test_float_to_double.assertEquals((double)r, (double)t.run(Float.MIN_VALUE), (double)0.0);
    }

    public void testB3() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertEquals((double)-0.0, (double)t.run(0.0f), (double)0.0);
    }

    public void testB4() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertTrue((boolean)Double.isNaN(t.run(Float.NaN)));
    }

    public void testB5() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertTrue((boolean)Double.isInfinite(t.run(Float.POSITIVE_INFINITY)));
    }

    public void testB6() {
        T_float_to_double_1 t = new T_float_to_double_1();
        Test_float_to_double.assertTrue((boolean)Double.isInfinite(t.run(Float.NEGATIVE_INFINITY)));
    }

    public void testVFE1() {
        try {
            Class.forName("dot.junit.opcodes.float_to_double.d.T_float_to_double_2");
            Test_float_to_double.fail((String)"expected a verification exception");
        }
        catch (Throwable t) {
            DxUtil.checkVerifyException(t);
        }
    }

    public void testVFE2() {
        try {
            Class.forName("dot.junit.opcodes.float_to_double.d.T_float_to_double_3");
            Test_float_to_double.fail((String)"expected a verification exception");
        }
        catch (Throwable t) {
            DxUtil.checkVerifyException(t);
        }
    }

    public void testVFE3() {
        try {
            Class.forName("dot.junit.opcodes.float_to_double.d.T_float_to_double_4");
            Test_float_to_double.fail((String)"expected a verification exception");
        }
        catch (Throwable t) {
            DxUtil.checkVerifyException(t);
        }
    }

    public void testVFE4() {
        try {
            Class.forName("dot.junit.opcodes.float_to_double.d.T_float_to_double_5");
            Test_float_to_double.fail((String)"expected a verification exception");
        }
        catch (Throwable t) {
            DxUtil.checkVerifyException(t);
        }
    }

    public void testVFE5() {
        try {
            Class.forName("dot.junit.opcodes.float_to_double.d.T_float_to_double_6");
            Test_float_to_double.fail((String)"expected a verification exception");
        }
        catch (Throwable t) {
            DxUtil.checkVerifyException(t);
        }
    }
}

