/*
 * Decompiled with CFR 0.152.
 */
package dot.junit;

public class DxAbstractMain {
    public static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new RuntimeException("AssertionFailedError: not equals. Expected " + expected + " actual " + actual);
        }
    }

    public static void assertEquals(String message, int expected, int actual) {
        if (expected != actual) {
            throw new RuntimeException("AssertionFailedError: not equals: " + message + " Expected " + expected + " actual " + actual);
        }
    }

    public static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new RuntimeException("AssertionFailedError: not equals. Expected " + expected + " actual " + actual);
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        if (!(Math.abs(expected - actual) <= delta)) {
            throw new RuntimeException("AssertionFailedError: not within delta");
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new RuntimeException("AssertionFailedError: not the same");
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("AssertionFailedError: condition was false");
        }
    }

    public static void assertFalse(boolean condition) {
        if (condition) {
            throw new RuntimeException("AssertionFailedError: condition was true");
        }
    }

    public static void assertNotNull(Object object) {
        if (object == null) {
            throw new RuntimeException("AssertionFailedError: object was null");
        }
    }

    public static void assertNull(Object object) {
        if (object != null) {
            throw new RuntimeException("AssertionFailedError: object was not null");
        }
    }

    public static void fail(String message) {
        throw new RuntimeException("AssertionFailedError msg:" + message);
    }
}

