/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiClass;
import com.android.cts.apicoverage.ApiConstructor;
import com.android.cts.apicoverage.ApiCoverage;
import com.android.cts.apicoverage.ApiMethod;
import com.android.cts.apicoverage.ApiPackage;
import com.android.cts.apicoverage.CoverageComparator;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlReport {
    XmlReport() {
    }

    public static void printXmlReport(List<File> testApks, ApiCoverage apiCoverage, OutputStream outputStream) {
        PrintStream out = new PrintStream(outputStream);
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\"  href=\"api-coverage.xsl\"?>");
        SimpleDateFormat format = new SimpleDateFormat("EEE, MMM d, yyyy h:mm a z");
        String date = format.format(new Date(System.currentTimeMillis()));
        out.println("<api-coverage generatedTime=\"" + date + "\">");
        out.println("<debug>");
        out.println("<sources>");
        for (File testApk : testApks) {
            out.println("<apk path=\"" + testApk.getPath() + "\" />");
        }
        out.println("</sources>");
        out.println("</debug>");
        out.println("<api>");
        CoverageComparator comparator = new CoverageComparator();
        ArrayList<ApiPackage> packages = new ArrayList<ApiPackage>(apiCoverage.getPackages());
        Collections.sort(packages, comparator);
        for (ApiPackage pkg : packages) {
            if (!pkg.getName().startsWith("android") || pkg.getTotalMethods() <= 0) continue;
            out.println("<package name=\"" + pkg.getName() + "\" numCovered=\"" + pkg.getNumCoveredMethods() + "\" numTotal=\"" + pkg.getTotalMethods() + "\" coveragePercentage=\"" + Math.round(pkg.getCoveragePercentage()) + "\">");
            ArrayList<ApiClass> classes = new ArrayList<ApiClass>(pkg.getClasses());
            Collections.sort(classes, comparator);
            for (ApiClass apiClass : classes) {
                if (apiClass.getTotalMethods() <= 0) continue;
                out.println("<class name=\"" + apiClass.getName() + "\" numCovered=\"" + apiClass.getNumCoveredMethods() + "\" numTotal=\"" + apiClass.getTotalMethods() + "\" coveragePercentage=\"" + Math.round(apiClass.getCoveragePercentage()) + "\">");
                for (ApiConstructor constructor : apiClass.getConstructors()) {
                    out.println("<constructor name=\"" + constructor.getName() + "\" covered=\"" + constructor.isCovered() + "\">");
                    for (String parameterType : constructor.getParameterTypes()) {
                        out.println("<parameter type=\"" + parameterType + "\" />");
                    }
                    out.println("</constructor>");
                }
                for (ApiMethod method : apiClass.getMethods()) {
                    out.println("<method name=\"" + method.getName() + "\" returnType=\"" + method.getReturnType() + "\" covered=\"" + method.isCovered() + "\">");
                    for (String parameterType : method.getParameterTypes()) {
                        out.println("<parameter type=\"" + parameterType + "\" />");
                    }
                    out.println("</method>");
                }
                out.println("</class>");
            }
            out.println("</package>");
        }
        out.println("</api>");
        out.println("</api-coverage>");
    }
}

