/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiClass;
import com.android.cts.apicoverage.ApiConstructor;
import com.android.cts.apicoverage.ApiCoverage;
import com.android.cts.apicoverage.ApiMethod;
import com.android.cts.apicoverage.ApiPackage;
import com.android.cts.apicoverage.CoverageComparator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class TextReport {
    TextReport() {
    }

    public static void printTextReport(ApiCoverage api, OutputStream outputStream) {
        PrintStream out = new PrintStream(outputStream);
        CoverageComparator comparator = new CoverageComparator();
        ArrayList<ApiPackage> packages = new ArrayList<ApiPackage>(api.getPackages());
        Collections.sort(packages, comparator);
        for (ApiPackage apiPackage : packages) {
            if (!apiPackage.getName().startsWith("android") || apiPackage.getTotalMethods() <= 0) continue;
            TextReport.printPackage(apiPackage, out);
        }
        out.println();
        out.println();
        for (ApiPackage apiPackage : packages) {
            if (!apiPackage.getName().startsWith("android")) continue;
            TextReport.printPackage(apiPackage, out);
            ArrayList<ApiClass> classes = new ArrayList<ApiClass>(apiPackage.getClasses());
            Collections.sort(classes, comparator);
            for (ApiClass apiClass : classes) {
                if (apiClass.getTotalMethods() <= 0) continue;
                TextReport.printClass(apiClass, out);
                ArrayList<ApiConstructor> constructors = new ArrayList<ApiConstructor>(apiClass.getConstructors());
                Collections.sort(constructors);
                for (ApiConstructor constructor : constructors) {
                    TextReport.printConstructor(constructor, out);
                }
                ArrayList<ApiMethod> methods = new ArrayList<ApiMethod>(apiClass.getMethods());
                Collections.sort(methods);
                for (ApiMethod method : methods) {
                    TextReport.printMethod(method, out);
                }
            }
        }
    }

    private static void printPackage(ApiPackage apiPackage, PrintStream out) {
        out.println(apiPackage.getName() + " " + Math.round(apiPackage.getCoveragePercentage()) + "% (" + apiPackage.getNumCoveredMethods() + "/" + apiPackage.getTotalMethods() + ")");
    }

    private static void printClass(ApiClass apiClass, PrintStream out) {
        out.println("  " + apiClass.getName() + " " + Math.round(apiClass.getCoveragePercentage()) + "% (" + apiClass.getNumCoveredMethods() + "/" + apiClass.getTotalMethods() + ") ");
    }

    private static void printConstructor(ApiConstructor constructor, PrintStream out) {
        StringBuilder builder = new StringBuilder("    [").append(constructor.isCovered() ? "X" : " ").append("] ").append(constructor.getName()).append("(");
        List<String> parameterTypes = constructor.getParameterTypes();
        int numParameterTypes = parameterTypes.size();
        for (int i = 0; i < numParameterTypes; ++i) {
            builder.append(parameterTypes.get(i));
            if (i + 1 >= numParameterTypes) continue;
            builder.append(", ");
        }
        out.println(builder.append(")"));
    }

    private static void printMethod(ApiMethod method, PrintStream out) {
        StringBuilder builder = new StringBuilder("    [").append(method.isCovered() ? "X" : " ").append("] ").append(method.getReturnType()).append(" ").append(method.getName()).append("(");
        List<String> parameterTypes = method.getParameterTypes();
        int numParameterTypes = parameterTypes.size();
        for (int i = 0; i < numParameterTypes; ++i) {
            builder.append(parameterTypes.get(i));
            if (i + 1 >= numParameterTypes) continue;
            builder.append(", ");
        }
        out.println(builder.append(")"));
    }
}

