/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiClass;
import com.android.cts.apicoverage.ApiConstructor;
import com.android.cts.apicoverage.ApiCoverage;
import com.android.cts.apicoverage.ApiMethod;
import com.android.cts.apicoverage.ApiPackage;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CurrentXmlHandler
extends DefaultHandler {
    private String mCurrentPackageName;
    private String mCurrentClassName;
    private String mCurrentMethodName;
    private String mCurrentMethodReturnType;
    private List<String> mCurrentParameterTypes = new ArrayList<String>();
    private ApiCoverage mApiCoverage = new ApiCoverage();

    CurrentXmlHandler() {
    }

    public ApiCoverage getApi() {
        return this.mApiCoverage;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if ("package".equalsIgnoreCase(localName)) {
            this.mCurrentPackageName = CurrentXmlHandler.getValue(attributes, "name");
            ApiPackage apiPackage = new ApiPackage(this.mCurrentPackageName);
            this.mApiCoverage.addPackage(apiPackage);
        } else if ("class".equalsIgnoreCase(localName) || "interface".equalsIgnoreCase(localName)) {
            this.mCurrentClassName = CurrentXmlHandler.getValue(attributes, "name");
            ApiClass apiClass = new ApiClass(this.mCurrentClassName);
            ApiPackage apiPackage = this.mApiCoverage.getPackage(this.mCurrentPackageName);
            apiPackage.addClass(apiClass);
        } else if ("constructor".equalsIgnoreCase(localName)) {
            this.mCurrentParameterTypes.clear();
        } else if ("method".equalsIgnoreCase(localName)) {
            this.mCurrentMethodName = CurrentXmlHandler.getValue(attributes, "name");
            this.mCurrentMethodReturnType = CurrentXmlHandler.getValue(attributes, "return");
            this.mCurrentParameterTypes.clear();
        } else if ("parameter".equalsIgnoreCase(localName)) {
            this.mCurrentParameterTypes.add(CurrentXmlHandler.getValue(attributes, "type"));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if ("constructor".equalsIgnoreCase(localName)) {
            ApiConstructor apiConstructor = new ApiConstructor(this.mCurrentClassName, this.mCurrentParameterTypes);
            ApiPackage apiPackage = this.mApiCoverage.getPackage(this.mCurrentPackageName);
            ApiClass apiClass = apiPackage.getClass(this.mCurrentClassName);
            apiClass.addConstructor(apiConstructor);
        } else if ("method".equalsIgnoreCase(localName)) {
            ApiMethod apiMethod = new ApiMethod(this.mCurrentMethodName, this.mCurrentParameterTypes, this.mCurrentMethodReturnType);
            ApiPackage apiPackage = this.mApiCoverage.getPackage(this.mCurrentPackageName);
            ApiClass apiClass = apiPackage.getClass(this.mCurrentClassName);
            apiClass.addMethod(apiMethod);
        }
    }

    static String getValue(Attributes attributes, String key) {
        return attributes.getValue(key).replaceAll("<.+>", "").replace("$", ".");
    }
}

