/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiCoverage;
import com.android.cts.apicoverage.CurrentXmlHandler;
import com.android.cts.apicoverage.DexDepsXmlHandler;
import com.android.cts.apicoverage.HtmlReport;
import com.android.cts.apicoverage.TextReport;
import com.android.cts.apicoverage.XmlReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtsApiCoverage {
    private static final int FORMAT_TXT = 0;
    private static final int FORMAT_XML = 1;
    private static final int FORMAT_HTML = 2;

    private static void printUsage() {
        System.out.println("Usage: cts-api-coverage [OPTION]... [APK]...");
        System.out.println();
        System.out.println("Generates a report about what Android framework methods are called ");
        System.out.println("from the given APKs.");
        System.out.println();
        System.out.println("Use the Makefiles rules in CtsTestCoverage.mk to generate the report ");
        System.out.println("rather than executing this directly. If you still want to run this ");
        System.out.println("directly, then this must be used from the $ANDROID_BUILD_TOP ");
        System.out.println("directory and dexdeps must be built via \"make dexdeps\".");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -o FILE              output file or standard out if not given");
        System.out.println("  -f [txt|xml|html]    format of output");
        System.out.println("  -d PATH              path to dexdeps or expected to be in $PATH");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<File> testApks = new ArrayList<File>();
        File outputFile = null;
        int format = 0;
        String dexDeps = "dexDeps";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-o".equals(args[i])) {
                    outputFile = new File(CtsApiCoverage.getExpectedArg(args, ++i));
                    continue;
                }
                if ("-f".equals(args[i])) {
                    String formatSpec;
                    if ("xml".equalsIgnoreCase(formatSpec = CtsApiCoverage.getExpectedArg(args, ++i))) {
                        format = 1;
                        continue;
                    }
                    if ("txt".equalsIgnoreCase(formatSpec)) {
                        format = 0;
                        continue;
                    }
                    if ("html".equalsIgnoreCase(formatSpec)) {
                        format = 2;
                        continue;
                    }
                    CtsApiCoverage.printUsage();
                    continue;
                }
                if ("-d".equals(args[i])) {
                    dexDeps = CtsApiCoverage.getExpectedArg(args, ++i);
                    continue;
                }
                CtsApiCoverage.printUsage();
                continue;
            }
            testApks.add(new File(args[i]));
        }
        ApiCoverage apiCoverage = CtsApiCoverage.getEmptyApiCoverage();
        for (File testApk : testApks) {
            CtsApiCoverage.addApiCoverage(apiCoverage, testApk, dexDeps);
        }
        CtsApiCoverage.outputCoverageReport(apiCoverage, testApks, outputFile, format);
    }

    private static String getExpectedArg(String[] args, int index) {
        if (index < args.length) {
            return args[index];
        }
        CtsApiCoverage.printUsage();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApiCoverage getEmptyApiCoverage() throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        CurrentXmlHandler currentXmlHandler = new CurrentXmlHandler();
        xmlReader.setContentHandler(currentXmlHandler);
        File currentXml = new File("frameworks/base/api/current.xml");
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(currentXml);
            xmlReader.parse(new InputSource(fileReader));
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return currentXmlHandler.getApi();
    }

    private static void addApiCoverage(ApiCoverage apiCoverage, File testApk, String dexdeps) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        DexDepsXmlHandler dexDepsXmlHandler = new DexDepsXmlHandler(apiCoverage);
        xmlReader.setContentHandler(dexDepsXmlHandler);
        Process process = new ProcessBuilder(dexdeps, "--format=xml", testApk.getPath()).start();
        xmlReader.parse(new InputSource(process.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void outputCoverageReport(ApiCoverage apiCoverage, List<File> testApks, File outputFile, int format) throws IOException, TransformerException, InterruptedException {
        OutputStream out = outputFile != null ? new FileOutputStream(outputFile) : System.out;
        try {
            switch (format) {
                case 0: {
                    TextReport.printTextReport(apiCoverage, out);
                    return;
                }
                case 1: {
                    XmlReport.printXmlReport(testApks, apiCoverage, out);
                    return;
                }
                case 2: {
                    HtmlReport.printHtmlReport(testApks, apiCoverage, out);
                    return;
                }
            }
            return;
        }
        finally {
            out.close();
        }
    }
}

