/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiClass;
import com.android.cts.apicoverage.HasCoverage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiPackage
implements HasCoverage {
    private final String mName;
    private final Map<String, ApiClass> mApiClassMap = new HashMap<String, ApiClass>();

    ApiPackage(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void addClass(ApiClass apiClass) {
        this.mApiClassMap.put(apiClass.getName(), apiClass);
    }

    public ApiClass getClass(String name) {
        return this.mApiClassMap.get(name);
    }

    public Collection<ApiClass> getClasses() {
        return Collections.unmodifiableCollection(this.mApiClassMap.values());
    }

    public int getNumCoveredMethods() {
        int covered = 0;
        for (ApiClass apiClass : this.mApiClassMap.values()) {
            covered += apiClass.getNumCoveredMethods();
        }
        return covered;
    }

    public int getTotalMethods() {
        int total = 0;
        for (ApiClass apiClass : this.mApiClassMap.values()) {
            total += apiClass.getTotalMethods();
        }
        return total;
    }

    @Override
    public float getCoveragePercentage() {
        return (float)this.getNumCoveredMethods() / (float)this.getTotalMethods() * 100.0f;
    }
}

