/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiConstructor;
import com.android.cts.apicoverage.ApiMethod;
import com.android.cts.apicoverage.HasCoverage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiClass
implements Comparable<ApiClass>,
HasCoverage {
    private final String mName;
    private final List<ApiConstructor> mApiConstructors = new ArrayList<ApiConstructor>();
    private final List<ApiMethod> mApiMethods = new ArrayList<ApiMethod>();

    ApiClass(String name) {
        this.mName = name;
    }

    @Override
    public int compareTo(ApiClass another) {
        return this.mName.compareTo(another.mName);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void addConstructor(ApiConstructor constructor) {
        this.mApiConstructors.add(constructor);
    }

    public ApiConstructor getConstructor(List<String> parameterTypes) {
        for (ApiConstructor constructor : this.mApiConstructors) {
            if (!((Object)parameterTypes).equals(constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }

    public Collection<ApiConstructor> getConstructors() {
        return Collections.unmodifiableList(this.mApiConstructors);
    }

    public void addMethod(ApiMethod method) {
        this.mApiMethods.add(method);
    }

    public ApiMethod getMethod(String name, List<String> parameterTypes, String returnType) {
        for (ApiMethod method : this.mApiMethods) {
            if (!name.equals(method.getName()) || !((Object)parameterTypes).equals(method.getParameterTypes()) || !returnType.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public Collection<ApiMethod> getMethods() {
        return Collections.unmodifiableList(this.mApiMethods);
    }

    public int getNumCoveredMethods() {
        int numCovered = 0;
        for (ApiConstructor constructor : this.mApiConstructors) {
            if (!constructor.isCovered()) continue;
            ++numCovered;
        }
        for (ApiMethod method : this.mApiMethods) {
            if (!method.isCovered()) continue;
            ++numCovered;
        }
        return numCovered;
    }

    public int getTotalMethods() {
        return this.mApiConstructors.size() + this.mApiMethods.size();
    }

    @Override
    public float getCoveragePercentage() {
        return (float)this.getNumCoveredMethods() / (float)this.getTotalMethods() * 100.0f;
    }
}

