/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;
import org.clearsilver.JNI;

public class CS {
    public long csptr;
    protected HDF globalHDF = null;
    protected HDF localHDF;
    private CSFileLoader fileLoader = null;

    public CS(HDF ho) {
        this.localHDF = ho;
        this.csptr = this._init(ho.hdfptr);
    }

    public CS(HDF ho, HDF global) {
        this(ho);
        this.globalHDF = global;
        if (global != null) {
            this._setGlobalHdf(this.csptr, global.hdfptr);
        }
    }

    public void setGlobalHDF(HDF global) {
        this._setGlobalHdf(this.csptr, global.hdfptr);
        this.globalHDF = global;
    }

    public HDF getGlobalHDF() {
        return this.globalHDF;
    }

    public void close() {
        if (this.csptr != 0L) {
            this._dealloc(this.csptr);
            this.csptr = 0L;
        }
    }

    public void finalize() {
        this.close();
    }

    public void parseFile(String filename) {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        this._parseFile(this.csptr, filename, this.fileLoader != null);
    }

    public void parseStr(String content) {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        this._parseStr(this.csptr, content);
    }

    public String render() {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        return this._render(this.csptr);
    }

    protected String fileLoad(String filename) throws IOException, FileNotFoundException {
        if (this.csptr == 0L) {
            throw new NullPointerException("CS is closed.");
        }
        CSFileLoader aFileLoader = this.fileLoader;
        if (aFileLoader == null) {
            throw new NullPointerException("No fileLoader specified.");
        }
        String result = aFileLoader.load(this.localHDF, filename);
        if (result == null) {
            throw new NullPointerException("CSFileLoader.load() returned null");
        }
        return result;
    }

    public CSFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(CSFileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    private native long _init(long var1);

    private native void _dealloc(long var1);

    private native void _parseFile(long var1, String var3, boolean var4);

    private native void _parseStr(long var1, String var3);

    private native String _render(long var1);

    private native void _setGlobalHdf(long var1, long var3);

    static {
        JNI.loadLibrary();
    }
}

