/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ApiList;
import com.android.apkcheck.TypeUtils;
import java.util.ArrayList;

public class MethodInfo {
    private String mName;
    private String mReturn;
    private String mNameAndDescriptor;
    private ArrayList<String> mParameters;
    private boolean mParametersNormalized;

    public MethodInfo(String name, String returnType) {
        this.mName = name;
        this.mReturn = returnType;
        this.mParameters = new ArrayList();
    }

    public String getNameAndDescriptor() {
        if (this.mNameAndDescriptor == null) {
            StringBuilder newSig = new StringBuilder(this.mName);
            newSig.append(":(");
            for (int i = 0; i < this.mParameters.size(); ++i) {
                String humanType = this.mParameters.get(i);
                String sigType = TypeUtils.typeToDescriptor(humanType);
                newSig.append(sigType);
            }
            newSig.append(")");
            newSig.append(TypeUtils.typeToDescriptor(this.mReturn));
            this.mNameAndDescriptor = newSig.toString();
        }
        return this.mNameAndDescriptor;
    }

    public void addParameter(String type) {
        this.mParameters.add(type);
        if (this.mNameAndDescriptor != null) {
            System.err.println("WARNING: late add of params to method");
            this.mNameAndDescriptor = null;
        }
    }

    public void normalizeTypes(ApiList apiList) {
        if (!this.mParametersNormalized) {
            this.mReturn = TypeUtils.ambiguousToBinaryName(this.mReturn, apiList);
            for (int i = 0; i < this.mParameters.size(); ++i) {
                String fixed = TypeUtils.ambiguousToBinaryName(this.mParameters.get(i), apiList);
                this.mParameters.set(i, fixed);
            }
            this.mNameAndDescriptor = null;
            this.mParametersNormalized = true;
        }
    }
}

