/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ApiList;
import com.android.apkcheck.TypeUtils;

public class FieldInfo {
    private String mName;
    private String mType;
    private String mNameAndType;
    private boolean mTypeNormalized;

    public FieldInfo(String name, String type) {
        this.mName = name;
        this.mType = type;
    }

    public String getNameAndType() {
        if (this.mNameAndType == null) {
            this.mNameAndType = this.mName + ":" + TypeUtils.typeToDescriptor(this.mType);
        }
        return this.mNameAndType;
    }

    public void normalizeType(ApiList apiList) {
        if (!this.mTypeNormalized) {
            String type = TypeUtils.ambiguousToBinaryName(this.mType, apiList);
            if (!type.equals(this.mType)) {
                this.mType = type;
                this.mNameAndType = null;
            }
            this.mTypeNormalized = true;
        }
    }
}

