/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ApiDescrHandler;
import com.android.apkcheck.ApiList;
import com.android.apkcheck.Builtin;
import com.android.apkcheck.ClassInfo;
import com.android.apkcheck.FieldInfo;
import com.android.apkcheck.MethodInfo;
import com.android.apkcheck.PackageInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ApkCheck {
    private static ApiList sCurrentApk;
    private static boolean sShowWarnings;
    private static boolean sShowErrors;
    private static HashSet<String> sIgnorablePackages;

    public static void main(String[] args) {
        int idx;
        ApiList apiDescr = new ApiList("public-api");
        if (args.length < 2) {
            ApkCheck.usage();
            return;
        }
        for (idx = 0; idx < args.length; ++idx) {
            if (args[idx].equals("--help")) {
                ApkCheck.usage();
                return;
            }
            if (args[idx].startsWith("--uses-library=")) {
                StringReader reader;
                String libName = args[idx].substring(args[idx].indexOf(61) + 1);
                if (!("BUILTIN".equals(libName) ? !ApkCheck.parseXml(apiDescr, reader = Builtin.getReader(), "BUILTIN") : !ApkCheck.parseApiDescr(apiDescr, libName))) continue;
                return;
            }
            if (args[idx].startsWith("--ignore-package=")) {
                String pkgName = args[idx].substring(args[idx].indexOf(61) + 1);
                sIgnorablePackages.add(pkgName);
                continue;
            }
            if (args[idx].equals("--warn")) {
                sShowWarnings = true;
                continue;
            }
            if (args[idx].equals("--no-warn")) {
                sShowWarnings = false;
                continue;
            }
            if (args[idx].equals("--error")) {
                sShowErrors = true;
                continue;
            }
            if (args[idx].equals("--no-error")) {
                sShowErrors = false;
                continue;
            }
            if (!args[idx].startsWith("--")) break;
            if (args[idx].equals("--")) {
                ++idx;
                break;
            }
            System.err.println("ERROR: unknown option " + args[idx] + " (use \"--help\" for usage info)");
            return;
        }
        if (idx > args.length - 2) {
            ApkCheck.usage();
            return;
        }
        if (!ApkCheck.parseApiDescr(apiDescr, args[idx++])) {
            return;
        }
        sCurrentApk = apiDescr;
        ApkCheck.flattenInherited(apiDescr);
        while (idx < args.length) {
            ApiList apkDescr;
            sCurrentApk = apkDescr = new ApiList(args[idx]);
            boolean success = ApkCheck.parseApiDescr(apkDescr, args[idx]);
            if (!success) {
                if (idx < args.length - 1) {
                    System.err.println("Skipping...");
                }
            } else {
                ApkCheck.check(apiDescr, apkDescr);
                System.out.println(args[idx] + ": summary: " + apkDescr.getErrorCount() + " errors, " + apkDescr.getWarningCount() + " warnings\n");
            }
            ++idx;
        }
    }

    static void usage() {
        System.err.println("Android APK checker v1.0");
        System.err.println("Copyright (C) 2010 The Android Open Source Project\n");
        System.err.println("Usage: apkcheck [options] public-api.xml apk1.xml ...\n");
        System.err.println("Options:");
        System.err.println("  --help                  show this message");
        System.err.println("  --uses-library=lib.xml  load additional public API list");
        System.err.println("  --ignore-package=pkg    don't show errors for references to this package");
        System.err.println("  --[no-]warn             enable or disable display of warnings");
        System.err.println("  --[no-]error            enable or disable display of errors");
    }

    static boolean parseApiDescr(ApiList apiList, String fileName) {
        boolean result = false;
        try {
            FileReader fileReader = new FileReader(fileName);
            result = ApkCheck.parseXml(apiList, fileReader, fileName);
            fileReader.close();
        }
        catch (IOException ioe) {
            System.err.println("Error opening " + fileName);
        }
        return result;
    }

    static boolean parseXml(ApiList apiList, Reader reader, String fileName) {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            ApiDescrHandler handler = new ApiDescrHandler(apiList);
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(new InputSource(reader));
            return true;
        }
        catch (SAXParseException ex) {
            System.err.println("Error parsing " + fileName + " line " + ex.getLineNumber() + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            System.err.println("Error while reading " + fileName + ": " + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }

    static void flattenInherited(ApiList pubList) {
        Iterator<PackageInfo> pkgIter = pubList.getPackageIterator();
        while (pkgIter.hasNext()) {
            PackageInfo pubPkgInfo = pkgIter.next();
            Iterator<ClassInfo> classIter = pubPkgInfo.getClassIterator();
            while (classIter.hasNext()) {
                ClassInfo pubClassInfo = classIter.next();
                pubClassInfo.flattenClass(pubList);
            }
        }
    }

    static boolean check(ApiList pubList, ApiList apkDescr) {
        Iterator<PackageInfo> pkgIter = apkDescr.getPackageIterator();
        while (pkgIter.hasNext()) {
            PackageInfo apkPkgInfo = pkgIter.next();
            PackageInfo pubPkgInfo = pubList.getPackage(apkPkgInfo.getName());
            boolean badPackage = false;
            if (pubPkgInfo == null) {
                badPackage = true;
            }
            Iterator<ClassInfo> classIter = apkPkgInfo.getClassIterator();
            while (classIter.hasNext()) {
                ClassInfo apkClassInfo = classIter.next();
                if (badPackage) {
                    if (ApkCheck.isIgnorable(apkPkgInfo)) {
                        ApkCheck.apkWarning("Ignoring class ref: " + apkPkgInfo.getName() + "." + apkClassInfo.getName());
                        continue;
                    }
                    ApkCheck.apkError("Illegal class ref: " + apkPkgInfo.getName() + "." + apkClassInfo.getName());
                    continue;
                }
                ApkCheck.checkClass(pubPkgInfo, apkClassInfo);
            }
        }
        return true;
    }

    static boolean checkClass(PackageInfo pubPkgInfo, ClassInfo classInfo) {
        ClassInfo pubClassInfo = pubPkgInfo.getClass(classInfo.getName());
        if (pubClassInfo == null) {
            if (ApkCheck.isIgnorable(pubPkgInfo)) {
                ApkCheck.apkWarning("Ignoring class ref: " + pubPkgInfo.getName() + "." + classInfo.getName());
            } else if (classInfo.hasNoFieldMethod()) {
                ApkCheck.apkWarning("Hidden class referenced: " + pubPkgInfo.getName() + "." + classInfo.getName());
            } else {
                ApkCheck.apkError("Illegal class ref: " + pubPkgInfo.getName() + "." + classInfo.getName());
            }
            return false;
        }
        Iterator<FieldInfo> fieldIter = classInfo.getFieldIterator();
        while (fieldIter.hasNext()) {
            FieldInfo apkFieldInfo = fieldIter.next();
            String nameAndType = apkFieldInfo.getNameAndType();
            FieldInfo pubFieldInfo = pubClassInfo.getField(nameAndType);
            if (pubFieldInfo != null) continue;
            if (pubClassInfo.isEnum()) {
                ApkCheck.apkWarning("Enum field ref: " + pubPkgInfo.getName() + "." + classInfo.getName() + "." + nameAndType);
                continue;
            }
            ApkCheck.apkError("Illegal field ref: " + pubPkgInfo.getName() + "." + classInfo.getName() + "." + nameAndType);
        }
        Iterator<MethodInfo> methodIter = classInfo.getMethodIterator();
        while (methodIter.hasNext()) {
            MethodInfo apkMethodInfo = methodIter.next();
            String nameAndDescr = apkMethodInfo.getNameAndDescriptor();
            MethodInfo pubMethodInfo = pubClassInfo.getMethod(nameAndDescr);
            if (pubMethodInfo != null) continue;
            pubMethodInfo = pubClassInfo.getMethodIgnoringReturn(nameAndDescr);
            if (pubMethodInfo == null) {
                if (pubClassInfo.isAnnotation()) {
                    ApkCheck.apkWarning("Annotation method ref: " + pubPkgInfo.getName() + "." + classInfo.getName() + "." + nameAndDescr);
                    continue;
                }
                ApkCheck.apkError("Illegal method ref: " + pubPkgInfo.getName() + "." + classInfo.getName() + "." + nameAndDescr);
                continue;
            }
            ApkCheck.apkWarning("Possibly covariant method ref: " + pubPkgInfo.getName() + "." + classInfo.getName() + "." + nameAndDescr);
        }
        return true;
    }

    static boolean isIgnorable(PackageInfo pkgInfo) {
        return sIgnorablePackages.contains(pkgInfo.getName());
    }

    public static void apkWarning(String msg) {
        if (sShowWarnings) {
            System.out.println("(warn) " + sCurrentApk.getDebugString() + ": " + msg);
        }
        sCurrentApk.incrWarnings();
    }

    public static void apkError(String msg) {
        if (sShowErrors) {
            System.out.println(sCurrentApk.getDebugString() + ": " + msg);
        }
        sCurrentApk.incrErrors();
    }

    private static void dumpApi(ApiList apiList) {
        Iterator<PackageInfo> iter = apiList.getPackageIterator();
        while (iter.hasNext()) {
            PackageInfo pkgInfo = iter.next();
            ApkCheck.dumpPackage(pkgInfo);
        }
    }

    private static void dumpPackage(PackageInfo pkgInfo) {
        Iterator<ClassInfo> iter = pkgInfo.getClassIterator();
        System.out.println("PACKAGE " + pkgInfo.getName());
        while (iter.hasNext()) {
            ClassInfo classInfo = iter.next();
            ApkCheck.dumpClass(classInfo);
        }
    }

    private static void dumpClass(ClassInfo classInfo) {
        System.out.println(" CLASS " + classInfo.getName());
        Iterator<FieldInfo> fieldIter = classInfo.getFieldIterator();
        while (fieldIter.hasNext()) {
            FieldInfo fieldInfo = fieldIter.next();
            ApkCheck.dumpField(fieldInfo);
        }
        Iterator<MethodInfo> methIter = classInfo.getMethodIterator();
        while (methIter.hasNext()) {
            MethodInfo methInfo = methIter.next();
            ApkCheck.dumpMethod(methInfo);
        }
    }

    private static void dumpMethod(MethodInfo methInfo) {
        System.out.println("  METHOD " + methInfo.getNameAndDescriptor());
    }

    private static void dumpField(FieldInfo fieldInfo) {
        System.out.println("  FIELD " + fieldInfo.getNameAndType());
    }

    static {
        sShowWarnings = false;
        sShowErrors = true;
        sIgnorablePackages = new HashSet();
    }
}

