/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.PackageInfo;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiList {
    private HashMap<String, PackageInfo> mPackageList = new HashMap();
    private String mDebugString;
    private int mWarnings;
    private int mErrors;

    public ApiList(String debugString) {
        this.mDebugString = debugString;
    }

    public String getDebugString() {
        return this.mDebugString;
    }

    public void incrWarnings() {
        ++this.mWarnings;
    }

    public void incrErrors() {
        ++this.mErrors;
    }

    public int getWarningCount() {
        return this.mWarnings;
    }

    public int getErrorCount() {
        return this.mErrors;
    }

    public PackageInfo getPackage(String name) {
        return this.mPackageList.get(name);
    }

    public PackageInfo getOrCreatePackage(String name) {
        PackageInfo pkgInfo = this.mPackageList.get(name);
        if (pkgInfo == null) {
            pkgInfo = new PackageInfo(name);
            this.mPackageList.put(name, pkgInfo);
        }
        return pkgInfo;
    }

    public Iterator<PackageInfo> getPackageIterator() {
        return this.mPackageList.values().iterator();
    }
}

