/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.ClassInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.SourcePositionInfo;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfo {
    private String mName;
    private HashMap<String, ClassInfo> mClasses;
    private boolean mExistsInBoth;
    private SourcePositionInfo mPosition;

    public PackageInfo(String name, SourcePositionInfo position) {
        this.mName = name;
        this.mClasses = new HashMap();
        this.mExistsInBoth = false;
        this.mPosition = position;
    }

    public void addClass(ClassInfo cl) {
        this.mClasses.put(cl.name(), cl);
    }

    public HashMap<String, ClassInfo> allClasses() {
        return this.mClasses;
    }

    public String name() {
        return this.mName;
    }

    public SourcePositionInfo position() {
        return this.mPosition;
    }

    public boolean isConsistent(PackageInfo pInfo) {
        this.mExistsInBoth = true;
        pInfo.mExistsInBoth = true;
        boolean consistent = true;
        for (ClassInfo cInfo : this.mClasses.values()) {
            if (pInfo.mClasses.containsKey(cInfo.name())) {
                if (cInfo.isConsistent(pInfo.mClasses.get(cInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_CLASS, cInfo.position(), "Removed public class " + cInfo.qualifiedName());
            consistent = false;
        }
        for (ClassInfo cInfo : pInfo.mClasses.values()) {
            if (cInfo.isInBoth()) continue;
            Errors.error(Errors.ADDED_CLASS, cInfo.position(), "Added class " + cInfo.name() + " to package " + pInfo.name());
            consistent = false;
        }
        return consistent;
    }

    public boolean isInBoth() {
        return this.mExistsInBoth;
    }
}

