/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.AbstractMethodInfo;
import com.android.apicheck.ApiInfo;
import com.android.apicheck.ClassInfo;
import com.android.apicheck.ConstructorInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.FieldInfo;
import com.android.apicheck.MethodInfo;
import com.android.apicheck.PackageInfo;
import com.android.apicheck.ParameterInfo;
import com.android.apicheck.SourcePositionInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiCheck {
    private static ArrayList<String[]> parseFlags(ArrayList<String> allArgs) {
        String flag;
        int i;
        ArrayList<String[]> ret = new ArrayList<String[]>();
        for (i = 0; i < allArgs.size() && ((flag = allArgs.get(i)).equals("-error") || flag.equals("-warning") || flag.equals("-hide")); ++i) {
            String[] arg = new String[]{flag, allArgs.get(++i)};
            ret.add(arg);
        }
        while (i > 0) {
            allArgs.remove(0);
            --i;
        }
        return ret;
    }

    public static void main(String[] originalArgs) {
        ArrayList<String> args = new ArrayList<String>(originalArgs.length);
        for (String a : originalArgs) {
            args.add(a);
        }
        ArrayList<String[]> flags = ApiCheck.parseFlags(args);
        for (String[] a : flags) {
            if (!a[0].equals("-error") && !a[0].equals("-warning") && !a[0].equals("-hide")) continue;
            try {
                int level = -1;
                if (a[0].equals("-error")) {
                    level = Errors.ERROR;
                } else if (a[0].equals("-warning")) {
                    level = Errors.WARNING;
                } else if (a[0].equals("-hide")) {
                    level = Errors.HIDDEN;
                }
                Errors.setErrorLevel(Integer.parseInt(a[1]), level);
            }
            catch (NumberFormatException e) {
                System.err.println("Bad argument: " + a[0] + " " + a[1]);
                System.exit(2);
            }
        }
        ApiCheck acheck = new ApiCheck();
        ApiInfo oldApi = acheck.parseApi(args.get(0));
        ApiInfo newApi = acheck.parseApi(args.get(1));
        if (!Errors.hadError) {
            oldApi.isConsistent(newApi);
        }
        Errors.printErrors();
        System.exit(Errors.hadError ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiInfo parseApi(String xmlFile) {
        InputStreamReader fileReader = null;
        try {
            XMLReader xmlreader = XMLReaderFactory.createXMLReader();
            MakeHandler handler = new MakeHandler();
            xmlreader.setContentHandler(handler);
            xmlreader.setErrorHandler(handler);
            fileReader = new FileReader(xmlFile);
            xmlreader.parse(new InputSource(fileReader));
            ApiInfo apiInfo = handler.getApi();
            apiInfo.resolveSuperclasses();
            ApiInfo apiInfo2 = apiInfo;
            return apiInfo2;
        }
        catch (SAXParseException e) {
            Errors.error(Errors.PARSE_ERROR, new SourcePositionInfo(xmlFile, e.getLineNumber(), 0), e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Errors.error(Errors.PARSE_ERROR, new SourcePositionInfo(xmlFile, 0, 0), e.getMessage());
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    private static class MakeHandler
    extends DefaultHandler {
        private ApiInfo mApi;
        private PackageInfo mCurrentPackage;
        private ClassInfo mCurrentClass;
        private AbstractMethodInfo mCurrentMethod;
        private Stack<ClassInfo> mClassScope = new Stack();

        public MakeHandler() {
            this.mApi = new ApiInfo();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("package")) {
                this.mCurrentPackage = new PackageInfo(attributes.getValue("name"), SourcePositionInfo.fromXml(attributes.getValue("source")));
            } else if (qName.equals("class") || qName.equals("interface")) {
                this.mClassScope.push(this.mCurrentClass);
                this.mCurrentClass = new ClassInfo(attributes.getValue("name"), this.mCurrentPackage, attributes.getValue("extends"), qName.equals("interface"), Boolean.valueOf(attributes.getValue("abstract")), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("final")), attributes.getValue("deprecated"), attributes.getValue("visibility"), SourcePositionInfo.fromXml(attributes.getValue("source")), this.mCurrentClass);
            } else if (qName.equals("method")) {
                this.mCurrentMethod = new MethodInfo(attributes.getValue("name"), attributes.getValue("return"), Boolean.valueOf(attributes.getValue("abstract")), Boolean.valueOf(attributes.getValue("native")), Boolean.valueOf(attributes.getValue("synchronized")), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("final")), attributes.getValue("deprecated"), attributes.getValue("visibility"), SourcePositionInfo.fromXml(attributes.getValue("source")), this.mCurrentClass);
            } else if (qName.equals("constructor")) {
                this.mCurrentMethod = new ConstructorInfo(attributes.getValue("name"), attributes.getValue("type"), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("final")), attributes.getValue("deprecated"), attributes.getValue("visibility"), SourcePositionInfo.fromXml(attributes.getValue("source")), this.mCurrentClass);
            } else if (qName.equals("field")) {
                FieldInfo fInfo = new FieldInfo(attributes.getValue("name"), attributes.getValue("type"), Boolean.valueOf(attributes.getValue("transient")), Boolean.valueOf(attributes.getValue("volatile")), attributes.getValue("value"), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("final")), attributes.getValue("deprecated"), attributes.getValue("visibility"), SourcePositionInfo.fromXml(attributes.getValue("source")), this.mCurrentClass);
                this.mCurrentClass.addField(fInfo);
            } else if (qName.equals("parameter")) {
                this.mCurrentMethod.addParameter(new ParameterInfo(attributes.getValue("type"), attributes.getValue("name")));
            } else if (qName.equals("exception")) {
                this.mCurrentMethod.addException(attributes.getValue("type"));
            } else if (qName.equals("implements")) {
                this.mCurrentClass.addInterface(attributes.getValue("name"));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("method")) {
                this.mCurrentClass.addMethod((MethodInfo)this.mCurrentMethod);
            } else if (qName.equals("constructor")) {
                this.mCurrentClass.addConstructor((ConstructorInfo)this.mCurrentMethod);
            } else if (qName.equals("class") || qName.equals("interface")) {
                this.mCurrentPackage.addClass(this.mCurrentClass);
                this.mCurrentClass = this.mClassScope.pop();
            } else if (qName.equals("package")) {
                this.mApi.addPackage(this.mCurrentPackage);
            }
        }

        public ApiInfo getApi() {
            return this.mApi;
        }
    }
}

